/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CounterSigner {
    private int actualIndex = 0;
    private ASN1Set signedAttr2;
    private Map<String, byte[]> atrib2 = new HashMap<String, byte[]>();
    private Map<String, byte[]> uatrib2 = new HashMap<String, byte[]>();

    CounterSigner() {
    }

    byte[] counterSigner(P7ContentSignerParameters parameters, byte[] data, CounterSignTarget targetType, int[] targets, PrivateKey key, java.security.cert.Certificate[] certChain, String dataType, Map<String, byte[]> atri, Map<String, byte[]> uatri) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        this.atrib2 = atri;
        this.uatrib2 = uatri;
        ASN1InputStream is = new ASN1InputStream(data);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ASN1Set signerInfosSd = sd.getSignerInfos();
        BERSet certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            vCertsSig.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certChain[0].getEncoded())));
            certificates = new BERSet(vCertsSig);
        }
        ASN1Set certrevlist = null;
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        if (targetType.equals((Object)CounterSignTarget.TREE)) {
            signerInfos = this.counterTree(signerInfosSd, parameters, key, certChain);
        } else if (targetType.equals((Object)CounterSignTarget.LEAFS)) {
            signerInfos = this.counterLeaf(signerInfosSd, parameters, key, certChain);
        } else {
            if (targetType.equals((Object)CounterSignTarget.NODES)) {
                SignedData aux = sd;
                int nodo = 0;
                int i = targets.length - 1;
                while (i >= 0) {
                    nodo = targets[i];
                    signerInfos = this.counterNode(aux, parameters, key, certChain, nodo);
                    SignedData sigDat = new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos));
                    ASN1InputStream sd2 = new ASN1InputStream(sigDat.getEncoded("DER"));
                    ASN1Sequence contentSignedData2 = (ASN1Sequence)sd2.readObject();
                    sd2.close();
                    aux = SignedData.getInstance(contentSignedData2);
                    --i;
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, aux).getEncoded("DER");
            }
            if (targetType.equals((Object)CounterSignTarget.SIGNERS)) {
                SignedData aux = sd;
                int nodo = 0;
                int i = targets.length - 1;
                while (i >= 0) {
                    nodo = targets[i];
                    signerInfos = this.counterNode(aux, parameters, key, certChain, nodo);
                    SignedData sigDat = new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos));
                    ASN1InputStream sd2 = new ASN1InputStream(sigDat.getEncoded("DER"));
                    ASN1Sequence contentSignedData2 = (ASN1Sequence)sd2.readObject();
                    sd2.close();
                    aux = SignedData.getInstance(contentSignedData2);
                    --i;
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, aux).getEncoded("DER");
            }
        }
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1EncodableVector counterTree(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            ASN1Sequence atribute = (ASN1Sequence)signerInfosRaiz.getObjectAt(i);
            SignerInfo si = new SignerInfo(atribute);
            counterSigners.add(this.getCounterUnsignedAtributes(si, parameters, key, certChain));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            ASN1Sequence atribute = (ASN1Sequence)signerInfosRaiz.getObjectAt(i);
            SignerInfo si = new SignerInfo(atribute);
            counterSigners.add(this.getCounterLeafUnsignedAtributes(si, parameters, key, certChain));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterNode(SignedData sd, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, int nodo) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1Set signerInfosRaiz = sd.getSignerInfos();
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        ASN1Set auxSignerRaiz = signerInfosRaiz;
        this.actualIndex = 0;
        int i = 0;
        while (i < auxSignerRaiz.size()) {
            ASN1Sequence atribute = (ASN1Sequence)auxSignerRaiz.getObjectAt(i);
            SignerInfo si = new SignerInfo(atribute);
            SignerInfo counterSigner = null;
            if (this.actualIndex == nodo) {
                counterSigner = this.getCounterNodeUnsignedAtributes(si, parameters, key, certChain);
            } else if (this.actualIndex != nodo) {
                counterSigner = this.getCounterNodeUnsignedAtributes(si, parameters, key, certChain, nodo);
            }
            ++this.actualIndex;
            counterSigners.add(counterSigner);
            ++i;
        }
        return counterSigners;
    }

    private SignerInfo getCounterUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList attributes = new ArrayList();
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        Object obj = eAtributesData.nextElement();
                        if (obj instanceof ASN1Sequence) {
                            ASN1Sequence atrib = (ASN1Sequence)obj;
                            SignerInfo si = new SignerInfo(atrib);
                            SignerInfo obtained = this.getCounterUnsignedAtributes(si, parameters, key, certChain);
                            signerInfosU.add(obtained);
                            continue;
                        }
                        attributes.add(obj);
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            counterSigner = this.unsignedAtributte(parameters, signerInfo, key, certChain);
            signerInfosU.add(counterSigner);
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter(uAtrib));
            }
        } else {
            signerInfosU2.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo getCounterLeafUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList attributes = new ArrayList();
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        Object obj = eAtributesData.nextElement();
                        if (obj instanceof ASN1Sequence) {
                            SignerInfo si = new SignerInfo((ASN1Sequence)obj);
                            SignerInfo obtained = this.getCounterLeafUnsignedAtributes(si, parameters, key, certChain);
                            signerInfosU.add(obtained);
                            continue;
                        }
                        attributes.add(obj);
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter(uAtrib));
            }
        } else {
            signerInfosU2.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo getCounterNodeUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain) throws NoSuchAlgorithmException, IOException, CertificateException {
        ArrayList attributes = new ArrayList();
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        Object obj = eAtributesData.nextElement();
                        if (obj instanceof ASN1Sequence) {
                            signerInfosU.add(new SignerInfo((ASN1Sequence)obj));
                            continue;
                        }
                        attributes.add(obj);
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            signerInfosU.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter(uAtrib));
            }
        } else {
            signerInfosU2.add(this.unsignedAtributte(parameters, signerInfo, key, certChain));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo getCounterNodeUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, int node) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList attributes = new ArrayList();
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        Object obj = eAtributesData.nextElement();
                        if (obj instanceof ASN1Sequence) {
                            ASN1Sequence atrib = (ASN1Sequence)obj;
                            SignerInfo si = new SignerInfo(atrib);
                            ++this.actualIndex;
                            if (this.actualIndex != node) {
                                if (this.actualIndex < node) {
                                    signerInfosU.add(this.getCounterNodeUnsignedAtributes(si, parameters, key, certChain, node));
                                    continue;
                                }
                                signerInfosU.add(si);
                                continue;
                            }
                            signerInfosU.add(this.getCounterNodeUnsignedAtributes(si, parameters, key, certChain));
                            continue;
                        }
                        attributes.add(obj);
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            }
        } else {
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), null);
        }
        return counterSigner;
    }

    private ASN1Set generateSignerInfo(X509Certificate cert, String digestAlgorithm, byte[] datos) throws NoSuchAlgorithmException {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        contexExpecific.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        contexExpecific.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(digestAlgorithm)).digest(datos)))));
        contexExpecific.add(new Attribute(RFC4519Style.serialNumber, (ASN1Set)new DERSet(new DERPrintableString(cert.getSerialNumber().toString()))));
        if (this.atrib2.size() != 0) {
            for (Map.Entry<String, byte[]> e : this.atrib2.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private ASN1Set generateUnsignerInfo() {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        if (this.uatrib2.size() != 0) {
            for (Map.Entry<String, byte[]> e : this.uatrib2.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private ASN1Set generateUnsignerInfoFromCounter(Attribute uAtrib) {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        if (this.uatrib2.size() != 0) {
            for (Map.Entry<String, byte[]> e : this.uatrib2.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        }
        contexExpecific.add(uAtrib);
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private SignerInfo unsignedAtributte(P7ContentSignerParameters parameters, SignerInfo si, PrivateKey key, java.security.cert.Certificate[] certChain) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1OctetString sign2;
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        ASN1Set signedAttr = this.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, si.getEncryptedDigest().getOctets());
        ASN1Set unsignedAttr = this.generateUnsignerInfo();
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        try {
            sign2 = this.firma(signatureAlgorithm, key);
        }
        catch (Exception ex) {
            throw new IOException("Error realizando la firma: " + ex, ex);
        }
        return new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, unsignedAttr);
    }

    private ASN1OctetString firma(String signatureAlgorithm, PrivateKey key) throws AOException {
        byte[] realSig;
        byte[] tmp;
        Signature sig;
        try {
            sig = Signature.getInstance(signatureAlgorithm);
        }
        catch (Exception e) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + signatureAlgorithm, e);
        }
        try {
            tmp = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException ex) {
            throw new AOException("Error obteniendo los datos a firmar", ex);
        }
        try {
            sig.initSign(key);
        }
        catch (Exception e) {
            throw new AOException("Error al inicializar la firma con la clave privada", e);
        }
        try {
            sig.update(tmp);
        }
        catch (SignatureException e) {
            throw new AOException("Error al configurar la informacion de firma", e);
        }
        try {
            realSig = sig.sign();
        }
        catch (Exception e) {
            throw new AOException("Error durante el proceso de firma", e);
        }
        return new DEROctetString(realSig);
    }
}

