/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSProcessableByteArray;

final class CoSigner {
    private ASN1Set signedAttr2;

    CoSigner() {
    }

    byte[] coSigner(P7ContentSignerParameters parameters, byte[] sign, boolean omitContent, String dataType, PrivateKey key, java.security.cert.Certificate[] certChain, Map<String, byte[]> atrib, Map<String, byte[]> uatrib, byte[] messageDigest) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString sign2;
        ASN1InputStream is = new ASN1InputStream(sign);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ContentInfo encInfo = null;
        ASN1ObjectIdentifier contentTypeOID = new ASN1ObjectIdentifier(dataType);
        byte[] content2 = null;
        if (!omitContent) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            content2 = parameters.getContent();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(content2);
            try {
                msg.write(bOut);
            }
            catch (Exception ex) {
                throw new IOException("Error en la escritura del procesable CMS: " + ex, ex);
            }
            encInfo = new ContentInfo(contentTypeOID, new BEROctetString(bOut.toByteArray()));
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set signedAttr = null;
        signedAttr = messageDigest == null ? this.generateSignerInfo(digestAlgorithm, content2 != null ? content2 : parameters.getContent(), dataType, atrib) : this.generateSignerInfoFromHash((X509Certificate)certChain[0], messageDigest, dataType, atrib);
        ASN1Set unSignedAttr = CoSigner.generateUnsignerInfo(uatrib);
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            signerInfos.add(si);
            ++i;
        }
        try {
            sign2 = this.firma(signatureAlgorithm, key);
        }
        catch (Exception ex) {
            throw new IOException("Error al generar la firma: " + ex, ex);
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, unSignedAttr));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), encInfo, certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    byte[] coSigner(String signatureAlgorithm, X509Certificate[] signerCertificateChain, byte[] sign, String dataType, PrivateKey key, Map<String, byte[]> atrib, Map<String, byte[]> uatrib, byte[] digest) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        ASN1OctetString sign2;
        byte[] messageDigest = digest != null ? (byte[])digest.clone() : null;
        ASN1InputStream is = new ASN1InputStream(sign);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ContentInfo encInfo = sd.getEncapContentInfo();
        DEROctetString contenido = (DEROctetString)encInfo.getContent();
        byte[] contenidoDatos = null;
        if (contenido != null) {
            contenidoDatos = AOUtil.getDataFromInputStream(contenido.getOctetStream());
        }
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (signerCertificateChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            X509Certificate[] x509CertificateArray = signerCertificateChain;
            int n = signerCertificateChain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate element = x509CertificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(signerCertificateChain[0].getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set signedAttr = null;
        ASN1Set unSignedAttr = CoSigner.generateUnsignerInfo(uatrib);
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            AlgorithmIdentifier algHash = si.getDigestAlgorithm();
            if (algHash.getAlgorithm().toString().equals(AOAlgorithmID.getOID(digestAlgorithm))) {
                ASN1Set signedAttrib = si.getAuthenticatedAttributes();
                int s = 0;
                while (s < signedAttrib.size()) {
                    ASN1Sequence elemento = (ASN1Sequence)signedAttrib.getObjectAt(s);
                    DERObjectIdentifier oids = (DERObjectIdentifier)elemento.getObjectAt(0);
                    if (CMSAttributes.messageDigest.getId().toString().equals(oids.toString())) {
                        DERSet derSetHash = (DERSet)elemento.getObjectAt(1);
                        DEROctetString derHash = (DEROctetString)derSetHash.getObjectAt(0);
                        messageDigest = derHash.getOctets();
                    }
                    ++s;
                }
            }
            signerInfos.add(si);
            ++i;
        }
        if (contenidoDatos != null) {
            signedAttr = this.generateSignerInfo(digestAlgorithm, contenidoDatos, dataType, atrib);
        } else if (messageDigest != null) {
            signedAttr = this.generateSignerInfoFromHash(signerCertificateChain[0], messageDigest, dataType, atrib);
        } else {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        try {
            sign2 = this.firma(signatureAlgorithm, key);
        }
        catch (Exception ex) {
            throw new IOException("Error al generar la firma: " + ex, ex);
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, unSignedAttr));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), encInfo, certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1Set generateSignerInfo(String digestAlgorithm, byte[] datos, String dataType, Map<String, byte[]> atrib) throws NoSuchAlgorithmException {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        contexExpecific.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(new DERObjectIdentifier(dataType))));
        contexExpecific.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        byte[] md = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(digestAlgorithm)).digest(datos);
        contexExpecific.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString((byte[])md.clone()))));
        if (atrib.size() != 0) {
            for (Map.Entry<String, byte[]> e : atrib.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private ASN1Set generateSignerInfoFromHash(X509Certificate cert, byte[] datos, String dataType, Map<String, byte[]> atrib) {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        contexExpecific.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(new DERObjectIdentifier(dataType))));
        contexExpecific.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        contexExpecific.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(datos))));
        contexExpecific.add(new Attribute(RFC4519Style.serialNumber, (ASN1Set)new DERSet(new DERPrintableString(cert.getSerialNumber().toString()))));
        if (atrib.size() != 0) {
            for (Map.Entry<String, byte[]> e : atrib.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private static ASN1Set generateUnsignerInfo(Map<String, byte[]> uatrib) {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        if (uatrib.size() != 0) {
            for (Map.Entry<String, byte[]> e : uatrib.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private ASN1OctetString firma(String signatureAlgorithm, PrivateKey key) throws AOException {
        byte[] realSig;
        byte[] tmp;
        Signature sig;
        try {
            sig = Signature.getInstance(signatureAlgorithm);
        }
        catch (Exception e) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + signatureAlgorithm, e);
        }
        try {
            tmp = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException ex) {
            throw new AOException("Error obteniendo los atributos firmados", ex);
        }
        try {
            sig.initSign(key);
        }
        catch (Exception e) {
            throw new AOException("Error al inicializar la firma con la clave privada", e);
        }
        try {
            sig.update(tmp);
        }
        catch (SignatureException e) {
            throw new AOException("Error al configurar la informacion de firma", e);
        }
        try {
            realSig = sig.sign();
        }
        catch (Exception e) {
            throw new AOException("Error durante el proceso de firma", e);
        }
        return new DEROctetString(realSig);
    }
}

