/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cms.CoSigner;
import es.gob.afirma.signers.cms.CounterSigner;
import es.gob.afirma.signers.cms.GenSignedData;
import es.gob.afirma.signers.cms.ValidateCMSSignedData;
import es.gob.afirma.signers.pkcs7.BCChecker;
import es.gob.afirma.signers.pkcs7.ObtainContentSignedData;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class AOCMSSigner
implements AOSigner {
    private String dataType = null;
    private final Map<String, byte[]> atrib = new HashMap<String, byte[]>();
    private final Map<String, byte[]> uatrib = new HashMap<String, byte[]>();
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKey key, Certificate[] certChain, Properties xParams) throws AOException, IOException {
        String mode;
        new BCChecker().checkBouncyCastle();
        Properties extraParams = xParams != null ? xParams : new Properties();
        String precalculatedDigest = extraParams.getProperty("precalculatedHashAlgorithm");
        byte[] messageDigest = null;
        if (precalculatedDigest != null) {
            messageDigest = data;
        }
        P7ContentSignerParameters csp = new P7ContentSignerParameters(data, algorithm);
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        boolean omitContent = (mode = extraParams.getProperty("mode", "explicit")).equals("explicit") || precalculatedDigest != null;
        try {
            return new GenSignedData().generateSignedData(csp, omitContent, Boolean.parseBoolean(extraParams.getProperty("applySystemDate", "true")), this.dataType, key, certChain, this.atrib, this.uatrib, messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOException("Error en el algoritmo de firma: " + e, e);
        }
        catch (CertificateException e) {
            throw new AOException("Error en el certificado de firma: " + e, e);
        }
    }

    @Override
    public byte[] cosign(byte[] data, byte[] sign, String algorithm, PrivateKey key, Certificate[] certChain, Properties xParams) throws AOException, IOException {
        String mode;
        boolean omitContent;
        new BCChecker().checkBouncyCastle();
        Properties extraParams = xParams != null ? xParams : new Properties();
        String precalculatedDigest = extraParams.getProperty("precalculatedHashAlgorithm");
        byte[] messageDigest = null;
        if (precalculatedDigest != null) {
            messageDigest = data;
        }
        P7ContentSignerParameters csp = new P7ContentSignerParameters(data, algorithm);
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        boolean bl = omitContent = (mode = extraParams.getProperty("mode", "explicit")).equals("explicit") || precalculatedDigest != null;
        if (ValidateCMSSignedData.isCMSSignedData(sign)) {
            try {
                return new CoSigner().coSigner(csp, sign, omitContent, this.dataType, key, certChain, this.atrib, this.uatrib, messageDigest);
            }
            catch (Exception e) {
                throw new AOException("Error generando la Cofirma PKCS#7", e);
            }
        }
        throw new AOException("Los datos no se corresponden con una firma CMS valida");
    }

    @Override
    public byte[] cosign(byte[] sign, String algorithm, PrivateKey key, Certificate[] certChain, Properties extraParams) throws AOException, IOException {
        new BCChecker().checkBouncyCastle();
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        if (ValidateCMSSignedData.isCMSSignedData(sign)) {
            try {
                return new CoSigner().coSigner(algorithm, (X509Certificate[])certChain, sign, this.dataType, key, this.atrib, this.uatrib, null);
            }
            catch (Exception e) {
                throw new AOException("Error generando la Cofirma PKCS#7", e);
            }
        }
        throw new AOException("Los datos no se corresponden con una firma CMS valida");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] countersign(byte[] sign, String algorithm, CounterSignTarget targetType, Object[] targets, PrivateKey key, Certificate[] certChain, Properties extraParams) throws AOException, IOException {
        new BCChecker().checkBouncyCastle();
        P7ContentSignerParameters csp = new P7ContentSignerParameters(sign, algorithm);
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        byte[] dataSigned = null;
        if (!ValidateCMSSignedData.isCMSSignedData(sign)) throw new AOException("Los datos no se corresponden con una firma CMS valida");
        try {
            if (targetType == CounterSignTarget.TREE) {
                int[] nodes = new int[1];
                return new CounterSigner().counterSigner(csp, sign, CounterSignTarget.TREE, nodes, key, certChain, this.dataType, this.atrib, this.uatrib);
            }
            if (targetType == CounterSignTarget.LEAFS) {
                int[] nodes = new int[1];
                return new CounterSigner().counterSigner(csp, sign, CounterSignTarget.LEAFS, nodes, key, certChain, this.dataType, this.atrib, this.uatrib);
            }
            if (targetType == CounterSignTarget.NODES) {
                int[] nodesID = new int[targets.length];
                int i = 0;
                while (i < targets.length) {
                    nodesID[i] = (Integer)targets[i];
                    ++i;
                }
                nodesID = ReadNodesTree.simplyArray(nodesID);
                return new CounterSigner().counterSigner(csp, sign, CounterSignTarget.NODES, nodesID, key, certChain, this.dataType, this.atrib, this.uatrib);
            }
            if (targetType != CounterSignTarget.SIGNERS) return dataSigned;
            String[] signers = new String[targets.length];
            int i = 0;
            while (i < targets.length) {
                signers[i] = (String)targets[i];
                ++i;
            }
            ReadNodesTree rn2 = new ReadNodesTree();
            int[] nodes2 = rn2.readNodesFromSigners(signers, sign);
            return new CounterSigner().counterSigner(csp, sign, CounterSignTarget.SIGNERS, nodes2, key, certChain, this.dataType, this.atrib, this.uatrib);
        }
        catch (Exception e) {
            throw new AOException("Error generando la Contrafirma PKCS#7", e);
        }
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] sign, boolean asSimpleSignInfo) throws AOInvalidFormatException {
        new BCChecker().checkBouncyCastle();
        ReadNodesTree rn = new ReadNodesTree();
        try {
            return rn.readNodesTree(sign, asSimpleSignInfo);
        }
        catch (Exception ex) {
            LOGGER.severe(ex.toString());
            return null;
        }
    }

    @Override
    public boolean isSign(byte[] signData) throws IOException {
        if (signData == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return ValidateCMSSignedData.isCMSSignedData(signData);
    }

    @Override
    public boolean isValidDataFile(byte[] data) {
        if (data == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    public void addSignedAttribute(String oid, byte[] value) {
        this.atrib.put(oid, value);
    }

    public void addUnsignedAttribute(String oid, byte[] value) {
        this.uatrib.put(oid, value);
    }

    @Override
    public byte[] getData(byte[] signData) throws AOException, IOException {
        if (signData == null) {
            throw new IllegalArgumentException("Se han introducido datos nulos para su comprobacion");
        }
        if (!ValidateCMSSignedData.isCMSSignedData(signData)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return ObtainContentSignedData.obtainData(signData);
    }

    @Override
    public String getSignedName(String originalName, String inText) {
        return String.valueOf(originalName) + (inText != null ? inText : "") + ".csig";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] signData) throws AOException, IOException {
        if (signData == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(signData)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        AOSignInfo signInfo = new AOSignInfo("CMS/PKCS#7");
        return signInfo;
    }
}

