/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESTriPhaseSigner;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class GenCAdESEPESSignedData {
    private GenCAdESEPESSignedData() {
    }

    public static byte[] generateSignedData(P7ContentSignerParameters parameters, boolean omitContent, AdESPolicy policy, boolean signingCertificateV2, PrivateKey key, Certificate[] certChain, byte[] messageDigest, boolean padesMode, String contentType, String contentDescription) throws NoSuchAlgorithmException, CertificateException, IOException, AOException {
        if (parameters == null) {
            throw new IllegalArgumentException("Los parametros no pueden ser nulos");
        }
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        Date signDate = new Date();
        byte[] content = parameters.getContent();
        byte[] preSignature = CAdESTriPhaseSigner.preSign(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm), omitContent ? null : content, (X509Certificate[])certChain, policy, signingCertificateV2, messageDigest == null && content != null ? MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm)).digest(content) : messageDigest, signDate, padesMode, contentType, contentDescription);
        byte[] signature = new AOPkcs1Signer().sign(preSignature, signatureAlgorithm, key, certChain, null);
        return CAdESTriPhaseSigner.postSign(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm), omitContent ? null : content, (X509Certificate[])certChain, signature, CAdESTriPhaseSigner.preSign(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm), omitContent ? null : content, (X509Certificate[])certChain, policy, signingCertificateV2, messageDigest == null && content != null ? MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm)).digest(content) : messageDigest, signDate, padesMode, contentType, contentDescription));
    }
}

