/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.signers.pkcs7.DigestedData;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class CAdESValidator {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afima");

    private CAdESValidator() {
    }

    static boolean isCAdESData(byte[] data) throws IOException {
        Enumeration e;
        ASN1InputStream is = new ASN1InputStream(data);
        try {
            try {
                e = ((ASN1Sequence)is.readObject()).getObjects();
            }
            catch (ClassCastException ex) {
                is.close();
                return false;
            }
        }
        finally {
            is.close();
        }
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        if (!doi.equals(PKCSObjectIdentifiers.data)) {
            return false;
        }
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        try {
            new DEROctetString(doj.getObject());
        }
        catch (Exception ex) {
            LOGGER.info("Lo datos proporcionados no son de tipo CAdESData: " + ex);
            return false;
        }
        return true;
    }

    public static boolean isCAdESSignedData(byte[] data) throws IOException {
        boolean isValid = false;
        ASN1InputStream is = null;
        try {
            try {
                is = new ASN1InputStream(data);
                ASN1Sequence dsq = (ASN1Sequence)is.readObject();
                Enumeration e = dsq.getObjects();
                DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
                if (doi.equals(PKCSObjectIdentifiers.signedData)) {
                    isValid = true;
                }
                ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
                ASN1Sequence datos = (ASN1Sequence)doj.getObject();
                SignedData sd = SignedData.getInstance(datos);
                ASN1Set signerInfosSd = sd.getSignerInfos();
                int i = 0;
                while (i < signerInfosSd.size()) {
                    SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
                    isValid = CAdESValidator.verifySignerInfo(si);
                    ++i;
                }
            }
            catch (Exception ex) {
                LOGGER.info("Los datos proporcionados no son un SignedData de CAdES: " + ex);
                if (is != null) {
                    is.close();
                }
                return false;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return isValid;
    }

    private static boolean verifySignerInfo(SignerInfo si) {
        boolean isSignerValid = false;
        ASN1Set attrib = si.getAuthenticatedAttributes();
        Enumeration e = attrib.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence seq = (ASN1Sequence)e.nextElement();
            Attribute atribute = new Attribute((ASN1ObjectIdentifier)seq.getObjectAt(0), (ASN1Set)seq.getObjectAt(1));
            if (!atribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signingCertificate) && !atribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) continue;
            isSignerValid = true;
        }
        return isSignerValid;
    }

    static boolean isCAdESDigestedData(byte[] data) throws IOException {
        ASN1Sequence dsq;
        boolean isValid = false;
        ASN1InputStream is = new ASN1InputStream(data);
        try {
            try {
                dsq = (ASN1Sequence)is.readObject();
            }
            catch (Exception e) {
                is.close();
                return false;
            }
        }
        finally {
            is.close();
        }
        Enumeration e = dsq.getObjects();
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        if (doi.equals(PKCSObjectIdentifiers.digestedData)) {
            isValid = true;
        }
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        try {
            new DigestedData((ASN1Sequence)doj.getObject());
        }
        catch (Exception ex) {
            LOGGER.info("Los datos proporcionados no son de tipo CAdESDigestedData: " + ex);
            return false;
        }
        return isValid;
    }

    static boolean isCAdESEncryptedData(byte[] data) throws IOException {
        ASN1Sequence dsq;
        boolean isValid = false;
        ASN1InputStream is = new ASN1InputStream(data);
        try {
            try {
                dsq = (ASN1Sequence)is.readObject();
            }
            catch (Exception e) {
                is.close();
                return false;
            }
        }
        finally {
            is.close();
        }
        Enumeration e = dsq.getObjects();
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        if (doi.equals(PKCSObjectIdentifiers.encryptedData)) {
            isValid = true;
        }
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence asq = (ASN1Sequence)doj.getObject();
        try {
            DERInteger.getInstance(asq.getObjectAt(0));
            EncryptedContentInfo.getInstance(asq.getObjectAt(1));
            if (asq.size() == 3) {
                asq.getObjectAt(2);
            }
        }
        catch (Exception ex) {
            LOGGER.info("Lo datos proporcionados no son de tipo CAdESEncryptedData: " + ex);
            return false;
        }
        return isValid;
    }

    static boolean isCAdESEnvelopedData(byte[] data) throws IOException {
        ASN1Sequence dsq;
        boolean isValid = false;
        ASN1InputStream is = new ASN1InputStream(data);
        try {
            try {
                dsq = (ASN1Sequence)is.readObject();
            }
            catch (Exception e) {
                is.close();
                return false;
            }
        }
        finally {
            is.close();
        }
        Enumeration e = dsq.getObjects();
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        if (doi.equals(PKCSObjectIdentifiers.envelopedData)) {
            isValid = true;
        }
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        try {
            new EnvelopedData((ASN1Sequence)doj.getObject());
        }
        catch (Exception ex) {
            LOGGER.info("Lo datos proporcionados no son de tipo CAdESEnvelopedData: " + ex);
            return false;
        }
        return isValid;
    }

    static boolean isCAdESSignedAndEnvelopedData(byte[] data) throws IOException {
        ASN1Sequence dsq;
        boolean isValid = false;
        ASN1InputStream is = new ASN1InputStream(data);
        try {
            try {
                dsq = (ASN1Sequence)is.readObject();
            }
            catch (Exception e) {
                is.close();
                return false;
            }
        }
        finally {
            is.close();
        }
        is.close();
        Enumeration e = dsq.getObjects();
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        if (doi.equals(PKCSObjectIdentifiers.signedData)) {
            isValid = true;
        }
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence datos = (ASN1Sequence)doj.getObject();
        SignedAndEnvelopedData sd = new SignedAndEnvelopedData(datos);
        ASN1Set signerInfosSd = sd.getSignerInfos();
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            isValid = CAdESValidator.verifySignerInfo(si);
            ++i;
        }
        return isValid;
    }

    public static boolean isCAdESValid(byte[] signData, String type) throws IOException {
        if (type.equals("Data")) {
            return CAdESValidator.isCAdESData(signData);
        }
        if (type.equals("SignedData")) {
            return CAdESValidator.isCAdESSignedData(signData);
        }
        if (type.equals("DigestedData")) {
            return CAdESValidator.isCAdESDigestedData(signData);
        }
        if (type.equals("EncryptedData")) {
            return CAdESValidator.isCAdESEncryptedData(signData);
        }
        if (type.equals("EnvelopedData")) {
            return CAdESValidator.isCAdESEnvelopedData(signData);
        }
        if (type.equals("SignedAndEnvelopedData")) {
            return CAdESValidator.isCAdESSignedAndEnvelopedData(signData);
        }
        LOGGER.warning("Tipo de contenido CADES no reconocido");
        return false;
    }

    public static boolean isCAdESValid(byte[] data) throws IOException {
        if (data == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        boolean valido = CAdESValidator.isCAdESData(data);
        if (!valido) {
            valido = CAdESValidator.isCAdESSignedData(data);
        }
        if (!valido) {
            valido = CAdESValidator.isCAdESDigestedData(data);
        }
        if (!valido) {
            valido = CAdESValidator.isCAdESEncryptedData(data);
        }
        if (!valido) {
            valido = CAdESValidator.isCAdESEnvelopedData(data);
        }
        if (!valido) {
            valido = CAdESValidator.isCAdESSignedAndEnvelopedData(data);
        }
        return valido;
    }
}

