/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.AOSigPolicyQualifierInfo;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

public final class CAdESUtils {
    private CAdESUtils() {
    }

    public static ASN1EncodableVector generateSignerInfo(X509Certificate cert, String digestAlgorithmName, byte[] data, AdESPolicy policy, boolean signingCertificateV2, byte[] messageDigest, Date signDate, boolean padesMode, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateEncodingException {
        TBSCertificateStructure tbs;
        AlgorithmIdentifier digestAlgorithmOID = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithmName));
        ASN1EncodableVector contexExpecific = CAdESUtils.initContexExpecific(digestAlgorithmName, data, PKCSObjectIdentifiers.data.getId(), messageDigest, signDate, padesMode);
        if (signingCertificateV2) {
            tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(cert.getTBSCertificate()));
            GeneralNames gns = new GeneralNames(new GeneralName(tbs.getIssuer()));
            IssuerSerial isuerSerial = new IssuerSerial(gns, tbs.getSerialNumber());
            byte[] certHash = MessageDigest.getInstance(digestAlgorithmName).digest(cert.getEncoded());
            ESSCertIDv2[] essCertIDv2 = new ESSCertIDv2[]{new ESSCertIDv2(digestAlgorithmOID, certHash, isuerSerial)};
            SigningCertificateV2 scv2 = policy.getPolicyIdentifier() != null ? new SigningCertificateV2(essCertIDv2, CAdESUtils.getPolicyInformation(policy)) : new SigningCertificateV2(essCertIDv2);
            contexExpecific.add(new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet(scv2)));
        } else {
            SigningCertificate scv;
            tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(cert.getTBSCertificate()));
            GeneralName gn = new GeneralName(tbs.getIssuer());
            GeneralNames gns = new GeneralNames(gn);
            IssuerSerial isuerSerial = new IssuerSerial(gns, tbs.getSerialNumber());
            byte[] certHash = MessageDigest.getInstance(digestAlgorithmName).digest(cert.getEncoded());
            ESSCertID essCertID = new ESSCertID(certHash, isuerSerial);
            if (policy.getPolicyIdentifier() != null) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(new DERSequence(essCertID));
                v.add(new DERSequence(CAdESUtils.getPolicyInformation(policy)));
                scv = SigningCertificate.getInstance(new DERSequence(v));
            } else {
                scv = new SigningCertificate(essCertID);
            }
            contexExpecific.add(new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Set)new DERSet(scv)));
        }
        if (policy.getPolicyIdentifier() != null) {
            DERObjectIdentifier doiSigPolicyId = new DERObjectIdentifier(policy.getPolicyIdentifier().toLowerCase().replace("urn:oid:", ""));
            AlgorithmIdentifier hashid = policy.getPolicyIdentifierHashAlgorithm() != null ? SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(policy.getPolicyIdentifierHashAlgorithm()))) : digestAlgorithmOID;
            byte[] hashed = policy.getPolicyIdentifierHash() != null ? Base64.decode(policy.getPolicyIdentifierHash()) : new byte[1];
            DigestInfo otherHashAlgAndValue = new DigestInfo(hashid, hashed);
            AOSigPolicyQualifierInfo spqInfo = null;
            if (policy.getPolicyQualifier() != null) {
                spqInfo = new AOSigPolicyQualifierInfo(policy.getPolicyQualifier().toString());
            }
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(doiSigPolicyId);
            v.add(otherHashAlgAndValue.toASN1Primitive());
            if (spqInfo != null) {
                v.add(new DERSequence(spqInfo.toASN1Primitive()));
            }
            DERSequence ds = new DERSequence(v);
            contexExpecific.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, (ASN1Set)new DERSet(ds.toASN1Primitive())));
        }
        if (contentType != null && !padesMode) {
            ContentHints contentHints = contentDescription != null ? new ContentHints(new ASN1ObjectIdentifier(contentType), new DERUTF8String(contentDescription)) : new ContentHints(new ASN1ObjectIdentifier(contentType));
            contexExpecific.add(new Attribute(PKCSObjectIdentifiers.id_aa_contentHint, (ASN1Set)new DERSet(contentHints.toASN1Primitive())));
        }
        return contexExpecific;
    }

    private static PolicyInformation[] getPolicyInformation(AdESPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("La politica de firma no puede ser nula en este punto");
        }
        PolicyQualifierId pqid = PolicyQualifierId.id_qt_cps;
        DERIA5String uri = null;
        if (policy.getPolicyQualifier() != null && !policy.getPolicyQualifier().equals("")) {
            uri = new DERIA5String(policy.getPolicyQualifier().toString());
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        PolicyQualifierInfo pqi = null;
        if (uri != null) {
            v.add(pqid);
            v.add(uri);
            pqi = new PolicyQualifierInfo(new DERSequence(v));
        }
        if (policy.getPolicyQualifier() == null || pqi == null) {
            return new PolicyInformation[]{new PolicyInformation(new ASN1ObjectIdentifier(policy.getPolicyIdentifier().toLowerCase().replace("urn:oid:", "")))};
        }
        return new PolicyInformation[]{new PolicyInformation(new ASN1ObjectIdentifier(policy.getPolicyIdentifier().toLowerCase().replace("urn:oid:", "")), new DERSequence(pqi))};
    }

    static ASN1EncodableVector initContexExpecific(String digestAlgorithm, byte[] data, String dataType, byte[] messageDigest, Date signDate, boolean padesMode) throws NoSuchAlgorithmException {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        if (dataType != null) {
            contexExpecific.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(new DERObjectIdentifier(dataType))));
        }
        if (!padesMode) {
            contexExpecific.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(signDate))));
        }
        contexExpecific.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(messageDigest != null ? messageDigest : MessageDigest.getInstance(digestAlgorithm).digest(data)))));
        return contexExpecific;
    }
}

