/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSProcessableByteArray;

public final class CAdESTriPhaseSigner {
    private CAdESTriPhaseSigner() {
    }

    public static byte[] preSign(String digestAlgorithmName, byte[] content, X509Certificate[] signerCertificateChain, AdESPolicy policy, boolean signingCertificateV2, byte[] messageDigest, Date signDate, boolean padesMode, String contentType, String contentDescription) throws AOException {
        ASN1Set signedAttributes;
        if (signerCertificateChain == null || signerCertificateChain.length == 0) {
            throw new IllegalArgumentException("La cadena de certificados debe contener al menos una entrada");
        }
        try {
            signedAttributes = SigUtils.getAttributeSet(new AttributeTable(CAdESUtils.generateSignerInfo(signerCertificateChain[0], digestAlgorithmName, content, policy, signingCertificateV2, messageDigest, signDate, padesMode, contentType, contentDescription)));
        }
        catch (Exception e) {
            throw new AOException("Error obteniendo los atributos a firmar: " + e, e);
        }
        try {
            return signedAttributes.getEncoded("DER");
        }
        catch (Exception ex) {
            throw new AOException("Error al codificar los datos ASN.1 a firmar finalmente", ex);
        }
    }

    public static byte[] postSign(String digestAlgorithmName, byte[] content, X509Certificate[] signerCertificateChain, byte[] signature, byte[] signedAttributes) throws AOException {
        ContentInfo contentInfo;
        ASN1Set asn1SignedAttributes;
        AlgorithmIdentifier keyAlgorithmIdentifier;
        AlgorithmIdentifier digestAlgorithmOID;
        TBSCertificateStructure tbsCertificateStructure;
        if (signerCertificateChain == null || signerCertificateChain.length == 0) {
            throw new IllegalArgumentException("La cadena de certificados debe contener al menos una entrada");
        }
        try {
            tbsCertificateStructure = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(signerCertificateChain[0].getTBSCertificate()));
        }
        catch (Exception e) {
            throw new AOException("No se ha podido crear la estructura de certificados", e);
        }
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(X500Name.getInstance(tbsCertificateStructure.getIssuer()), tbsCertificateStructure.getSerialNumber().getValue()));
        try {
            digestAlgorithmOID = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithmName));
        }
        catch (Exception e) {
            throw new AOException("Error obteniendo el OID en ASN.1 del algoritmo de huella digital", e);
        }
        try {
            keyAlgorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        }
        catch (Exception e) {
            throw new AOException("Error al codificar el algoritmo de cifrado", e);
        }
        DEROctetString encodedPKCS1Signature = new DEROctetString(signature);
        try {
            asn1SignedAttributes = (ASN1Set)ASN1Primitive.fromByteArray(signedAttributes);
        }
        catch (IOException e) {
            throw new AOException("Error en la inclusion de la recuperacion de los SignedAttibutes", e);
        }
        ASN1EncodableVector signerInfo = new ASN1EncodableVector();
        signerInfo.add(new SignerInfo(signerIdentifier, digestAlgorithmOID, asn1SignedAttributes, keyAlgorithmIdentifier, encodedPKCS1Signature, null));
        if (content != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(content);
            try {
                msg.write(baos);
            }
            catch (Exception e) {
                throw new AOException("Error en la escritura del contenido implicito en el ContentInfo", e);
            }
            contentInfo = new ContentInfo(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId()), new BEROctetString(baos.toByteArray()));
        } else {
            contentInfo = new ContentInfo(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId()), null);
        }
        ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
        X509Certificate[] x509CertificateArray = signerCertificateChain;
        int n = signerCertificateChain.length;
        int e = 0;
        while (e < n) {
            X509Certificate cert = x509CertificateArray[e];
            try {
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(cert.getEncoded())));
            }
            catch (Exception e2) {
                Logger.getLogger("es.gob.afirma").severe("Error insertando el certificado '" + AOUtil.getCN(cert) + "' en la cadena de confianza");
            }
            ++e;
        }
        ASN1Set certificates = SigUtils.createBerSetFromList(ce);
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(digestAlgorithmOID);
        try {
            return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(new DERSet(digestAlgorithms), contentInfo, certificates, null, new DERSet(signerInfo))).getEncoded("DER");
        }
        catch (IOException e3) {
            throw new AOException("Error creando el ContentInfo de CAdES: " + e3, e3);
        }
    }
}

