/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.cades.GenCAdESEPESSignedData;
import es.gob.afirma.signers.pkcs7.BCChecker;
import es.gob.afirma.signers.pkcs7.ObtainContentSignedData;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOCAdESSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKey key, Certificate[] certChain, Properties xParams) throws AOException {
        new BCChecker().checkBouncyCastle();
        Properties extraParams = xParams != null ? xParams : new Properties();
        String precalculatedDigest = extraParams.getProperty("precalculatedHashAlgorithm");
        byte[] messageDigest = null;
        if (precalculatedDigest != null) {
            messageDigest = data;
        }
        boolean signingCertificateV2 = AOSignConstants.isSHA2SignatureAlgorithm(algorithm) ? true : (extraParams.containsKey("signingCertificateV2") ? Boolean.parseBoolean(extraParams.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(algorithm)));
        String mode = extraParams.getProperty("mode", "explicit");
        P7ContentSignerParameters csp = new P7ContentSignerParameters(data, algorithm);
        try {
            boolean omitContent = false;
            if (mode.equals("explicit") || precalculatedDigest != null) {
                omitContent = true;
            }
            String contentTypeOid = "1.2.840.113549.1.7.1";
            String contentDescription = "binary";
            if (data != null) {
                try {
                    MimeHelper mimeHelper = new MimeHelper(data);
                    contentDescription = mimeHelper.getDescription();
                    contentTypeOid = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
                }
                catch (Exception e) {
                    Logger.getLogger("es.gob.afirma").warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + e);
                }
            }
            return GenCAdESEPESSignedData.generateSignedData(csp, omitContent, new AdESPolicy(extraParams), signingCertificateV2, key, certChain, messageDigest, Boolean.parseBoolean(extraParams.getProperty("padesMode", "false")), contentTypeOid, contentDescription);
        }
        catch (Exception e) {
            throw new AOException("Error generando la firma CAdES: " + e, e);
        }
    }

    @Override
    public byte[] cosign(byte[] data, byte[] sign, String algorithm, PrivateKey key, Certificate[] certChain, Properties extraParams) throws AOException {
        new BCChecker().checkBouncyCastle();
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCoSigner").newInstance()).cosign(data, sign, algorithm, key, certChain, extraParams);
        }
        catch (Exception e) {
            throw new AOException("Error general en la cofirma: " + e, e);
        }
    }

    @Override
    public byte[] cosign(byte[] sign, String algorithm, PrivateKey key, Certificate[] certChain, Properties extraParams) throws AOException {
        new BCChecker().checkBouncyCastle();
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCoSigner").newInstance()).cosign(sign, algorithm, key, certChain, extraParams);
        }
        catch (Exception e) {
            throw new AOException("Error general en la cofirma: " + e, e);
        }
    }

    @Override
    public byte[] countersign(byte[] sign, String algorithm, CounterSignTarget targetType, Object[] targets, PrivateKey key, Certificate[] certChain, Properties extraParams) throws AOException {
        new BCChecker().checkBouncyCastle();
        try {
            return ((AOCounterSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCounterSigner").newInstance()).countersign(sign, algorithm, targetType, targets, key, certChain, extraParams);
        }
        catch (Exception e) {
            throw new AOException("Error general en la contrafirma: " + e, e);
        }
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] sign, boolean asSimpleSignInfo) throws AOInvalidFormatException, IOException {
        new BCChecker().checkBouncyCastle();
        if (!CAdESValidator.isCAdESValid(sign)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        try {
            return new ReadNodesTree().readNodesTree(sign, asSimpleSignInfo);
        }
        catch (Exception ex) {
            LOGGER.severe("No se ha podido obtener el arbol de firmantes de la firma, se devolvera null: " + ex);
            return null;
        }
    }

    @Override
    public boolean isSign(byte[] data) throws IOException {
        if (data == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        new BCChecker().checkBouncyCastle();
        return CAdESValidator.isCAdESSignedData(data);
    }

    @Override
    public boolean isValidDataFile(byte[] data) {
        if (data == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public byte[] getData(byte[] signData) throws AOInvalidFormatException, IOException {
        if (signData == null) {
            throw new IllegalArgumentException("Se han introducido datos nulos para su comprobacion");
        }
        new BCChecker().checkBouncyCastle();
        if (!CAdESValidator.isCAdESValid(signData)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return ObtainContentSignedData.obtainData(signData);
    }

    @Override
    public String getSignedName(String originalName, String inText) {
        return String.valueOf(originalName) + (inText != null ? inText : "") + ".csig";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] signData) throws AOInvalidFormatException, IOException {
        if (signData == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(signData)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("CAdES");
    }
}

