/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.pkcs12;

import es.gob.afirma.keystores.main.callbacks.CachePasswordCallback;
import es.gob.afirma.keystores.main.callbacks.NullPasswordCallback;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

public final class Pkcs12KeyStoreManager
extends AOKeyStoreManager {
    private PasswordCallback cachePasswordCallback;

    @Override
    public List<KeyStore> init(AOKeyStore type, InputStream store, PasswordCallback pssCallBack, Object[] params) throws AOKeyStoreManagerException, IOException {
        return this.init(store, pssCallBack);
    }

    private List<KeyStore> init(InputStream store, PasswordCallback pssCallBack) throws AOKeyStoreManagerException, IOException {
        if (store == null) {
            throw new IllegalArgumentException("Es necesario proporcionar el fichero PKCS12 / PFX");
        }
        try {
            this.setKeyStore(KeyStore.getInstance(this.getType().getProviderName()));
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#12 / PFX", e);
        }
        this.cachePasswordCallback = pssCallBack != null ? new CachePasswordCallback(pssCallBack.getPassword()) : new NullPasswordCallback();
        try {
            this.getKeyStore().load(store, this.cachePasswordCallback.getPassword());
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException || e.getCause() instanceof BadPaddingException || e.getCause() instanceof ArithmeticException) {
                throw new IOException("Contrasena invalida: " + e, e);
            }
        }
        catch (CertificateException e) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#12 / PFX solicitado.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#12 / PFX solicitado.", e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.getKeyStore());
        try {
            store.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public AOKeyStore getType() {
        return AOKeyStore.PKCS12;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String alias, PasswordCallback pssCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (this.getKeyStore() == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        try {
            return (KeyStore.PrivateKeyEntry)this.getKeyStore().getEntry(alias, new KeyStore.PasswordProtection(this.cachePasswordCallback.getPassword()));
        }
        catch (Exception exception) {
            try {
                return (KeyStore.PrivateKeyEntry)this.getKeyStore().getEntry(alias, null);
            }
            catch (Exception exception2) {
                return (KeyStore.PrivateKeyEntry)this.getKeyStore().getEntry(alias, pssCallback != null ? new KeyStore.PasswordProtection(pssCallback.getPassword()) : null);
            }
        }
    }
}

