/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

final class NSPreferences {
    private NSPreferences() {
    }

    static String getFireFoxUserProfileDirectory(File iniFile) throws IOException {
        FirefoxProfile profile;
        FirefoxProfile[] profiles;
        if (iniFile == null) {
            throw new IllegalArgumentException("El fichero INI es nulo y no se podra determinar el directorio del usuario de firefox");
        }
        if (!iniFile.exists() || !iniFile.isFile()) {
            throw new IOException("No se ha encontrado el fichero con los perfiles de firefox");
        }
        String currentProfilePath = null;
        FirefoxProfile[] firefoxProfileArray = profiles = NSPreferences.readProfiles(iniFile);
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            profile = firefoxProfileArray[n2];
            if (NSPreferences.isProfileLocked(profile)) {
                currentProfilePath = profile.getAbsolutePath();
                break;
            }
            ++n2;
        }
        if (currentProfilePath == null) {
            firefoxProfileArray = profiles;
            n = profiles.length;
            n2 = 0;
            while (n2 < n) {
                profile = firefoxProfileArray[n2];
                if (profile.isDefault()) {
                    currentProfilePath = profile.getAbsolutePath();
                    break;
                }
                ++n2;
            }
        }
        if (profiles.length > 0) {
            currentProfilePath = profiles[0].getAbsolutePath();
        }
        return currentProfilePath;
    }

    private static FirefoxProfile[] readProfiles(File iniFile) throws IOException {
        String nameAtr = "name=";
        String isRelativeAtr = "isrelative=";
        String pathProfilesAtr = "path=";
        String isDefaultAtr = "default=";
        String line = null;
        ArrayList<FirefoxProfile> profiles = new ArrayList<FirefoxProfile>();
        BufferedReader in = new BufferedReader(new FileReader(iniFile));
        while ((line = in.readLine()) != null) {
            if (!line.trim().toLowerCase().startsWith("[profile")) continue;
            FirefoxProfile profile = new FirefoxProfile();
            while ((line = in.readLine()) != null && line.trim().length() > 0 && !line.trim().toLowerCase().startsWith("[profile")) {
                if (line.trim().toLowerCase().startsWith("name=")) {
                    profile.setName(line.trim().substring("name=".length()));
                    continue;
                }
                if (line.trim().toLowerCase().startsWith("isrelative=")) {
                    profile.setRelative(line.trim().substring("isrelative=".length()).equals("1"));
                    continue;
                }
                if (line.trim().toLowerCase().startsWith("path=")) {
                    profile.setPath(line.trim().substring("path=".length()));
                    continue;
                }
                if (!line.trim().toLowerCase().startsWith("default=")) break;
                profile.setDefault(line.trim().substring("default=".length()).equals("1"));
            }
            if (profile.getName() == null && profile.getPath() == null) continue;
            profile.setAbsolutePath(profile.isRelative() ? new File(iniFile.getParent(), profile.getPath()).toString() : profile.getPath());
            profiles.add(profile);
        }
        in.close();
        return profiles.toArray(new FirefoxProfile[profiles.size()]);
    }

    private static boolean isProfileLocked(FirefoxProfile profile) {
        return new File(profile.getAbsolutePath(), "parent.lock").exists() || new File(profile.getAbsolutePath(), "lock").exists();
    }

    static final class FirefoxProfile {
        private String name = null;
        private boolean relative = true;
        private String path = null;
        private String absolutePath = null;
        private boolean def = false;

        FirefoxProfile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String n) {
            this.name = n;
        }

        boolean isRelative() {
            return this.relative;
        }

        void setRelative(boolean r) {
            this.relative = r;
        }

        String getPath() {
            return this.path;
        }

        void setPath(String p) {
            this.path = p;
        }

        String getAbsolutePath() {
            return this.absolutePath;
        }

        void setAbsolutePath(String ap) {
            this.absolutePath = ap;
        }

        boolean isDefault() {
            return this.def;
        }

        void setDefault(boolean d) {
            this.def = d;
        }
    }
}

