/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.keystores.main.callbacks.UIPasswordCallback;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import es.gob.afirma.keystores.mozilla.FirefoxKeyStoreMessages;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.PasswordCallback;

public final class MozillaUnifiedKeyStoreManager
extends AOKeyStoreManager {
    private static Provider nssProvider = null;
    private Map<String, KeyStore> storesByAlias;
    private final List<KeyStore> kss = new ArrayList<KeyStore>();
    private Object parentComponent = null;
    private PasswordCallback externallPasswordCallback = null;

    /*
     * Unable to fully structure code
     */
    @Override
    public List<KeyStore> init(AOKeyStore type, InputStream store, PasswordCallback pssCallBack, Object[] params) throws AOKeyStoreManagerException {
        p = MozillaUnifiedKeyStoreManager.getNssProvider();
        tmpAlias = new Vector<E>(0).elements();
        this.storesByAlias = new Hashtable<String, KeyStore>();
        keyStore = null;
        if (p != null) {
            try {
                keyStore = KeyStore.getInstance("PKCS11", p);
            }
            catch (Exception e) {
                MozillaUnifiedKeyStoreManager.LOGGER.warning("No se ha podido obtener el KeyStore PKCS#11 NSS del proveedor SunPKCS11, se continuara con los almacenes externos: " + e);
                keyStore = null;
            }
        }
        if (keyStore != null) {
            try {
                keyStore.load(null, new char[0]);
            }
            catch (Exception e) {
                try {
                    keyStore.load(null, this.externallPasswordCallback != null ? this.externallPasswordCallback.getPassword() : new UIPasswordCallback(FirefoxKeyStoreMessages.getString("MozillaUnifiedKeyStoreManager.0"), this.parentComponent).getPassword());
                }
                catch (AOCancelledOperationException e1) {
                    keyStore = null;
                    throw e1;
                }
                catch (Exception e2) {
                    MozillaUnifiedKeyStoreManager.LOGGER.warning("No se ha podido abrir el almacen PKCS#11 NSS del proveedor SunPKCS11, se continuara con los almacenes externos: " + e2);
                    keyStore = null;
                }
            }
            if (keyStore != null) {
                try {
                    tmpAlias = keyStore.aliases();
                }
                catch (Exception e) {
                    MozillaUnifiedKeyStoreManager.LOGGER.warning("El almacen interno de Firefox no devolvio certificados, se continuara con los externos: " + e);
                    keyStore = null;
                }
                while (tmpAlias.hasMoreElements()) {
                    this.storesByAlias.put(((String)tmpAlias.nextElement()).toString(), keyStore);
                }
            }
        }
        if (keyStore != null) {
            this.kss.add(keyStore);
        }
        if ((externalStores = MozillaKeyStoreUtilities.getMozillaPKCS11Modules()).size() > 0) {
            logStr = new StringBuilder("Encontrados los siguientes modulos PKCS#11 externos instalados en Mozilla / Firefox: ");
            for (String key : externalStores.keySet()) {
                logStr.append("'");
                logStr.append(externalStores.get(key));
                logStr.append("' ");
            }
            MozillaUnifiedKeyStoreManager.LOGGER.info(logStr.toString());
        } else {
            MozillaUnifiedKeyStoreManager.LOGGER.info("No se han encontrado modulos PKCS#11 externos instalados en Firefox");
        }
        tmpStore = null;
        for (String descr : externalStores.keySet()) {
            try {
                tmpStore = new AOKeyStoreManager().init(AOKeyStore.PKCS11, null, new UIPasswordCallback(String.valueOf(FirefoxKeyStoreMessages.getString("MozillaUnifiedKeyStoreManager.1")) + " " + MozillaKeyStoreUtilities.getMozModuleName(descr.toString()), this.parentComponent), new String[]{externalStores.get(descr), descr.toString()}).get(0);
            }
            catch (AOCancelledOperationException ex) {
                MozillaUnifiedKeyStoreManager.LOGGER.warning("Se cancelo el acceso al almacen externo  '" + descr + "', se continuara con el siguiente: " + ex);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MozillaUnifiedKeyStoreManager.LOGGER.severe("No se ha podido inicializar el PKCS#11 '" + descr + "': " + ex);
                continue;
            }
            MozillaUnifiedKeyStoreManager.LOGGER.info("El almacen externo '" + descr + "' ha podido inicializarse, se anadiran sus entradas");
            if (keyStore == null) {
                keyStore = tmpStore;
            }
            tmpAlias = new Vector<E>(0).elements();
            try {
                tmpAlias = tmpStore.aliases();
                if (true) ** GOTO lbl80
            }
            catch (Exception ex) {
                MozillaUnifiedKeyStoreManager.LOGGER.warning("Se encontro un error obteniendo los alias del almacen externo '" + descr + "', se continuara con el siguiente: " + ex);
                continue;
            }
            do {
                alias = ((String)tmpAlias.nextElement()).toString();
                this.storesByAlias.put(alias, tmpStore);
                MozillaUnifiedKeyStoreManager.LOGGER.info("Anadida la entrada '" + alias + "' del almacen externo '" + descr + "'");
lbl80:
                // 2 sources

            } while (tmpAlias.hasMoreElements());
            this.kss.add(tmpStore);
        }
        if (this.kss.isEmpty()) {
            throw new AOKeyStoreManagerException("No se ha podido inicializar ningun almacen, interno o externo, de Firefox");
        }
        return this.kss;
    }

    public void setPasswordCallback(PasswordCallback externallPC) {
        this.externallPasswordCallback = externallPC;
    }

    @Override
    public String[] getAliases() {
        if (this.kss == null) {
            LOGGER.warning("Se han pedido los alias de un almacen sin inicializar, se intentara inicializar primero");
            try {
                this.init(null, null, null, null);
            }
            catch (Exception e) {
                LOGGER.severe("No se ha podido inicializar el almacen, se devolvera una lista de alias vacia: " + e);
                return new String[0];
            }
        }
        String[] tmpAlias = new String[this.storesByAlias.size()];
        int i = 0;
        Iterator<String> iterator = this.storesByAlias.keySet().iterator();
        while (iterator.hasNext()) {
            String al;
            tmpAlias[i] = al = iterator.next();
            ++i;
        }
        return (String[])tmpAlias.clone();
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry key = this.getKeyEntry(alias, this.externallPasswordCallback);
        return key != null ? (X509Certificate[])key.getCertificateChain() : null;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String alias, PasswordCallback pssCallback) {
        KeyStore.PrivateKeyEntry keyEntry;
        KeyStore tmpStore = this.storesByAlias.get(alias);
        if (tmpStore == null) {
            LOGGER.warning("No hay ningun almacen de Firefox que contenga un certificado con el alias '" + alias + "', se devolvera null");
            return null;
        }
        try {
            keyEntry = (KeyStore.PrivateKeyEntry)tmpStore.getEntry(alias, new KeyStore.PasswordProtection(pssCallback != null ? pssCallback.getPassword() : null));
        }
        catch (KeyStoreException e) {
            LOGGER.severe("Erro al acceder al almacen para obtener la clave privada del certicado '" + alias + "', se devolvera null: " + e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.severe("No se soporta el algoritmo de la clave privada del certicado '" + alias + "', se devolvera null: " + e);
            return null;
        }
        catch (UnrecoverableEntryException e) {
            LOGGER.severe("No se ha podido obtener la clave privada del certicado '" + alias + "', se devolvera null: " + e);
            return null;
        }
        return keyEntry;
    }

    @Override
    public List<KeyStore> getKeyStores() {
        return this.kss;
    }

    @Override
    public String toString() {
        return "Almacen de claves de tipo Firefox unificado";
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (this.kss == null) {
            LOGGER.warning("El KeyStore actual no esta inicializado, por lo que no se pudo recuperar el certificado '" + alias + "'");
            return null;
        }
        for (KeyStore keyStore : this.kss) {
            try {
                if (!keyStore.containsAlias(alias)) continue;
                return (X509Certificate)keyStore.getCertificate(alias);
            }
            catch (Exception e) {
                LOGGER.info("El KeyStore '" + keyStore + "' no contenia o no pudo recuperar el certificado '" + alias + "', se probara con el siguiente: " + e);
            }
        }
        LOGGER.warning("Ningun KeyStore de Firefox contenia el certificado '" + alias + "', se devolvera null");
        return null;
    }

    public void setParentComponent(Object parent) {
        this.parentComponent = parent;
    }

    private static Provider getNssProvider() {
        if (nssProvider != null) {
            return nssProvider;
        }
        try {
            nssProvider = MozillaKeyStoreUtilities.loadNSS();
        }
        catch (Exception e) {
            LOGGER.severe("Error inicializando el proveedor NSS: " + e);
            nssProvider = null;
        }
        return nssProvider;
    }
}

