/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.main.common.KeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.NSPreferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

final class MozillaKeyStoreUtilitiesWindows {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String P11_CONFIG_VALID_CHARS = ":\\0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.~";
    private static final String SOFTOKN3_DLL = "softokn3.dll";
    private static final String MSVCR100_DLL = "msvcr100.dll";
    private static final String MSVCP100_DLL = "msvcp100.dll";
    private static final String PLC4_DLL = "plc4.dll";
    private static final String PLDS4_DLL = "plds4.dll";
    private static final String NSPR4_DLL = "nspr4.dll";
    private static final String MOZSQLITE3_DLL = "mozsqlite3.dll";
    private static final String MOZCRT19_DLL = "mozcrt19.dll";
    private static final String NSSUTIL3_DLL = "nssutil3.dll";
    private static final String FREEBL3_DLL = "freebl3.dll";
    private static final String NSSDBM3_DLL = "nssdbm3.dll";
    private static final String SQLITE3_DLL = "sqlite3.dll";
    private static final String MOZUTILS_DLL = "mozutils.dll";
    private static final String MOZGLUE_DLL = "mozglue.dll";
    private static final String NSS3_DLL = "nss3.dll";
    private static String appData = null;

    private MozillaKeyStoreUtilitiesWindows() {
    }

    static String getMozillaUserProfileDirectoryWindows() {
        String finalDir;
        block5: {
            File regFile = new File(String.valueOf(MozillaKeyStoreUtilitiesWindows.getWindowsAppDataDir()) + "\\Mozilla\\Firefox\\profiles.ini");
            try {
                if (regFile.exists()) {
                    finalDir = NSPreferences.getFireFoxUserProfileDirectory(regFile);
                    break block5;
                }
                LOGGER.severe("No se ha encontrado el perfil de usuario de Mozilla en su directorio por defecto, se devolvera null");
                return null;
            }
            catch (Exception e) {
                LOGGER.severe("Error analizando el 'profiles.ini' de usuario de Firefox, se devolvera null: " + e);
                return null;
            }
        }
        char[] cArray = finalDir.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (P11_CONFIG_VALID_CHARS.indexOf(c) == -1) {
                finalDir = finalDir.replace(Platform.getUserHome(), KeyStoreUtilities.getShort(Platform.getUserHome()));
                break;
            }
            ++n2;
        }
        return finalDir.replace('\\', '/');
    }

    static String getSystemNSSLibDirWindows() throws IOException {
        String dir = MozillaKeyStoreUtilities.getNssPathFromCompatibilityFile();
        if (dir == null) {
            throw new FileNotFoundException("No se encuentra el dierctorio de NSS en Windows");
        }
        boolean illegalChars = false;
        char[] cArray = dir.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (P11_CONFIG_VALID_CHARS.indexOf(c) == -1) {
                illegalChars = true;
                break;
            }
            ++n2;
        }
        if (illegalChars) {
            try {
                File tmpDir = new File(String.valueOf(new File(Platform.getSystemLibDir()).getParent()) + File.separator + "Temp");
                File tmp = tmpDir.isDirectory() && tmpDir.canWrite() && tmpDir.canRead() ? File.createTempFile("nss", null, tmpDir) : File.createTempFile("nss", null);
                tmp.delete();
                if (!tmp.mkdir()) {
                    throw new AOException("No se ha creado el directorio temporal");
                }
                String dest = String.valueOf(tmp.getCanonicalPath()) + File.separator;
                MozillaKeyStoreUtilitiesWindows.copyFile(new String[]{SOFTOKN3_DLL, MOZSQLITE3_DLL, SQLITE3_DLL, NSS3_DLL, PLDS4_DLL, NSPR4_DLL, PLC4_DLL, MOZCRT19_DLL, NSSUTIL3_DLL, FREEBL3_DLL, NSSDBM3_DLL, MOZUTILS_DLL, MOZGLUE_DLL, MSVCR100_DLL, MSVCP100_DLL}, dir, dest);
                dir = tmp.getCanonicalPath();
            }
            catch (Exception e) {
                LOGGER.warning("No se ha podido duplicar NSS en un directorio temporal, si esta version de JRE esta afectada por el error 6581254 de Java es posible que no pueda cargarse: " + e);
            }
        }
        if (dir != null) {
            return dir;
        }
        throw new FileNotFoundException("No se ha encontrado un NSS compatible en Windows");
    }

    static String[] getSoftkn3DependenciesWindows(String nssPath) {
        return new String[]{String.valueOf(nssPath) + MSVCR100_DLL, String.valueOf(nssPath) + MSVCP100_DLL, String.valueOf(nssPath) + MOZGLUE_DLL, String.valueOf(nssPath) + NSS3_DLL, String.valueOf(nssPath) + MOZUTILS_DLL, String.valueOf(nssPath) + MOZCRT19_DLL, String.valueOf(nssPath) + NSPR4_DLL, String.valueOf(nssPath) + PLDS4_DLL, String.valueOf(nssPath) + PLC4_DLL, String.valueOf(nssPath) + NSSUTIL3_DLL, String.valueOf(nssPath) + MOZSQLITE3_DLL, String.valueOf(nssPath) + SQLITE3_DLL, String.valueOf(nssPath) + NSSDBM3_DLL, String.valueOf(nssPath) + FREEBL3_DLL};
    }

    static String getSoftoknLibNameWindows() {
        return SOFTOKN3_DLL;
    }

    private static String getWindowsAppDataDir() {
        String ret;
        if (appData == null && (ret = System.getenv("AppData")) != null) {
            LOGGER.info("Se ha comprobado la situacion del directorio 'AppData' de Windows a traves de la variable de entorno");
            appData = ret;
        }
        if (appData != null) {
            return appData;
        }
        String probablyPath = "C:\\Users\\" + System.getProperty("user.name") + "\\AppData\\Roaming";
        File f = new File(probablyPath);
        if (f.exists() && f.isDirectory()) {
            appData = probablyPath;
            LOGGER.info("Se ha comprobado la situacion del directorio 'AppData' de Windows manualmente");
            return appData;
        }
        appData = null;
        throw new IllegalStateException("No se ha podido determinar la situacion del directorio 'AppData' de Windows");
    }

    private static void copyFile(String[] fileNames, String sourceDir, String destDir) {
        if (fileNames != null) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                File tmpFile = new File(String.valueOf(sourceDir) + File.separator + f);
                if (tmpFile.exists()) {
                    try {
                        AOUtil.copyFile(tmpFile, new File(String.valueOf(destDir) + f));
                    }
                    catch (IOException e) {
                        LOGGER.warning("No se ha podido copiar '" + f + "' a '" + destDir + "': " + e);
                    }
                }
                ++n2;
            }
        }
    }
}

