/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.mozilla.AOSecMod;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilitiesWindows;
import es.gob.afirma.keystores.mozilla.NSPreferences;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.ScriptEngineManager;

final class MozillaKeyStoreUtilities {
    private static final String LIB_NSPR4_SO = "/lib/libnspr4.so";
    private static final String SOFTOKN3_SO = "libsoftokn3.so";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static String nssLibDir = null;

    private MozillaKeyStoreUtilities() {
    }

    static String createPKCS11NSSConfigFile(String userProfileDirectory, String libDir) {
        String softoknLib = SOFTOKN3_SO;
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            softoknLib = MozillaKeyStoreUtilitiesWindows.getSoftoknLibNameWindows();
        } else if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            softoknLib = "libsoftokn3.dylib";
        }
        StringBuilder buffer = new StringBuilder("name=NSSCrypto-AFirma\r\n");
        buffer.append("library=").append(libDir).append(File.separator).append(softoknLib).append("\n").append("attributes=compatibility\n").append("slot=2\n").append("showInfo=false\n").append("allowSingleThreadedModules=true\n").append("nssArgs=\"").append("configdir='").append(userProfileDirectory).append("' ").append("certPrefix='' ").append("keyPrefix='' ").append("secmod='secmod.db' ").append("flags='readOnly'").append("\"");
        return buffer.toString();
    }

    private static String getSystemNSSLibDirMacOsX() throws FileNotFoundException {
        String[] paths;
        String[] stringArray = paths = new String[]{"/Applications/Firefox.app/Contents/MacOS", "/lib", "/usr/lib", "/usr/lib/nss", "/Applications/Minefield.app/Contents/MacOS"};
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (new File(String.valueOf(path) + "/libsoftokn3.dylib").exists()) {
                nssLibDir = path;
            }
            ++n2;
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en Mac OS X");
        }
        return nssLibDir;
    }

    private static String getSystemNSSLibDirUnix() throws FileNotFoundException {
        String[] paths;
        if (nssLibDir != null && !"".equals(nssLibDir)) {
            return nssLibDir;
        }
        if (new File("/usr/lib/libsoftokn3.so").exists() && new File(LIB_NSPR4_SO).exists()) {
            try {
                System.load(LIB_NSPR4_SO);
                nssLibDir = "/usr/lib";
            }
            catch (Exception e) {
                nssLibDir = null;
                LOGGER.warning("Descartamos el NSS situado entre /lib y /usr/lib porque no puede cargarse adecuadamente: " + e);
            }
            if (nssLibDir != null) {
                return nssLibDir;
            }
        }
        String[] stringArray = paths = new String[]{"/usr/lib/firefox", "/usr/lib/firefox-" + MozillaKeyStoreUtilities.searchLastFirefoxVersion("/usr/lib/"), "/opt/firefox", "/opt/firefox-" + MozillaKeyStoreUtilities.searchLastFirefoxVersion("/opt/"), "/lib", "/usr/lib", "/usr/lib/nss", "/usr/lib/i386-linux-gnu/nss", "/opt/fedora-ds/clients/lib", "/opt/google/chrome", "/usr/lib/thunderbird", "/usr/lib64"};
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String tailingLib = "/libnspr4.so";
            if (new File(String.valueOf(path) + "/mozsqlite3.so").exists()) {
                tailingLib = "/mozsqlite3.so";
            } else if (new File(String.valueOf(path) + "/libmozsqlite3.so").exists()) {
                tailingLib = "/libmozsqlite3.so";
            }
            if (new File(String.valueOf(path) + "/" + SOFTOKN3_SO).exists() && new File(String.valueOf(path) + tailingLib).exists()) {
                try {
                    System.load(String.valueOf(path) + tailingLib);
                    nssLibDir = path;
                }
                catch (Exception e) {
                    nssLibDir = null;
                    LOGGER.warning("Descartamos el NSS situado en '" + path + "' porque no puede cargarse adecuadamente: " + e);
                }
                if (nssLibDir != null) {
                    return nssLibDir;
                }
            }
            ++n2;
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en UNIX");
        }
        return nssLibDir;
    }

    static String getNssPathFromCompatibilityFile() throws IOException {
        File compatibility = new File(String.valueOf(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory()) + File.separator + "compatibility.ini");
        if (compatibility.exists() && compatibility.canRead()) {
            String line;
            FileInputStream fis = new FileInputStream(compatibility);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
            String dir = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("LastPlatformDir=")) continue;
                dir = line.replace("LastPlatformDir=", "").trim();
                break;
            }
            br.close();
            if (dir != null) {
                return dir;
            }
        }
        throw new FileNotFoundException("No se ha podido deternimar el directorio de NSS en Windows a partir de 'compatibility.ini' de Firefox");
    }

    private static String getSystemNSSLibDir() throws IOException {
        File nssDir;
        if (nssLibDir != null) {
            return nssLibDir;
        }
        try {
            nssLibDir = System.getenv("NSS_HOME");
        }
        catch (Exception e) {
            LOGGER.warning("No se tiene acceso a la variable de entorno 'NSS_HOME': " + e);
        }
        if (nssLibDir != null) {
            nssDir = new File(nssLibDir);
            if (nssDir.isDirectory() && nssDir.canRead()) {
                LOGGER.info("Directorio de NSS determinado a partir de la variable de entorno 'NSS_HOME'");
                return nssLibDir;
            }
            LOGGER.warning("La variable de entorno 'NSS_HOME' apunta a un directorio que no existe o sobre el que no se tienen permisos de lectura, se ignorara");
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return MozillaKeyStoreUtilitiesWindows.getSystemNSSLibDirWindows();
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS()) || Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            try {
                nssLibDir = MozillaKeyStoreUtilities.getNssPathFromCompatibilityFile();
                LOGGER.info("Directorio de NSS determinado a partir de 'compatibility.ini' de Firefox");
            }
            catch (Exception e) {
                LOGGER.warning("No se ha podido acceder a 'compatibility.ini' de Mozilla: " + e);
            }
            if (nssLibDir != null) {
                nssDir = new File(nssLibDir);
                if (nssDir.isDirectory() && nssDir.canRead()) {
                    LOGGER.info("Directorio de NSS determinado a partir de 'compatibility.ini' de Mozilla");
                    return nssLibDir;
                }
                LOGGER.warning("'compatibility.ini' de Mozilla apunta a un directorio que no existe o sobre el que no se tienen permisos de lectura, se ignorara");
            }
        }
        if (Platform.getOS().equals((Object)Platform.OS.LINUX) || Platform.getOS().equals((Object)Platform.OS.SOLARIS)) {
            return MozillaKeyStoreUtilities.getSystemNSSLibDirUnix();
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return MozillaKeyStoreUtilities.getSystemNSSLibDirMacOsX();
        }
        throw new FileNotFoundException("No se han encontrado bibliotecas NSS instaladas en su sistema operativo");
    }

    private static String searchLastFirefoxVersion(String startDir) {
        File directoryLib = new File(startDir);
        if (directoryLib.isDirectory()) {
            String[] filenames = directoryLib.list();
            ArrayList<String> firefoxDirectories = new ArrayList<String>();
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                if (filename.startsWith("firefox-")) {
                    firefoxDirectories.add(filename.replace("firefox-", ""));
                }
                ++n2;
            }
            if (firefoxDirectories.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < firefoxDirectories.size()) {
                try {
                    Integer.getInteger((String)firefoxDirectories.get(i));
                }
                catch (Exception e) {
                    firefoxDirectories.remove(i);
                }
                ++i;
            }
            if (firefoxDirectories.size() == 1) {
                return (String)firefoxDirectories.get(0);
            }
            Collections.sort(firefoxDirectories, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            return (String)firefoxDirectories.get(0);
        }
        return "";
    }

    static Map<String, String> getMozillaPKCS11Modules() {
        try {
            Hashtable<String, String> modsByDesc = new Hashtable<String, String>();
            for (AOSecMod.ModuleName module : AOSecMod.getModules(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory())) {
                modsByDesc.put(module.getDescription(), module.getLib());
            }
            return MozillaKeyStoreUtilities.purgeStoresTable(modsByDesc);
        }
        catch (Exception t) {
            LOGGER.severe("No se han podido obtener los modulos externos de Mozilla, se devolvera una lista vacia o unicamente con el DNIe: " + t);
            return new Hashtable<String, String>(0);
        }
    }

    static String getMozModuleName(String description) {
        int ini = description.indexOf(40);
        if (ini > 0) {
            return description.substring(0, ini).trim();
        }
        return description;
    }

    private static Map<String, String> purgeStoresTable(Map<String, String> table) {
        if (table == null) {
            return new Hashtable<String, String>(0);
        }
        Hashtable<String, String> purgedTable = new Hashtable<String, String>();
        HashSet<String> revisedLibs = new HashSet<String>();
        for (String key : table.keySet()) {
            String tmpLib = table.get(key);
            if (tmpLib.toLowerCase().endsWith(".dll")) {
                tmpLib = tmpLib.toLowerCase();
            }
            if (!revisedLibs.contains(tmpLib) && !tmpLib.toLowerCase().contains("nssckbi")) {
                purgedTable.put(key, table.get(key));
                revisedLibs.add(tmpLib);
                continue;
            }
            LOGGER.warning("Se eliminara el modulo '" + key + "' porque ya existe uno con la misma biblioteca o es un modulo de certificados raiz: " + table.get(key));
        }
        return purgedTable;
    }

    static void loadNSSDependencies(String nssDirectory) {
        String[] dependList;
        if (Platform.OS.LINUX.equals((Object)Platform.getOS()) && new File("/usr/lib/libsoftokn3.so").exists() && new File(LIB_NSPR4_SO).exists()) {
            dependList = new String[]{"/lib/libmozglue.so", "/usr/lib/libmozglue.so", LIB_NSPR4_SO, "/lib/libplds4.so", "/usr/lib/libplds4.so", "/lib/libplc4.so", "/usr/lib/libplc4.so", "/lib/libnssutil3.so", "/usr/lib/libnssutil3.so", "/lib/libsqlite3.so", "/usr/lib/libsqlite3.so", "/lib/libmozsqlite3.so", "/usr/lib/libmozsqlite3.so"};
        } else {
            String path = String.valueOf(nssDirectory) + (nssDirectory.endsWith(File.separator) ? "" : File.separator);
            dependList = MozillaKeyStoreUtilities.getSoftkn3Dependencies(path);
        }
        String[] stringArray = dependList;
        int n = dependList.length;
        int n2 = 0;
        while (n2 < n) {
            String libPath = stringArray[n2];
            try {
                if (new File(libPath).exists()) {
                    System.load(libPath);
                }
            }
            catch (Error e) {
                LOGGER.warning("Error al cargar la biblioteca " + libPath + " para el acceso al almacen de claves de Mozilla: " + e);
            }
            ++n2;
        }
    }

    private static String[] getSoftkn3Dependencies(String path) {
        String nssPath;
        if (path == null) {
            return new String[0];
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return new String[0];
        }
        String string = nssPath = !path.endsWith(File.separator) ? String.valueOf(path) + File.separator : path;
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return MozillaKeyStoreUtilitiesWindows.getSoftkn3DependenciesWindows(nssPath);
        }
        if (Platform.getOS().equals((Object)Platform.OS.LINUX) || Platform.getOS().equals((Object)Platform.OS.SOLARIS)) {
            return new String[]{String.valueOf(nssPath) + "libnspr4.so", String.valueOf(nssPath) + "libplds4.so", String.valueOf(nssPath) + "libplc4.so", String.valueOf(nssPath) + "libnssutil3.so", String.valueOf(nssPath) + "libsqlite3.so", String.valueOf(nssPath) + "libmozsqlite3.so"};
        }
        LOGGER.warning("Plataforma no soportada para la precarga de las bibliotecas NSS: " + (Object)((Object)Platform.getOS()));
        return new String[0];
    }

    private static String getMozillaUserProfileDirectoryUnix() {
        File regFile = new File(String.valueOf(Platform.getUserHome()) + "/.mozilla/firefox/profiles.ini");
        try {
            if (regFile.exists()) {
                return NSPreferences.getFireFoxUserProfileDirectory(regFile);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error obteniendo el directorio de perfil de usuario de Firefox (UNIX), se devolvera null: " + e);
        }
        return null;
    }

    private static String getMozillaUserProfileDirectoryMacOsX() {
        File regFile = new File(String.valueOf(Platform.getUserHome()) + "/Library/Application Support/Firefox/profiles.ini");
        try {
            if (regFile.exists()) {
                return NSPreferences.getFireFoxUserProfileDirectory(regFile);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error obteniendo el directorio de perfil de usuario de Firefox (" + regFile.getAbsolutePath() + "), se devolvera null: " + e);
        }
        return null;
    }

    static String getMozillaUserProfileDirectory() {
        String profileDir = null;
        try {
            profileDir = System.getenv("PROFILE_HOME");
        }
        catch (Exception e) {
            LOGGER.warning("No se tiene acceso a la variable de entorno 'PROFILE_HOME': " + e);
        }
        if (profileDir != null) {
            File nssDir = new File(profileDir);
            if (nssDir.isDirectory() && nssDir.canRead()) {
                LOGGER.info("Directorio de perfil de usuario Firefox determinado a partir de la variable de entorno 'PROFILE_HOME'");
                return profileDir;
            }
            LOGGER.warning("La variable de entorno 'PROFILE_HOME' apunta a un directorio que no existe o sobre el que no se tienen permisos de lectura, se ignorara");
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilitiesWindows.getMozillaUserProfileDirectoryWindows();
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilities.getMozillaUserProfileDirectoryMacOsX();
        }
        return MozillaKeyStoreUtilities.getMozillaUserProfileDirectoryUnix();
    }

    static void configureMacNSS(String binDir) throws AOException {
        if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            return;
        }
        if (binDir == null) {
            LOGGER.severe("El directorio de NSS para configurar proporcionado es nulo, no se realizara ninguna accion");
            return;
        }
        String nssBinDir = binDir.endsWith("/") ? binDir : String.valueOf(binDir) + "/";
        try {
            System.load(String.valueOf(nssBinDir) + "libsoftokn3.dylib");
            return;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        String[] libs = new String[]{"libmozglue.dylib", "libmozutils.dylib", "libnspr4.dylib", "libplds4.dylib", "libplc4.dylib", "libnssutil3.dylib", "libmozsqlite3.dylib"};
        StringBuilder sb = new StringBuilder();
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            if (new File(String.valueOf(nssBinDir) + lib).exists()) {
                sb.append("ln -s ");
                sb.append(nssBinDir);
                sb.append(lib);
                sb.append(" /usr/lib/");
                sb.append(lib);
                sb.append("; ");
            }
            ++n2;
        }
        try {
            new ScriptEngineManager().getEngineByName("AppleScript").eval("do shell script \"" + sb.toString() + "\" with administrator privileges");
        }
        catch (Exception e) {
            LOGGER.severe("No se ha podido crear los enlaces simbolicos para NSS: " + e);
        }
        try {
            System.load(String.valueOf(nssBinDir) + "libsoftokn3.dylib");
        }
        catch (Exception e) {
            throw new AOException("La configuracion de NSS para Mac OS X ha fallado por motivos de seguridad: " + e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new AOException("La configuracion de NSS para Mac OS X ha fallado: " + e);
        }
    }

    static Provider loadNSS() throws IOException, AOException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        String nssDirectory = MozillaKeyStoreUtilities.getSystemNSSLibDir();
        String p11NSSConfigFile = MozillaKeyStoreUtilities.createPKCS11NSSConfigFile(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory(), nssDirectory);
        LOGGER.info("Configuracion de NSS para SunPKCS11:\n" + p11NSSConfigFile);
        Provider p = null;
        try {
            p = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(p11NSSConfigFile.getBytes()));
        }
        catch (Exception e) {
            if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                MozillaKeyStoreUtilities.configureMacNSS(nssDirectory);
            } else {
                MozillaKeyStoreUtilities.loadNSSDependencies(nssDirectory);
            }
            try {
                p = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(p11NSSConfigFile.getBytes()));
            }
            catch (Exception e2) {
                p = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(p11NSSConfigFile.getBytes()));
            }
        }
        Security.addProvider(p);
        LOGGER.info("Proveedor PKCS#11 para Firefox anadido");
        return p;
    }
}

