/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

final class AOSecMod {
    private static List<ModuleName> modules = null;

    private AOSecMod() {
    }

    private static ModuleName processNames(byte[] secmoddb, int namesOffset) {
        String trueLibName;
        int namesRunningOffset = namesOffset;
        int len = AOSecMod.getShort(secmoddb, namesRunningOffset + 0);
        String commonName = new String(secmoddb, namesRunningOffset + 2, len);
        namesRunningOffset += len + 2;
        len = AOSecMod.getShort(secmoddb, namesRunningOffset);
        String libName = new String(secmoddb, namesRunningOffset + 2, len);
        if ((Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && (libName.endsWith(".DLL") || libName.endsWith(".dll")) || !Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && (libName.endsWith(".so") || libName.contains(".so.") || libName.endsWith(".dylib"))) && (trueLibName = AOSecMod.searchPathForFile(new String[]{libName})) != null) {
            return new ModuleName(trueLibName, commonName);
        }
        throw new UnsupportedOperationException("Intento fallido: " + libName);
    }

    static List<ModuleName> getModules(String dir) throws AOException {
        if (dir == null || "".equals(dir)) {
            throw new IllegalArgumentException("El directorio del perfil de Mozilla no puede ser nulo");
        }
        String profileDir = dir;
        if (modules == null) {
            byte[] secMod;
            File secmod;
            if (!(profileDir = profileDir.replace("\\ ", " ")).endsWith("/")) {
                profileDir = String.valueOf(profileDir) + "/";
            }
            if (!(secmod = new File(String.valueOf(profileDir) + "secmod.db")).exists()) {
                throw new AOException("El directorio del perfil de Mozilla proporcionado no contiene una base de datos de modulos (secmod.db)");
            }
            try {
                secMod = AOUtil.getDataFromInputStream(AOUtil.loadFile(AOUtil.createURI(secmod.getAbsolutePath())));
            }
            catch (Exception e) {
                throw new AOException("Error leyendo la base de datos de modulos (secmod.db)", e);
            }
            modules = new ArrayList<ModuleName>();
            HashSet<String> libs = new HashSet<String>();
            int i = 0;
            while (i < secMod.length) {
                try {
                    ModuleName module = AOSecMod.processNames(secMod, i);
                    if (!libs.contains(module.getLib())) {
                        libs.add(module.getLib());
                        modules.add(module);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return modules;
    }

    private static int getShort(byte[] src, int offset) {
        return src[offset + 0] << 8 | src[offset + 1];
    }

    private static String searchPathForFile(String[] files) {
        if (files == null || files.length < 1) {
            return null;
        }
        if (new File(files[0]).exists()) {
            return files[0];
        }
        StringTokenizer st = new StringTokenizer(Platform.getJavaLibraryPath(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String libPath = st.nextToken();
            if (!libPath.endsWith(File.separator)) {
                libPath = String.valueOf(libPath) + File.separator;
            }
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                File tmpFile = new File(String.valueOf(libPath) + f);
                if (tmpFile.exists() && !tmpFile.isDirectory()) {
                    return String.valueOf(libPath) + f;
                }
                ++n2;
            }
        }
        return null;
    }

    static class ModuleName {
        private final String lib;
        private final String description;

        ModuleName(String l, String d) {
            this.lib = l;
            this.description = d;
        }

        String getLib() {
            return this.lib;
        }

        String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.valueOf(this.description) + " (EXTERNAL, " + this.lib + ", slot 0)";
        }
    }
}

