/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.main.filters;

import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.filters.CertificateFilter;
import java.security.cert.X509Certificate;

public final class MultipleCertificateFilter
extends CertificateFilter {
    private final CertificateFilter[] filters;

    public MultipleCertificateFilter(CertificateFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException("Listado nulo de filtros de certificados");
        }
        this.filters = (CertificateFilter[])filters.clone();
    }

    @Override
    public boolean matches(X509Certificate cert) {
        CertificateFilter[] certificateFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            CertificateFilter filter = certificateFilterArray[n2];
            if (!filter.matches(cert)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String[] matches(String[] aliases, AOKeyStoreManager ksm) {
        String[] filteredAliases = (String[])aliases.clone();
        CertificateFilter[] certificateFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            CertificateFilter filter = certificateFilterArray[n2];
            filteredAliases = filter.matches(filteredAliases, ksm);
            ++n2;
        }
        return filteredAliases;
    }
}

