/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.main.common;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.NameCertificateBean;
import es.gob.afirma.keystores.main.callbacks.CachePasswordCallback;
import es.gob.afirma.keystores.main.callbacks.NullPasswordCallback;
import es.gob.afirma.keystores.main.callbacks.UIPasswordCallback;
import es.gob.afirma.keystores.main.common.AOCertificatesNotFoundException;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import es.gob.afirma.keystores.main.common.KeyStoreMessages;
import es.gob.afirma.keystores.main.filters.CertificateFilter;
import java.io.File;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class KeyStoreUtilities {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String OPENSC_USR_LIB_LINUX = "/usr/lib/opensc-pkcs11.so";
    private static final String[] FNMT_PKCS11_LIBS_WITHOUT_SHA1 = new String[]{"DNIe_P11_priv.dll", "DNIe_P11_pub.dll", "FNMT_P11.dll", "UsrPkcs11.dll", "UsrPubPkcs11.dll"};
    private static final int ALIAS_MAX_LENGTH = 120;

    private KeyStoreUtilities() {
    }

    static String createPKCS11ConfigFile(String lib, String name, Integer slot) {
        StringBuilder buffer = new StringBuilder("library=");
        buffer.append(KeyStoreUtilities.getShort(lib)).append("\r\n").append("name=").append(name != null ? name : "AFIRMA-PKCS11").append("\r\nshowInfo=false\r\n");
        if (slot != null) {
            buffer.append("slot=").append(slot).append("\r\n");
        }
        String[] stringArray = FNMT_PKCS11_LIBS_WITHOUT_SHA1;
        int n = FNMT_PKCS11_LIBS_WITHOUT_SHA1.length;
        int n2 = 0;
        while (n2 < n) {
            String problematicLib = stringArray[n2];
            if (problematicLib.equalsIgnoreCase(new File(lib).getName())) {
                buffer.append("disabledMechanisms={ CKM_SHA1_RSA_PKCS }\r\n");
                break;
            }
            ++n2;
        }
        LOGGER.info("Creada configuracion PKCS#11:\r\n" + buffer.toString());
        return buffer.toString();
    }

    public static Map<String, String> getAliasesByFriendlyName(String[] aliases, AOKeyStoreManager ksm, boolean checkPrivateKeys, boolean showExpiredCertificates, List<CertificateFilter> certFilters) {
        String tmpCN;
        String[] trimmedAliases = (String[])aliases.clone();
        Hashtable<String, String> aliassesByFriendlyName = new Hashtable<String, String>(trimmedAliases.length);
        String[] stringArray = trimmedAliases;
        int n = trimmedAliases.length;
        int n2 = 0;
        while (n2 < n) {
            String trimmedAlias = stringArray[n2];
            aliassesByFriendlyName.put(trimmedAlias, trimmedAlias);
            ++n2;
        }
        if (ksm != null && ksm.getKeyStores().size() > 0) {
            KeyStore ks = null;
            String[] stringArray2 = aliassesByFriendlyName.keySet().toArray(new String[aliassesByFriendlyName.size()]);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block33: {
                    final String al = stringArray2[n4];
                    X509Certificate tmpCert = null;
                    for (final KeyStore tmpKs : ksm.getKeyStores()) {
                        try {
                            tmpCert = (X509Certificate)tmpKs.getCertificate(al);
                        }
                        catch (RuntimeException e) {
                            if ("es.gob.jmulticard.ui.passwordcallback.CancelledOperationException".equals(e.getClass().getName()) || "es.gob.jmulticard.card.AuthenticationModeLockedException".equals(e.getClass().getName()) || "es.gob.jmulticard.jse.provider.BadPasswordProviderException".equals(e.getClass().getName()) || "es.gob.jmulticard.jse.provider.SignatureAuthException".equals(e.getClass().getName())) {
                                throw e;
                            }
                            LOGGER.warning("No se ha inicializado el KeyStore indicado: " + e);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warning("No se ha inicializado el KeyStore indicado: " + e);
                            continue;
                        }
                        if (tmpCert == null) continue;
                        ks = tmpKs;
                        break;
                    }
                    if (ks != null) {
                        if (tmpCert == null) {
                            LOGGER.warning("El KeyStore no permite extraer el certificado publico para el siguiente alias: " + al);
                        } else {
                            if (!showExpiredCertificates) {
                                try {
                                    tmpCert.checkValidity();
                                }
                                catch (Exception e) {
                                    LOGGER.info("Se ocultara el certificado '" + al + "' por no ser valido: " + e);
                                    aliassesByFriendlyName.remove(al);
                                    break block33;
                                }
                            }
                            if (checkPrivateKeys) {
                                try {
                                    if ("KeychainStore".equals(ks.getType())) {
                                        KeyStore tmpKs;
                                        tmpKs = ks;
                                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                            @Override
                                            public Void run() {
                                                PrivateKey key;
                                                try {
                                                    LOGGER.info("Detectado almacen Llavero de Mac OS X, se trataran directamente las claves privadas");
                                                    key = (PrivateKey)tmpKs.getKey(al, "dummy".toCharArray());
                                                }
                                                catch (Exception e) {
                                                    throw new UnsupportedOperationException("No se ha podido recuperar directamente la clave privada en Mac OS X", e);
                                                }
                                                if (key == null) {
                                                    throw new UnsupportedOperationException("No se ha podido recuperar directamente la clave privada en Mac OS X");
                                                }
                                                return null;
                                            }
                                        });
                                    } else if (!(ks.getEntry(al, new KeyStore.PasswordProtection(new char[0])) instanceof KeyStore.PrivateKeyEntry)) {
                                        aliassesByFriendlyName.remove(al);
                                        LOGGER.info("El certificado '" + al + "' no era tipo trusted pero su clave tampoco era de tipo privada, no se mostrara");
                                    }
                                }
                                catch (UnsupportedOperationException e) {
                                    aliassesByFriendlyName.remove(al);
                                    LOGGER.info("El certificado '" + al + "' no se mostrara por no soportar operaciones de clave privada");
                                }
                                catch (Exception e) {
                                    LOGGER.info("Se ha incluido un certificado (" + al + ") con clave privada inaccesible: " + e);
                                }
                            }
                        }
                    }
                }
                ++n4;
            }
            if (certFilters != null && certFilters.size() > 0) {
                Hashtable<String, String> filteredAliases = new Hashtable<String, String>();
                for (CertificateFilter cf : certFilters) {
                    String[] stringArray3 = cf.matches(aliassesByFriendlyName.keySet().toArray(new String[0]), ksm);
                    int n5 = stringArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String filteredAlias = stringArray3[n6];
                        filteredAliases.put(filteredAlias, (String)aliassesByFriendlyName.get(filteredAlias));
                        ++n6;
                    }
                }
                aliassesByFriendlyName.clear();
                aliassesByFriendlyName.putAll(filteredAliases);
            }
            stringArray2 = aliassesByFriendlyName.keySet().toArray(new String[0]);
            n3 = stringArray2.length;
            int n7 = 0;
            while (n7 < n3) {
                String alias = stringArray2[n7];
                tmpCN = AOUtil.getCN(ksm.getCertificate(alias));
                if (tmpCN != null) {
                    aliassesByFriendlyName.put(alias, tmpCN);
                } else {
                    aliassesByFriendlyName.put(alias, alias.trim());
                }
                ++n7;
            }
        } else {
            String[] stringArray4 = aliassesByFriendlyName.keySet().toArray(new String[aliassesByFriendlyName.size()]);
            int n8 = stringArray4.length;
            n = 0;
            while (n < n8) {
                String al = stringArray4[n];
                String value = (String)aliassesByFriendlyName.get(al);
                if (value.length() > 120) {
                    tmpCN = AOUtil.getCN(value);
                    if (tmpCN != null) {
                        aliassesByFriendlyName.put(al, tmpCN);
                    } else {
                        aliassesByFriendlyName.put(al, String.valueOf(value.substring(0, 117)) + "...");
                    }
                } else {
                    aliassesByFriendlyName.put(al, value.trim());
                }
                ++n;
            }
        }
        return aliassesByFriendlyName;
    }

    public static String showCertSelectionDialog(String[] alias, AOKeyStoreManager ksm, Object parentComponent, boolean checkPrivateKeys, boolean checkValidity, boolean showExpiredCertificates) throws AOCertificatesNotFoundException {
        return KeyStoreUtilities.showCertSelectionDialog(alias, ksm, parentComponent, checkPrivateKeys, checkValidity, showExpiredCertificates, null, false);
    }

    public static String showCertSelectionDialog(String[] alias, AOKeyStoreManager ksm, Object parentComponent, boolean checkPrivateKeys, boolean checkValidity, boolean showExpiredCertificates, List<CertificateFilter> certFilters, boolean mandatoryCertificate) throws AOCertificatesNotFoundException {
        if (alias == null || alias.length == 0) {
            throw new AOCertificatesNotFoundException("El almac\u00e9n no conten\u00eda entradas");
        }
        Map<String, String> aliassesByFriendlyName = KeyStoreUtilities.getAliasesByFriendlyName(alias, ksm, checkPrivateKeys, showExpiredCertificates, certFilters);
        if (aliassesByFriendlyName.size() == 0) {
            throw new AOCertificatesNotFoundException("El almacen no contenia entradas validas");
        }
        if (mandatoryCertificate && aliassesByFriendlyName.size() == 1) {
            return aliassesByFriendlyName.keySet().toArray()[0].toString();
        }
        int i = 0;
        NameCertificateBean[] orderedFriendlyNames = new NameCertificateBean[aliassesByFriendlyName.size()];
        String[] stringArray = aliassesByFriendlyName.keySet().toArray(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String certAlias = stringArray[n2];
            orderedFriendlyNames[i++] = new NameCertificateBean(certAlias, aliassesByFriendlyName.get(certAlias), ksm.getCertificate(certAlias));
            ++n2;
        }
        Arrays.sort(orderedFriendlyNames, new Comparator<NameCertificateBean>(){

            @Override
            public int compare(NameCertificateBean o1, NameCertificateBean o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        String selectedAlias = (String)AOUIFactory.showCertificateSelectionDialog(parentComponent, orderedFriendlyNames);
        if (selectedAlias == null) {
            throw new AOCancelledOperationException("Operacion de seleccion de certificado cancelada");
        }
        if (checkValidity && ksm != null) {
            boolean rejected = false;
            for (KeyStore ks : ksm.getKeyStores()) {
                try {
                    if (!ks.containsAlias(selectedAlias)) {
                    }
                }
                catch (Exception e) {}
                continue;
                String errorMessage = null;
                try {
                    ((X509Certificate)ks.getCertificate(selectedAlias)).checkValidity();
                }
                catch (CertificateExpiredException e) {
                    errorMessage = KeyStoreMessages.getString("KeyStoreUtilities.2");
                }
                catch (CertificateNotYetValidException e) {
                    errorMessage = KeyStoreMessages.getString("KeyStoreUtilities.3");
                }
                catch (KeyStoreException e) {
                    errorMessage = KeyStoreMessages.getString("KeyStoreUtilities.4");
                }
                if (errorMessage != null) {
                    LOGGER.warning("Error durante la validacion: " + errorMessage);
                    if (AOUIFactory.showConfirmDialog(parentComponent, errorMessage, KeyStoreMessages.getString("KeyStoreUtilities.5"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE) == AOUIFactory.YES_OPTION) {
                        return selectedAlias;
                    }
                    rejected = true;
                }
                if (!rejected) continue;
                throw new AOCancelledOperationException("Se ha reusado un certificado probablemente no valido");
            }
        }
        return selectedAlias;
    }

    public static PasswordCallback getPreferredPCB(AOKeyStore kStore, Object parent) {
        if (kStore == null) {
            throw new IllegalArgumentException("No se ha indicado el KeyStore del que desea obtener la PasswordCallBack");
        }
        if (AOKeyStore.APPLE.equals((Object)kStore)) {
            return new CachePasswordCallback("dummy".toCharArray());
        }
        if (AOKeyStore.WINDOWS.equals((Object)kStore)) {
            return new NullPasswordCallback();
        }
        if (AOKeyStore.DNIEJAVA.equals((Object)kStore)) {
            return null;
        }
        return new UIPasswordCallback(KeyStoreMessages.getString("KeyStoreUtilities.6", kStore.getName()), parent);
    }

    public static PasswordCallback getCertificatePC(AOKeyStore store, Object parent) {
        if (AOKeyStore.WINADDRESSBOOK.equals((Object)store) || AOKeyStore.WINCA.equals((Object)store) || AOKeyStore.SINGLE.equals((Object)store) || AOKeyStore.MOZ_UNI.equals((Object)store) || AOKeyStore.PKCS11.equals((Object)store)) {
            return new NullPasswordCallback();
        }
        if (store == AOKeyStore.DNIEJAVA) {
            return null;
        }
        if (AOKeyStore.APPLE.equals((Object)store) || AOKeyStore.WINDOWS.equals((Object)store)) {
            return new CachePasswordCallback("dummy".toCharArray());
        }
        return new UIPasswordCallback(KeyStoreMessages.getString("KeyStoreUtilities.7"), parent);
    }

    static String getPKCS11DNIeLib() throws AOKeyStoreManagerException {
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            String lib = Platform.getSystemLibDir();
            if (new File(String.valueOf(lib) + "\\UsrPkcs11.dll").exists()) {
                return String.valueOf(lib) + "\\UsrPkcs11.dll";
            }
            if (new File(String.valueOf(lib) + "\\opensc-pkcs11.dll").exists()) {
                return String.valueOf(lib) + "\\opensc-pkcs11.dll";
            }
            if (new File(String.valueOf(lib) + "\\DNIe_P11_priv.dll").exists()) {
                return String.valueOf(lib) + "\\DNIe_P11_priv.dll";
            }
            throw new AOKeyStoreManagerException("No hay controlador PKCS#11 de DNIe instalado en este sistema Windows");
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            if (new File("/Library/OpenSC/lib/libopensc-dnie.dylib").exists()) {
                return "/Library/OpenSC/lib/libopensc-dnie.dylib";
            }
            if (new File("/Library/OpenSC/lib/opensc-pkcs11.so").exists()) {
                return "/Library/OpenSC/lib/opensc-pkcs11.so";
            }
            if (new File("/Library/OpenSC/lib/libopensc-dnie.1.0.3.dylib").exists()) {
                return "/Library/OpenSC/lib/libopensc-dnie.1.0.3.dylib";
            }
            if (new File(OPENSC_USR_LIB_LINUX).exists()) {
                return OPENSC_USR_LIB_LINUX;
            }
            throw new AOKeyStoreManagerException("No hay controlador PKCS#11 de DNIe instalado en este sistema Mac OS X");
        }
        if (new File("/usr/local/lib/libopensc-dnie.so").exists()) {
            return "/usr/local/lib/libopensc-dnie.so";
        }
        if (new File("/usr/lib/libopensc-dnie.so").exists()) {
            return "/usr/lib/libopensc-dnie.so";
        }
        if (new File("/lib/libopensc-dnie.so").exists()) {
            return "/lib/libopensc-dnie.so";
        }
        if (new File(OPENSC_USR_LIB_LINUX).exists()) {
            return OPENSC_USR_LIB_LINUX;
        }
        if (new File("/lib/opensc-pkcs11.so").exists()) {
            return "/lib/opensc-pkcs11.so";
        }
        if (new File("/usr/local/lib/opensc-pkcs11.so").exists()) {
            return "/usr/local/lib/opensc-pkcs11.so";
        }
        throw new AOKeyStoreManagerException("No hay controlador PKCS#11 de DNIe instalado en este sistema");
    }

    public static String getShort(String originalPath) {
        if (originalPath == null || !Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return originalPath;
        }
        File dir = new File(originalPath);
        if (!dir.exists()) {
            return originalPath;
        }
        try {
            Process p = new ProcessBuilder("cmd.exe", "/c", "for %f in (\"" + originalPath + "\") do @echo %~sf").start();
            return new String(AOUtil.getDataFromInputStream(p.getInputStream())).trim();
        }
        catch (Exception e) {
            LOGGER.warning("No se ha podido obtener el nombre corto de " + originalPath + ": " + e);
            return originalPath;
        }
    }
}

