/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.main.common;

import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import es.gob.afirma.keystores.main.common.MissingSunMSCAPIException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.callback.PasswordCallback;

public final class CAPIKeyStoreManager
extends AOKeyStoreManager {
    private static KeyStore capiKsMy = null;

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String alias, PasswordCallback pssCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (capiKsMy == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        return (KeyStore.PrivateKeyEntry)capiKsMy.getEntry(alias, new KeyStore.PasswordProtection("dummy".toCharArray()));
    }

    @Override
    public List<KeyStore> init(AOKeyStore type, InputStream store, PasswordCallback pssCallBack, Object[] params) throws AOKeyStoreManagerException, IOException {
        if (AOKeyStore.WINDOWS.equals((Object)type)) {
            return CAPIKeyStoreManager.initCAPI();
        }
        throw new AOKeyStoreManagerException("Tipo de almacen no soportado: " + type.getName());
    }

    private static List<KeyStore> initCAPI() throws AOKeyStoreManagerException, IOException {
        if (RentaKeyManager.INIT_CAPI) {
            capiKsMy = null;
        }
        if (capiKsMy == null) {
            if (!Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
                throw new InvalidOSException("Microsoft Windows");
            }
            if (Security.getProvider("SunMSCAPI") == null) {
                try {
                    Security.addProvider((Provider)Class.forName("sun.security.mscapi.SunMSCAPI").newInstance());
                }
                catch (Exception e) {
                    throw new MissingSunMSCAPIException(e);
                }
            }
            try {
                capiKsMy = KeyStore.getInstance(AOKeyStore.WINDOWS.getProviderName());
            }
            catch (Exception e) {
                throw new AOKeyStoreManagerException("No se ha podido obtener el almacen Windows.MY: " + e, e);
            }
            LOGGER.info("Cargando KeyStore de Windows");
            try {
                capiKsMy.load(null, null);
            }
            catch (CertificateException e) {
                throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen Windows.MY: " + e, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen Windows.MY: " + e, e);
            }
            try {
                CAPIKeyStoreManager.cleanCAPIDuplicateAliases(capiKsMy);
            }
            catch (Exception e) {
                LOGGER.warning("No se han podido tratar los alias duplicados: " + e);
            }
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(capiKsMy);
        return ret;
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (alias == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera null");
            return null;
        }
        if (capiKsMy == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + alias + "' porque el KeyStore no estaba inicializado, se devolvera null");
            return null;
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)capiKsMy.getCertificate(alias);
        }
        catch (Exception e) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + alias + "', se devolvera null: " + e);
            return null;
        }
        if (cert == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + alias + "', se devolvera null");
            return null;
        }
        return cert;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (capiKsMy == null) {
            LOGGER.warning("El KeyStore actual no esta inicializado, por lo que no se pudo recuperar el certificado para el alias '" + alias + "'");
            return null;
        }
        try {
            return (X509Certificate[])capiKsMy.getCertificateChain(alias);
        }
        catch (Exception e) {
            LOGGER.severe("Error al obtener la cadena de certificados para el alias '" + alias + "', se devolvera una cadena vacia: " + e);
            return new X509Certificate[0];
        }
    }

    @Override
    public String[] getAliases() {
        Enumeration<String> aliases;
        if (capiKsMy == null) {
            throw new IllegalStateException("Se han pedido los alias de un almacen no inicializado");
        }
        LOGGER.info("Solicitando los alias al KeyStore (" + capiKsMy.getProvider() + ")");
        try {
            aliases = capiKsMy.aliases();
        }
        catch (Exception e) {
            LOGGER.severe("Error intentando obtener los alias del almacen de claves, se devolvera una enumeracion vacia: " + e);
            return new String[0];
        }
        ArrayList<String> v = new ArrayList<String>();
        LOGGER.info("Componiendo el vector de alias");
        while (aliases.hasMoreElements()) {
            String currAlias = aliases.nextElement().toString();
            v.add(currAlias);
            LOGGER.info("Alias: " + currAlias);
        }
        return v.toArray(new String[0]);
    }

    @Override
    public List<KeyStore> getKeyStores() {
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(capiKsMy);
        return ret;
    }

    @Override
    public String toString() {
        return "Gestor del almacen Windows.MY de CAPI via SunMSCAPI";
    }

    private static void cleanCAPIDuplicateAliases(KeyStore keyStore) throws NoSuchFieldException, IllegalAccessException {
        Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
        field.setAccessible(true);
        KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
        if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
            field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
            field.setAccessible(true);
            Collection entries = (Collection)field.get(keyStoreVeritable);
            for (Object entry : entries) {
                field = entry.getClass().getDeclaredField("certChain");
                field.setAccessible(true);
                X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                String hashCode = Integer.toString(certificates[0].hashCode());
                field = entry.getClass().getDeclaredField("alias");
                field.setAccessible(true);
                String alias = (String)field.get(entry);
                if (alias.equals(hashCode)) continue;
                field.set(entry, alias.concat(" - ").concat(hashCode));
            }
        }
    }
}

