/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.main.common;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.dnie.DnieUnifiedKeyStoreManager;
import es.gob.afirma.keystores.main.callbacks.NullPasswordCallback;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import es.gob.afirma.keystores.main.common.AOKeystoreAlternativeException;
import es.gob.afirma.keystores.main.common.CAPIKeyStoreManager;
import es.gob.afirma.keystores.main.common.KeyStoreMessages;
import es.gob.afirma.keystores.pkcs12.Pkcs12KeyStoreManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.callback.PasswordCallback;

public final class AOKeyStoreManagerFactory {
    private AOKeyStoreManagerFactory() {
    }

    public static AOKeyStoreManager getAOKeyStoreManager(AOKeyStore store, String lib, String description, PasswordCallback pssCallback, Object parentComponent) throws AOKeystoreAlternativeException, IOException {
        if (AOKeyStore.PKCS12.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getPkcs12KeyStoreManager(lib, pssCallback, parentComponent);
        }
        if (AOKeyStore.PKCS12.equals((Object)store) || AOKeyStore.JAVA.equals((Object)store) || AOKeyStore.SINGLE.equals((Object)store) || AOKeyStore.JAVACE.equals((Object)store) || AOKeyStore.JCEKS.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getFileKeyStoreManager(store, lib, pssCallback, parentComponent);
        }
        if (AOKeyStore.PKCS11.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getPkcs11KeyStoreManager(store, lib, description, pssCallback, parentComponent);
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS) && AOKeyStore.WINDOWS.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getWindowsMyCapiKeyStoreManager();
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS) && (AOKeyStore.WINADDRESSBOOK.equals((Object)store) || AOKeyStore.WINCA.equals((Object)store))) {
            return AOKeyStoreManagerFactory.getWindowsAddressBookKeyStoreManager(store);
        }
        if (AOKeyStore.DNIE.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getDniePkcs11KeyStoreManager(store, pssCallback);
        }
        if (AOKeyStore.MOZ_UNI.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getMozillaUnifiedKeyStoreManager(store, pssCallback);
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX) && AOKeyStore.APPLE.equals((Object)store)) {
            return new DnieUnifiedKeyStoreManager(AOKeyStoreManagerFactory.getMacOSXKeyStoreManager(store, lib), parentComponent);
        }
        if (AOKeyStore.DNIEJAVA.equals((Object)store)) {
            return AOKeyStoreManagerFactory.getDnieJavaKeyStoreManager(store, pssCallback, parentComponent);
        }
        throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "La plataforma de navegador '" + store.getName() + "' mas sistema operativo '" + (Object)((Object)Platform.getOS()) + "' no esta soportada");
    }

    private static AOKeyStoreManager getPkcs12KeyStoreManager(String lib, PasswordCallback pssCallback, Object parentComponent) throws IOException, AOKeystoreAlternativeException {
        Pkcs12KeyStoreManager ksm = new Pkcs12KeyStoreManager();
        String storeFilename = null;
        if (lib != null && !"".equals(lib) && new File(lib).exists()) {
            storeFilename = lib;
        }
        if (storeFilename == null) {
            String desc = null;
            String[] exts = new String[]{"pfx", "p12"};
            desc = KeyStoreMessages.getString("AOKeyStoreManagerFactory.0");
            storeFilename = AOUIFactory.getLoadFiles(String.valueOf(KeyStoreMessages.getString("AOKeyStoreManagerFactory.4")) + " " + "PKCS#12", null, null, exts, desc, false, false, parentComponent)[0].getAbsolutePath();
            if (storeFilename == null) {
                throw new AOCancelledOperationException("No se ha seleccionado el almacen de certificados");
            }
        }
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(storeFilename);
                ((AOKeyStoreManager)ksm).init(null, is, pssCallback, null);
            }
            catch (AOException e) {
                throw new AOKeystoreAlternativeException(AOKeyStore.JAVA, "No se ha podido abrir el almacen de tipo PKCS#12 para el fichero " + lib, e);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return ksm;
    }

    private static AOKeyStoreManager getDnieJavaKeyStoreManager(AOKeyStore store, PasswordCallback pssCallback, Object parentComponent) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager ksm = new AOKeyStoreManager();
        try {
            ksm.init(store, null, pssCallback, new Object[]{parentComponent});
        }
        catch (AOKeyStoreManagerException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al inicializar el modulo DNIe 100% Java: " + e, e);
        }
        return ksm;
    }

    private static AOKeyStoreManager getFileKeyStoreManager(AOKeyStore store, String lib, PasswordCallback pssCallback, Object parentComponent) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager ksm = new AOKeyStoreManager();
        String storeFilename = null;
        if (lib != null && !"".equals(lib) && new File(lib).exists()) {
            storeFilename = lib;
        }
        if (storeFilename == null) {
            String desc = null;
            String[] exts = null;
            if (store == AOKeyStore.PKCS12) {
                exts = new String[]{"pfx", "p12"};
                desc = KeyStoreMessages.getString("AOKeyStoreManagerFactory.0");
            }
            if (store == AOKeyStore.JAVA) {
                exts = new String[]{"jks"};
                desc = KeyStoreMessages.getString("AOKeyStoreManagerFactory.1");
            }
            if (store == AOKeyStore.SINGLE) {
                exts = new String[]{"cer", "p7b"};
                desc = KeyStoreMessages.getString("AOKeyStoreManagerFactory.2");
            }
            if (store == AOKeyStore.JCEKS) {
                exts = new String[]{"jceks", "jks"};
                desc = KeyStoreMessages.getString("AOKeyStoreManagerFactory.3");
            }
            if ((storeFilename = AOUIFactory.getLoadFiles(String.valueOf(KeyStoreMessages.getString("AOKeyStoreManagerFactory.4")) + " " + store.getName(), null, null, exts, desc, false, false, parentComponent)[0].getAbsolutePath()) == null) {
                throw new AOCancelledOperationException("No se ha seleccionado el almacen de certificados");
            }
        }
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(storeFilename);
                ksm.init(store, is, pssCallback, null);
            }
            catch (AOException e) {
                throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "No se ha podido abrir el almacen de tipo " + store.getName(), e);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return ksm;
    }

    private static AOKeyStoreManager getPkcs11KeyStoreManager(AOKeyStore store, String lib, String description, PasswordCallback pssCallback, Object parentComponent) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager ksm = new AOKeyStoreManager();
        String p11Lib = null;
        if (lib != null && !"".equals(lib)) {
            p11Lib = lib;
        }
        if (p11Lib != null && !new File(p11Lib).exists()) {
            throw new IOException("La biblioteca '" + p11Lib + "' no existe");
        }
        if (p11Lib == null) {
            String[] exts;
            String extsDesc = KeyStoreMessages.getString("AOKeyStoreManagerFactory.6");
            if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
                exts = new String[]{"dll"};
                extsDesc = String.valueOf(extsDesc) + " (*.dll)";
            } else if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                exts = new String[]{"so", "dylib"};
                extsDesc = String.valueOf(extsDesc) + " (*.dylib, *.so)";
            } else {
                exts = new String[]{"so"};
                extsDesc = String.valueOf(extsDesc) + " (*.so)";
            }
            p11Lib = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.7"), null, null, exts, extsDesc, false, false, parentComponent)[0].getAbsolutePath();
        }
        if (p11Lib == null) {
            throw new AOCancelledOperationException("No se ha seleccionado el controlador PKCS#11");
        }
        try {
            ksm.init(store, null, pssCallback, new String[]{p11Lib, description});
        }
        catch (AOException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al inicializar el modulo PKCS#11", e);
        }
        return ksm;
    }

    private static AOKeyStoreManager getWindowsAddressBookKeyStoreManager(AOKeyStore store) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager ksm = new AOKeyStoreManager();
        try {
            ksm.init(store, null, new NullPasswordCallback(), null);
        }
        catch (AOException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al inicializar el almacen " + store.getName(), e);
        }
        return ksm;
    }

    private static AOKeyStoreManager getDniePkcs11KeyStoreManager(AOKeyStore store, PasswordCallback pssCallback) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager ksm = new AOKeyStoreManager();
        try {
            ksm.init(store, null, !(pssCallback instanceof NullPasswordCallback) ? pssCallback : null, null);
        }
        catch (AOException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al inicializar el PKCS#11 del DNIe", e);
        }
        return ksm;
    }

    private static AOKeyStoreManager getWindowsMyCapiKeyStoreManager() throws AOKeystoreAlternativeException, IOException {
        CAPIKeyStoreManager ksmCapi = new CAPIKeyStoreManager();
        try {
            ((AOKeyStoreManager)ksmCapi).init(AOKeyStore.WINDOWS, null, null, null);
        }
        catch (AOKeyStoreManagerException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.WINDOWS), "Error al obtener almacen WINDOWS: " + e, e);
        }
        return ksmCapi;
    }

    private static AOKeyStoreManager getMozillaUnifiedKeyStoreManager(AOKeyStore store, PasswordCallback pssCallback) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager ksmUni;
        try {
            ksmUni = (AOKeyStoreManager)Class.forName("es.gob.afirma.keystores.mozilla.MozillaUnifiedKeyStoreManager").newInstance();
        }
        catch (Exception e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al obtener dinamicamente el almacen NSS unificado de Mozilla Firefox: " + e, e);
        }
        try {
            ksmUni.init(AOKeyStore.MOZ_UNI, null, pssCallback, null);
        }
        catch (AOException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al inicializar el almacen NSS unificado de Mozilla Firefox: " + e, e);
        }
        return ksmUni;
    }

    private static AOKeyStoreManager getMacOSXKeyStoreManager(AOKeyStore store, String lib) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager ksm = new AOKeyStoreManager();
        try {
            ksm.init(store, lib == null || "".equals(lib) ? null : new FileInputStream(lib), new NullPasswordCallback(), null);
        }
        catch (AOException e) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(store), "Error al inicializar el Llavero de Mac OS X", e);
        }
        return ksm;
    }

    private static AOKeyStore getAlternateKeyStoreType(AOKeyStore currentStore) {
        if (AOKeyStore.PKCS12.equals((Object)currentStore)) {
            return null;
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && !AOKeyStore.WINDOWS.equals((Object)currentStore)) {
            return AOKeyStore.WINDOWS;
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS()) && !AOKeyStore.APPLE.equals((Object)currentStore)) {
            return AOKeyStore.APPLE;
        }
        return AOKeyStore.PKCS12;
    }
}

