/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.main.common;

import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.MissingLibraryException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.main.callbacks.UIPasswordCallback;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import es.gob.afirma.keystores.main.common.KeyStoreMessages;
import es.gob.afirma.keystores.main.common.KeyStoreUtilities;
import es.gob.afirma.keystores.main.common.MissingSunMSCAPIException;
import es.gob.afirma.keystores.main.common.MissingSunPKCS11Exception;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

public class AOKeyStoreManager {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private KeyStore ks;
    private AOKeyStore ksType;

    protected void setKeyStore(KeyStore k) {
        this.ks = k;
    }

    protected KeyStore getKeyStore() {
        return this.ks;
    }

    public AOKeyStore getType() {
        return this.ksType;
    }

    private List<KeyStore> initPKCS11(PasswordCallback pssCallBack, Object[] params) throws AOKeyStoreManagerException, IOException {
        String p11ProviderName;
        Provider p11Provider;
        if (params == null || params.length < 2) {
            throw new IOException("No se puede acceder al KeyStore PKCS#11 si no se especifica la biblioteca");
        }
        if (params[0] == null) {
            throw new IllegalArgumentException("No se puede acceder al KeyStore PKCS#11 si se especifica una biblioteca nula");
        }
        String p11lib = params[0].toString();
        Integer slot = null;
        if (params.length >= 3 && params[2] instanceof Integer) {
            slot = (Integer)params[2];
        }
        if ((p11Provider = Security.getProvider("SunPKCS11-" + (p11ProviderName = new File(p11lib).getName().replace('.', '_').replace(' ', '_')))) == null) {
            Constructor<?> sunPKCS11Contructor;
            try {
                sunPKCS11Contructor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
            }
            catch (Exception e) {
                throw new MissingSunPKCS11Exception(e);
            }
            byte[] config = KeyStoreUtilities.createPKCS11ConfigFile(p11lib, p11ProviderName, slot).getBytes();
            try {
                p11Provider = (Provider)sunPKCS11Contructor.newInstance(new ByteArrayInputStream(config));
            }
            catch (Exception e) {
                try {
                    p11Provider = (Provider)sunPKCS11Contructor.newInstance(new ByteArrayInputStream(config));
                }
                catch (Exception ex) {
                    throw new AOKeyStoreManagerException("No se ha podido instanciar el proveedor SunPKCS11 para la la biblioteca " + p11lib, ex);
                }
            }
            Security.addProvider(p11Provider);
        } else {
            LOGGER.info("El proveedor SunPKCS11 solicitado ya estaba instanciado, se reutilizara esa instancia: " + p11Provider.getName());
        }
        try {
            this.ks = KeyStore.getInstance(this.ksType.getProviderName(), p11Provider);
        }
        catch (Exception e) {
            Security.removeProvider(p11Provider.getName());
            p11Provider = null;
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#11", e);
        }
        try {
            this.ks.load(null, pssCallBack != null ? pssCallBack.getPassword() : null);
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException || e.getCause() instanceof BadPaddingException) {
                throw new IOException("Contrasena invalida: " + e, e);
            }
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#11 solicitado", e);
        }
        catch (CertificateException e) {
            Security.removeProvider(p11Provider.getName());
            p11Provider = null;
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#11 solicitado", e);
        }
        catch (NoSuchAlgorithmException e) {
            Security.removeProvider(p11Provider.getName());
            p11Provider = null;
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#11 solicitado", e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        return ret;
    }

    private List<KeyStore> initSingle(InputStream store, PasswordCallback pssCallBack) throws AOKeyStoreManagerException, IOException {
        Provider pkcs7Provider;
        if (store == null) {
            throw new AOKeyStoreManagerException("Es necesario proporcionar el fichero X.509 o PKCS#7");
        }
        try {
            pkcs7Provider = (Provider)Class.forName("es.gob.afirma.keystores.single.SingleCertKeyStoreProvider").newInstance();
        }
        catch (Exception e) {
            throw new MissingLibraryException("No se ha podido instanciar el proveedor SingleCertKeyStoreProvider: " + e, e);
        }
        Security.addProvider(pkcs7Provider);
        try {
            this.ks = KeyStore.getInstance(this.ksType.getProviderName(), pkcs7Provider);
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#7 / X.509", e);
        }
        try {
            this.ks.load(store, pssCallBack != null ? pssCallBack.getPassword() : null);
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException || e.getCause() instanceof BadPaddingException) {
                throw new IOException("Contrasena invalida: " + e, e);
            }
            throw new AOKeyStoreManagerException("No se ha podido abrir el almacen PKCS#7 / X.509 solicitado", e);
        }
        catch (CertificateException e) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#7 / X.509 solicitado", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#7 / X.509 solicitado", e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        try {
            store.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private List<KeyStore> initJava(InputStream store, PasswordCallback pssCallBack) throws AOKeyStoreManagerException, IOException {
        if (store == null) {
            throw new IOException("Es necesario proporcionar el fichero KeyStore");
        }
        try {
            this.ks = KeyStore.getInstance(this.ksType.getProviderName());
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen JavaKeyStore", e);
        }
        try {
            this.ks.load(store, pssCallBack != null ? pssCallBack.getPassword() : null);
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException || e.getCause() instanceof BadPaddingException) {
                throw new IOException("Contrasena invalida: " + e, e);
            }
        }
        catch (CertificateException e) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen JavaKeyStore solicitado", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen JavaKeyStore solicitado", e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        try {
            store.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private List<KeyStore> initCAPIAddressBook() throws AOKeyStoreManagerException {
        Provider p;
        if (!Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            throw new InvalidOSException("Microsoft Windows");
        }
        if (Security.getProvider("SunMSCAPI") == null) {
            try {
                Security.addProvider((Provider)Class.forName("sun.security.mscapi.SunMSCAPI").newInstance());
            }
            catch (Exception e) {
                throw new MissingSunMSCAPIException(e);
            }
        }
        if ((p = Security.getProvider("MSCAPIAddressBook")) == null) {
            try {
                p = (Provider)Class.forName("es.gob.afirma.keystores.capiaddressbook.MSCAPIAddressBook").newInstance();
            }
            catch (Exception e) {
                throw new MissingLibraryException("No se ha podido instanciar el proveedor MSCAPIAddressBook", e);
            }
            Security.addProvider(p);
        }
        try {
            this.ks = KeyStore.getInstance(this.ksType.getProviderName(), p);
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen MSCAPIAddressBook.ADDRESSBOOK", e);
        }
        try {
            this.ks.load(null, null);
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido abrir el almacen MSCAPIAddressBook.ADDRESSBOOK", e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        return ret;
    }

    private List<KeyStore> initApple(InputStream store) throws AOKeyStoreManagerException, IOException {
        if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            throw new InvalidOSException("Apple Mac OS X");
        }
        try {
            this.ks = KeyStore.getInstance(this.ksType.getProviderName());
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen Apple.KeychainStore", e);
        }
        try {
            this.ks.load(store, null);
        }
        catch (CertificateException e) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen Apple.KeychainStore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen Apple.KeychainStore", e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        return ret;
    }

    private List<KeyStore> initDnieJava(PasswordCallback pssCallBack, Object parentComponent) throws AOKeyStoreManagerException, IOException {
        if (Security.getProvider(AOKeyStore.DNIEJAVA.getProviderName()) == null) {
            try {
                Provider p = (Provider)Class.forName("es.gob.jmulticard.jse.provider.DnieProvider").newInstance();
                Security.addProvider(p);
            }
            catch (Exception e) {
                throw new AOKeyStoreManagerException("No se ha podido instanciar e instalar el proveedor 100% Java para DNIe de Afirma: " + e, e);
            }
        }
        try {
            Class<?> managerClass = Class.forName("es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager");
            Method setDialogOwnerFrameMethod = managerClass.getMethod("setDialogOwner", Component.class);
            setDialogOwnerFrameMethod.invoke(null, parentComponent);
        }
        catch (Exception e) {
            LOGGER.warning("No se ha podido establecer el componente padre para los dialogos del almacen: " + e);
        }
        try {
            this.ks = KeyStore.getInstance(this.ksType.getProviderName());
        }
        catch (Exception e) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen DNIe 100% Java: " + e, e);
        }
        LOGGER.info("Cargando KeyStore DNIe 100% Java");
        try {
            this.ks.load(null, pssCallBack == null ? null : pssCallBack.getPassword());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOKeyStoreManagerException("Error de algoritmo al obtener el almacen DNIe 100% Java: " + e, e);
        }
        catch (CertificateException e) {
            throw new AOKeyStoreManagerException("Error de certificado al obtener el almacen DNIe 100% Java: " + e, e);
        }
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        return ret;
    }

    public List<KeyStore> init(AOKeyStore type, InputStream store, PasswordCallback pssCallBack, Object[] params) throws AOKeyStoreManagerException, IOException {
        if (type == null) {
            throw new IllegalArgumentException("Se ha solicitado inicializar un AOKeyStore nulo");
        }
        LOGGER.info("Inicializamos el almacen de tipo: " + (Object)((Object)type));
        this.ksType = type;
        if (this.ksType.equals((Object)AOKeyStore.SINGLE)) {
            return this.initSingle(store, pssCallBack);
        }
        if (this.ksType.equals((Object)AOKeyStore.DNIEJAVA)) {
            return this.initDnieJava(pssCallBack, params != null && params.length > 0 ? params[0] : null);
        }
        if (this.ksType.equals((Object)AOKeyStore.JAVA) || this.ksType.equals((Object)AOKeyStore.JAVACE) || this.ksType.equals((Object)AOKeyStore.JCEKS)) {
            return this.initJava(store, pssCallBack);
        }
        if (this.ksType.equals((Object)AOKeyStore.WINCA) || this.ksType.equals((Object)AOKeyStore.WINADDRESSBOOK)) {
            return this.initCAPIAddressBook();
        }
        if (this.ksType.equals((Object)AOKeyStore.PKCS11)) {
            return this.initPKCS11(pssCallBack, params);
        }
        if (this.ksType.equals((Object)AOKeyStore.APPLE)) {
            return this.initApple(store);
        }
        if (this.ksType.equals((Object)AOKeyStore.DNIE)) {
            return this.initPKCS11(pssCallBack != null ? pssCallBack : new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStoreManager.0"), null), new String[]{KeyStoreUtilities.getPKCS11DNIeLib(), "DNIe-Afirma"});
        }
        throw new UnsupportedOperationException("Tipo de almacen no soportado");
    }

    public KeyStore.PrivateKeyEntry getKeyEntry(String alias, PasswordCallback pssCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (this.ks == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        return (KeyStore.PrivateKeyEntry)this.ks.getEntry(alias, pssCallback != null ? new KeyStore.PasswordProtection(pssCallback.getPassword()) : null);
    }

    public static X509Certificate getCertificate(KeyStore.PrivateKeyEntry privateKeyEntry) {
        return (X509Certificate)privateKeyEntry.getCertificate();
    }

    public X509Certificate getCertificate(String alias) {
        if (alias == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera null");
            return null;
        }
        if (this.ks == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + alias + "' porque el KeyStore no estaba inicializado, se devolvera null");
            return null;
        }
        Certificate cert = null;
        try {
            cert = this.ks.getCertificate(alias);
        }
        catch (Exception e) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + alias + "', se devolvera null: " + e);
            return null;
        }
        if (cert == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + alias + "', se devolvera null");
            return null;
        }
        return (X509Certificate)cert;
    }

    public static X509Certificate[] getCertificateChain(KeyStore.PrivateKeyEntry privateKeyEntry) {
        return (X509Certificate[])privateKeyEntry.getCertificateChain();
    }

    public X509Certificate[] getCertificateChain(String alias) {
        if (this.ks == null) {
            LOGGER.warning("El KeyStore actual no esta inicializado, por lo que no se pudo recuperar el certificado para el alias '" + alias + "'");
            return null;
        }
        try {
            return (X509Certificate[])this.ks.getCertificateChain(alias);
        }
        catch (Exception e) {
            LOGGER.severe("Error al obtener la cadena de certificados para el alias '" + alias + "', se devolvera una cadena vacia: " + e);
            return new X509Certificate[0];
        }
    }

    public String[] getAliases() {
        Enumeration<String> aliases;
        if (this.ks == null) {
            throw new IllegalStateException("Se han pedido los alias de un almacen no inicializado");
        }
        LOGGER.info("Solicitando los alias al KeyStore (" + this.ks.getProvider() + ")");
        try {
            aliases = this.ks.aliases();
        }
        catch (Exception e) {
            LOGGER.severe("Error intentando obtener los alias del almacen de claves, se devolvera una enumeracion vacia: " + e);
            return new String[0];
        }
        ArrayList<String> v = new ArrayList<String>();
        LOGGER.info("Componiendo el vector de alias");
        while (aliases.hasMoreElements()) {
            String currAlias = aliases.nextElement().toString();
            v.add(currAlias);
        }
        return v.toArray(new String[0]);
    }

    public List<KeyStore> getKeyStores() {
        ArrayList<KeyStore> ret = new ArrayList<KeyStore>(1);
        ret.add(this.ks);
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("Gestor de almacenes de claves");
        if (this.ksType != null) {
            String tmpStr = this.ksType.getName();
            if (tmpStr != null) {
                ret.append(" de tipo ");
                ret.append(tmpStr);
            }
            if ((tmpStr = this.ksType.getName()) != null) {
                ret.append(" con nombre ");
                ret.append(tmpStr);
            }
            ret.append(" de clase ");
            ret.append(this.ksType.toString());
        }
        return ret.toString();
    }
}

