/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.main.common;

public enum AOKeyStore {
    WINDOWS("Windows / Internet Explorer", 0, "Windows-MY"),
    APPLE("Mac OS X / Safari", 1, "KeychainStore"),
    PKCS12("PKCS#12 / PFX", 3, "PKCS12"),
    JAVA("Java KeyStore / JKS", 4, "JKS"),
    PKCS11("PKCS#11", 5, "PKCS11"),
    SINGLE("PKCS#7 / X.509", 6, "PKCS7"),
    MOZ_UNI("Mozilla / Firefox (unificado)", 7, "PKCS11"),
    JCEKS("Java Cryptography Extension KeyStore (JCEKS)", 8, "JCEKS"),
    JAVACE("Java KeyStore / JKS (Case Exact)", 9, "CaseExactJKS"),
    WINADDRESSBOOK("Windows / Internet Explorer (otras personas / libreta de direcciones)", 11, "Windows-ADDRESSBOOK"),
    WINCA("Windows / Internet Explorer (CA intermedias)", 12, "Windows-CA"),
    DNIE("DNI Electronico", 13, "PKCS11"),
    DNIEJAVA("DNIe 100% Java", 14, "DNI");

    private String name;
    private final int ordinal;
    private final String providerName;

    private AOKeyStore(String n2, int o, String pn) {
        this.name = n2;
        this.ordinal = o;
        this.providerName = pn;
    }

    public String toString() {
        return this.getName();
    }

    public String getProviderName() {
        return this.providerName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public static AOKeyStore getKeyStore(String name) {
        AOKeyStore[] aOKeyStoreArray = AOKeyStore.values();
        int n = aOKeyStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            AOKeyStore tempKs = aOKeyStoreArray[n2];
            if (tempKs.getName().equals(name)) {
                return tempKs;
            }
            ++n2;
        }
        return null;
    }
}

