/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import es.gob.afirma.keystores.main.filters.CertificateFilter;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

public class SerialNumberFilter
extends CertificateFilter {
    private final BigInteger serialNumber;

    public SerialNumberFilter(BigInteger serial) {
        if (serial == null) {
            throw new IllegalArgumentException("El numero de serie clave del filtro no puede ser nulo");
        }
        this.serialNumber = serial;
    }

    @Override
    public boolean matches(X509Certificate cert) {
        if (cert == null) {
            return false;
        }
        return this.serialNumber.equals(cert.getSerialNumber());
    }
}

