/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import com.sun.jndi.toolkit.dir.SearchFilter;
import es.gob.afirma.keystores.main.filters.CertificateFilter;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class RFC2254CertificateFilter
extends CertificateFilter {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final String rfc2254IssuerFilter;
    private final String rfc2254SubjectFilter;

    @Override
    public boolean matches(X509Certificate cert) {
        return RFC2254CertificateFilter.filterSubjectByRFC2254(this.rfc2254SubjectFilter, cert) && RFC2254CertificateFilter.filterIssuerByRFC2254(this.rfc2254IssuerFilter, cert);
    }

    public RFC2254CertificateFilter(String subjectFilter, String issuerFilter) {
        if (subjectFilter == null && issuerFilter == null) {
            throw new IllegalArgumentException("Al menos uno de los criterios de filtrado debe no ser nulo");
        }
        this.rfc2254IssuerFilter = issuerFilter;
        this.rfc2254SubjectFilter = subjectFilter;
    }

    private static boolean filterSubjectByRFC2254(String filter, X509Certificate cert) {
        if (cert == null || filter == null) {
            return true;
        }
        return RFC2254CertificateFilter.filterRFC2254(filter, cert.getSubjectDN().toString());
    }

    private static boolean filterIssuerByRFC2254(String filter, X509Certificate cert) {
        if (cert == null || filter == null) {
            return true;
        }
        return RFC2254CertificateFilter.filterRFC2254(filter, cert.getIssuerDN().toString());
    }

    private static boolean filterRFC2254(String f, String name) {
        try {
            return RFC2254CertificateFilter.filterRFC2254(f, new LdapName(name));
        }
        catch (Exception e) {
            LOGGER.warning("No ha sido posible filtrar el certificado (filtro: '" + f + "', nombre: '" + name + "'), no se eliminara del listado: " + e);
            return true;
        }
    }

    private static boolean filterRFC2254(String f, LdapName name) {
        List<Rdn> rdns;
        block5: {
            if (f == null || name == null) {
                return true;
            }
            rdns = name.getRdns();
            if (rdns != null && !rdns.isEmpty()) break block5;
            LOGGER.warning("El nombre proporcionado para filtrar no contiene atributos, no se mostrara el certificado en el listado");
            return false;
        }
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            for (Rdn rdn : rdns) {
                attrs.put(rdn.getType(), rdn.getValue());
            }
            return new SearchFilter(f).check(attrs);
        }
        catch (Exception e) {
            LOGGER.warning("No ha sido posible filtrar el certificado (filtro: '" + f + "', nombre: '" + name + "'), no se eliminara del listado: " + e);
            return true;
        }
    }
}

