/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import es.gob.afirma.keystores.main.filters.CertificateFilter;
import java.security.cert.X509Certificate;

public class KeyUsageFilter
extends CertificateFilter {
    private static final int KEYUSAGE_NBITS = 9;
    private final Boolean[] keyUsageFilter;
    public static final Boolean[] SIGN_CERT_USAGE;

    static {
        Boolean[] booleanArray = new Boolean[9];
        booleanArray[1] = Boolean.TRUE;
        SIGN_CERT_USAGE = booleanArray;
    }

    @Override
    public boolean matches(X509Certificate cert) {
        boolean[] certUsage;
        if (cert == null) {
            return false;
        }
        if (this.keyUsageFilter.length == 9 && (certUsage = cert.getKeyUsage()) != null) {
            int j = 0;
            while (j < certUsage.length) {
                if (this.keyUsageFilter[j] != null && this.keyUsageFilter[j] != certUsage[j]) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public KeyUsageFilter(Boolean[] keyUsage) {
        if (keyUsage == null) {
            throw new IllegalArgumentException("El criterio de filtrado no puede ser nulo");
        }
        this.keyUsageFilter = (Boolean[])keyUsage.clone();
    }
}

