/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.dnie;

import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerException;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.x500.X500Principal;

public class DnieUnifiedKeyStoreManager
extends AOKeyStoreManager {
    private static X509Certificate dnieRootCertificate;
    private static final int DNIE_CERTCHAIN_LENGTH = 2;
    private static final List<String> DNIE_ALIASES;
    private final String[] aliases;
    private static final X500Principal DNIE_ISSUER;
    private final AOKeyStoreManager originalKsm;
    private AOKeyStoreManager dnieKsm = null;

    static {
        try {
            dnieRootCertificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(ClassLoader.getSystemResourceAsStream("ACRAIZ-SHA2.crt"));
        }
        catch (CertificateException e) {
            Logger.getLogger("es.gob.afirma").warning("No se ha podido cargal el certificado raiz del DNIe, la cadena de confianza puede estar incompleta: " + e);
            dnieRootCertificate = null;
        }
        DNIE_ALIASES = new ArrayList<String>(2);
        DNIE_ALIASES.add("CertAutenticacion");
        DNIE_ALIASES.add("CertFirmaDigital");
        DNIE_ISSUER = new X500Principal("CN=AC DNIE 001, OU=DNIE, O=DIRECCION GENERAL DE LA POLICIA, C=ES");
    }

    public DnieUnifiedKeyStoreManager(AOKeyStoreManager originalKsm, Object parent) {
        if (originalKsm == null) {
            throw new IllegalArgumentException("Es necesario un almacen al que anadir los certificados de DNIe, no puede ser nulo");
        }
        this.originalKsm = originalKsm;
        boolean dnieNeeded = true;
        String[] stringArray = originalKsm.getAliases();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            if (originalKsm.getCertificate(alias).getIssuerX500Principal().equals(DNIE_ISSUER)) {
                dnieNeeded = false;
                break;
            }
            ++n2;
        }
        if (dnieNeeded) {
            try {
                this.dnieKsm = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.DNIEJAVA, null, (Object)((Object)originalKsm.getType()) + "_PLUS_DNIE", null, parent);
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").info("No se puede usar DNIe con controlador 100% Java: " + e);
            }
        }
        String[] originalAliases = originalKsm.getAliases();
        this.aliases = new String[originalAliases.length + (this.dnieKsm != null ? 2 : 0)];
        System.arraycopy(originalAliases, 0, this.aliases, 0, originalAliases.length);
        if (this.dnieKsm != null) {
            this.aliases[this.aliases.length - 1] = DNIE_ALIASES.get(0);
            this.aliases[this.aliases.length - 2] = DNIE_ALIASES.get(1);
        }
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (!DNIE_ALIASES.contains(alias) || this.dnieKsm == null) {
            return this.originalKsm.getCertificate(alias);
        }
        return this.dnieKsm.getCertificate(alias);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (!DNIE_ALIASES.contains(alias) || this.dnieKsm == null) {
            return this.originalKsm.getCertificateChain(alias);
        }
        X509Certificate[] chain = new X509Certificate[2];
        X509Certificate[] originalDnieChain = this.dnieKsm.getCertificateChain(alias);
        chain[0] = originalDnieChain[0];
        chain[1] = originalDnieChain[1];
        chain[2] = dnieRootCertificate;
        return chain;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String alias, PasswordCallback pssCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!DNIE_ALIASES.contains(alias) || this.dnieKsm == null) {
            return this.originalKsm.getKeyEntry(alias, pssCallback);
        }
        return new KeyStore.PrivateKeyEntry(this.dnieKsm.getKeyEntry(alias, null).getPrivateKey(), this.getCertificateChain(alias));
    }

    @Override
    public List<KeyStore> getKeyStores() {
        if (this.dnieKsm == null) {
            return this.originalKsm.getKeyStores();
        }
        ArrayList<KeyStore> ksms = new ArrayList<KeyStore>(this.originalKsm.getKeyStores().size() + 1);
        ksms.addAll(this.originalKsm.getKeyStores());
        ksms.addAll(this.dnieKsm.getKeyStores());
        return ksms;
    }

    @Override
    public AOKeyStore getType() {
        return this.originalKsm.getType();
    }

    @Override
    public List<KeyStore> init(AOKeyStore type, InputStream store, PasswordCallback pssCallBack, Object[] params) throws AOKeyStoreManagerException, IOException {
        throw new UnsupportedOperationException();
    }
}

