/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.util.tree;

final class AOTreePath {
    private AOTreePath parentPath;
    private transient Object lastPathComponent;

    AOTreePath(Object[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("La ruta en el TreePath no puede ser ni nula ni vacia");
        }
        this.lastPathComponent = ((Object[])path.clone())[path.length - 1];
        if (path.length > 1) {
            this.parentPath = new AOTreePath((Object[])path.clone(), path.length - 1);
        }
    }

    private AOTreePath(Object[] path, int length) {
        this.lastPathComponent = ((Object[])path.clone())[length - 1];
        if (length > 1) {
            this.parentPath = new AOTreePath((Object[])path.clone(), length - 1);
        }
    }

    private int getPathCount() {
        int result = 0;
        AOTreePath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    private Object getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("El indice " + element + " esta fuera del rango especificado");
        }
        AOTreePath path = this;
        int i = pathLength - 1;
        while (i != element) {
            path = path.parentPath;
            --i;
        }
        return path.lastPathComponent;
    }

    public String toString() {
        StringBuffer tempSpot = new StringBuffer("[");
        int counter = 0;
        int maxCounter = this.getPathCount();
        while (counter < maxCounter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
            ++counter;
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }
}

