/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.util.tree;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public final class AOTreeNode {
    private static final Enumeration<AOTreeNode> EMPTY_ENUMERATION = new Enumeration<AOTreeNode>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public AOTreeNode nextElement() {
            throw new NoSuchElementException("No hay mas elementos");
        }
    };
    private AOTreeNode parent = null;
    private Vector<AOTreeNode> children;
    private transient Object userObject;
    private final boolean allowsChildren;

    public AOTreeNode(Object userObject) {
        this(userObject, true);
    }

    private AOTreeNode(Object userObject, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
    }

    private void insert(AOTreeNode newChild, int childIndex) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("El nodo no permite hijos");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("EL nuevo hijo es nulo");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("El nuevo hijo es ya un ancestro");
        }
        AOTreeNode oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    private void remove(int childIndex) {
        AOTreeNode child = this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void setParent(AOTreeNode newParent) {
        this.parent = newParent;
    }

    public AOTreeNode getParent() {
        return this.parent;
    }

    public AOTreeNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("El nodo no tiene hijos");
        }
        return this.children.elementAt(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    private int getIndex(AOTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("Argumento nulo");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    Enumeration<AOTreeNode> children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        AOTreeNode part = this.getParent();
        if (part != null) {
            part.remove(this);
        }
    }

    private void remove(AOTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("Argumento nulo");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("El argumento no es un hijo");
        }
        this.remove(this.getIndex(aChild));
    }

    public void add(AOTreeNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    private boolean isNodeAncestor(AOTreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        AOTreeNode ancestor = this;
        do {
            if (!ancestor.equals(anotherNode)) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public Enumeration<AOTreeNode> preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    private boolean isNodeChild(AOTreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        if (this.userObject == null) {
            return "null";
        }
        return this.userObject.toString();
    }

    private static final class PreorderEnumeration
    implements Enumeration<AOTreeNode> {
        private final Stack<Enumeration<AOTreeNode>> stack;

        PreorderEnumeration(AOTreeNode rootNode) {
            Vector<AOTreeNode> v = new Vector<AOTreeNode>(1);
            v.addElement(rootNode);
            this.stack = new Stack();
            this.stack.push(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && this.stack.peek().hasMoreElements();
        }

        @Override
        public AOTreeNode nextElement() {
            Enumeration<AOTreeNode> enumer = this.stack.peek();
            AOTreeNode node = enumer.nextElement();
            Enumeration<AOTreeNode> child = node.children();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (child.hasMoreElements()) {
                this.stack.push(child);
            }
            return node;
        }
    }
}

