/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.ui;

import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIManager;
import es.gob.afirma.core.ui.NameCertificateBean;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public final class AOUIFactory {
    public static final int PLAIN_MESSAGE;
    public static final int YES_NO_OPTION;
    public static final int WARNING_MESSAGE;
    public static final int YES_OPTION;
    public static final int NO_OPTION;
    public static final int OK_CANCEL_OPTION;
    public static final int OK_OPTION;
    public static final int INFORMATION_MESSAGE;
    public static final int QUESTION_MESSAGE;
    private static AOUIManager uiManager;

    static {
        try {
            if (Platform.OS.ANDROID.equals((Object)Platform.getOS())) {
                throw new UnsupportedOperationException("No se soporta GUI en Android");
            }
            String uiManagerClassName = Platform.OS.MACOSX.equals((Object)Platform.getOS()) ? "es.gob.afirma.ui.core.jse.AWTUIManager" : "es.gob.afirma.ui.core.jse.JSEUIManager";
            try {
                uiManager = (AOUIManager)Class.forName(uiManagerClassName).newInstance();
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").severe("No se ha podido instanciar la implementacion de gestor de interfaces graficas: " + e);
            }
            PLAIN_MESSAGE = uiManager.getPlainMessageCode();
            YES_NO_OPTION = uiManager.getYesNoOptionCode();
            WARNING_MESSAGE = uiManager.getWarningMessageCode();
            YES_OPTION = uiManager.getYesOptionCode();
            NO_OPTION = uiManager.getNoOptionCode();
            OK_CANCEL_OPTION = uiManager.getOkCancelOptionCode();
            OK_OPTION = uiManager.getOkOptionCode();
            INFORMATION_MESSAGE = uiManager.getInformationMessageCode();
            QUESTION_MESSAGE = uiManager.getQuestionMessageCode();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("No se ha podido instanciar el gestor de interfaces graficas: " + e, e);
        }
    }

    private AOUIFactory() {
    }

    public static void setUIManager(AOUIManager manager) {
        if (manager != null) {
            uiManager = manager;
        }
    }

    public static char[] getPassword(String text, Object c) {
        return uiManager.getPassword(text, c);
    }

    public static char[] getPassword(String text, String charset, boolean beep, Object c) {
        return uiManager.getPassword(text, charset, beep, c);
    }

    public static int showConfirmDialog(Object parentComponent, Object message, String title, int optionType, int messageType) {
        return uiManager.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static Object showInputDialog(Object parentComponent, Object message, String title, int messageType, Object icon, Object[] selectionValues, Object initialSelectionValue) {
        return uiManager.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue);
    }

    public static Object showCertificateSelectionDialog(Object parentComponent, NameCertificateBean[] selectionValues) {
        return uiManager.showCertificateSelectionDialog(parentComponent, selectionValues);
    }

    public static File[] getLoadFiles(String dialogTitle, String currentDir, String filename, String[] extensions, String description, boolean selectDirectory, boolean multiSelect, Object parentComponent) {
        return uiManager.getLoadFiles(dialogTitle, currentDir, filename, extensions, description, selectDirectory, multiSelect, parentComponent);
    }

    public static File getSaveDataToFile(byte[] data, String dialogTitle, String currentDir, String selectedFile, String[] exts, String description, Object parent) throws IOException {
        return uiManager.saveDataToFile(data, dialogTitle, currentDir, selectedFile, exts, description, parent);
    }
}

