/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Properties;

public final class AdESPolicy {
    private String policyIdentifier = null;
    private String policyIdentifierHash = null;
    private String policyIdentifierHashAlgorithm = null;
    private URL policyQualifier = null;

    private void setValues(String identifier, String identifierHash, String identifierHashAlgorithm, String qualifier) {
        if (identifier == null || "".equals(identifier)) {
            throw new IllegalArgumentException("El identificador de politica no puede ser nulo ni vacio");
        }
        this.policyIdentifier = identifier;
        if (identifierHash != null && !"0".equals(identifierHash) && (identifierHashAlgorithm == null || "".equals(identifierHashAlgorithm))) {
            throw new IllegalArgumentException("Si se indica la huella digital del identificador de politica es obligatorio indicar tambien el algoritmo");
        }
        if (identifierHash == null) {
            try {
                this.policyIdentifierHash = Base64.encode(MessageDigest.getInstance("SHA-512").digest(AOUtil.getDataFromInputStream(new URL(identifier).openStream())));
                this.policyIdentifierHashAlgorithm = "SHA-512";
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Si no se especifica la huella digital de la politica es necesario que el identificador sea una URL accesible universalmente: " + e, e);
            }
        }
        if ("0".equals(identifierHash)) {
            this.policyIdentifierHash = null;
        } else {
            if (!AOUtil.isBase64(identifierHash.getBytes())) {
                throw new IllegalArgumentException("La huella digital de la politica debe estar en formato Base64");
            }
            try {
                this.policyIdentifierHashAlgorithm = AOSignConstants.getDigestAlgorithmName(identifierHashAlgorithm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("El algoritmo de huella digital no esta soportado: " + identifierHashAlgorithm, e);
            }
            this.policyIdentifierHash = identifierHash;
        }
        if (qualifier != null && !"".equals(qualifier)) {
            try {
                this.policyQualifier = new URL(qualifier);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("El calificador de la politica debe ser una URL valida", e);
            }
        }
    }

    public AdESPolicy(Properties extraParams) {
        if (extraParams == null) {
            throw new IllegalArgumentException("Es necesario proporciona las propiedades de la politica");
        }
        String policyID = extraParams.getProperty("policyIdentifier");
        if (policyID != null) {
            this.setValues(policyID, extraParams.getProperty("policyIdentifierHash"), extraParams.getProperty("policyIdentifierHashAlgorithm"), extraParams.getProperty("policyQualifier"));
        }
    }

    public AdESPolicy(String identifier, String identifierHash, String identifierHashAlgorithm, String qualifier) {
        this.setValues(identifier, identifierHash, identifierHashAlgorithm, qualifier);
    }

    public String getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public String getPolicyIdentifierHash() {
        return this.policyIdentifierHash;
    }

    public String getPolicyIdentifierHashAlgorithm() {
        return this.policyIdentifierHashAlgorithm;
    }

    public URL getPolicyQualifier() {
        return this.policyQualifier;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AdESPolicy)) {
            return false;
        }
        AdESPolicy other = (AdESPolicy)o;
        return other.getPolicyIdentifier().equals(this.getPolicyIdentifier()) && other.getPolicyIdentifierHash().equals(this.getPolicyIdentifierHash()) && other.getPolicyIdentifierHashAlgorithm().equals(this.getPolicyIdentifierHashAlgorithm());
    }

    public int hashCode() {
        return this.getPolicyIdentifier().hashCode();
    }
}

