/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.AOUtil;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;

public final class AOSimpleSignInfo {
    private X509Certificate[] certs = null;
    private String signAlgorithm = null;
    private String signFormat = null;
    private Date signingTime = null;
    private Date[] timestampingTime = null;
    private byte[] pkcs1 = null;

    public AOSimpleSignInfo(X509Certificate[] chainCert, Date signingTime) {
        if (chainCert == null || chainCert.length == 0 || chainCert[0] == null) {
            throw new IllegalArgumentException("No se ha introducido la cadena de certificacion");
        }
        this.certs = (X509Certificate[])chainCert.clone();
        this.signingTime = signingTime;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setSignAlgorithm(String algorithm) {
        this.signAlgorithm = algorithm;
    }

    public String getSignFormat() {
        return this.signFormat;
    }

    public void setSignFormat(String format) {
        this.signFormat = format;
    }

    public Date[] getTimestampingTime() {
        return this.timestampingTime == null ? null : (Date[])this.timestampingTime.clone();
    }

    public void setTimestampingTime(Date[] timestampingTime) {
        this.timestampingTime = timestampingTime == null ? null : (Date[])timestampingTime.clone();
    }

    public X509Certificate[] getCerts() {
        return this.certs == null ? null : (X509Certificate[])this.certs.clone();
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public boolean isTimeStamped() {
        return this.timestampingTime != null && this.timestampingTime.length > 0 && this.timestampingTime[0] != null;
    }

    public byte[] getPkcs1() {
        return this.pkcs1 == null ? null : (byte[])this.pkcs1.clone();
    }

    public void setPkcs1(byte[] pkcs1) {
        this.pkcs1 = pkcs1 == null ? null : (byte[])pkcs1.clone();
    }

    public String toString() {
        String desc = AOUtil.getCN(this.certs[0]);
        if (this.timestampingTime != null && this.timestampingTime.length > 0 && this.timestampingTime[0] != null) {
            desc = String.valueOf(desc) + " (TimeStamp: " + DateFormat.getDateTimeInstance(2, 3).format(this.signingTime) + ")";
        } else if (this.signingTime != null) {
            desc = String.valueOf(desc) + " (" + DateFormat.getDateTimeInstance(2, 3).format(this.signingTime) + ")";
        }
        return desc;
    }
}

