/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSimpleSigner;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Properties;

public final class AOPkcs1Signer
implements AOSimpleSigner {
    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKey key, Certificate[] certChain, Properties extraParams) throws AOException {
        Signature sig;
        try {
            sig = "com.aet.android.providerPKCS15.SEPrivateKey".equals(key.getClass().getName()) ? Signature.getInstance(algorithm, "AETProvider") : Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AOException("No se soporta el algoritmo de firma (" + algorithm + "): " + e, e);
        }
        catch (NoSuchProviderException e) {
            throw new AOException("No hay un proveedor para el algoritmo '" + algorithm + "' con el tipo de clave '" + key.getAlgorithm() + "': " + e, e);
        }
        try {
            sig.initSign(key);
        }
        catch (Exception e) {
            throw new AOException("Error al inicializar la firma con la clave privada: " + e, e);
        }
        try {
            sig.update(data);
        }
        catch (SignatureException e) {
            throw new AOException("Error al configurar los datos a firmar: " + e, e);
        }
        try {
            return sig.sign();
        }
        catch (SignatureException e) {
            throw new AOException("Error durante el proceso de firma: " + e, e);
        }
    }
}

