/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.AOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class UrlHttpManagerImpl {
    private static final String HTTPS = "https";
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    private static final SSLSocketFactory DEFAULT_SSL_SOCKET_FACTORY = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static final TrustManager[] DUMMY_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    private UrlHttpManagerImpl() {
    }

    public static byte[] readUrlByPost(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("La URL a leer no puede ser nula");
        }
        if (!url.contains("?")) {
            return UrlHttpManagerImpl.readUrlByGet(url);
        }
        StringTokenizer st = new StringTokenizer(url, "?");
        String request = st.nextToken();
        String urlParameters = st.nextToken();
        URL uri = new URL(request);
        if (uri.getProtocol().equals(HTTPS)) {
            try {
                UrlHttpManagerImpl.disableSslChecks();
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + e);
            }
        }
        HttpURLConnection conn = (HttpURLConnection)uri.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write(urlParameters);
        writer.flush();
        InputStream is = conn.getInputStream();
        byte[] data = AOUtil.getDataFromInputStream(is);
        is.close();
        if (uri.getProtocol().equals(HTTPS)) {
            UrlHttpManagerImpl.enableSslChecks();
        }
        return data;
    }

    public static byte[] readUrlByGet(String url) throws IOException {
        URL uri = new URL(url);
        if (uri.getProtocol().equals(HTTPS)) {
            try {
                UrlHttpManagerImpl.disableSslChecks();
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + e);
            }
        }
        InputStream is = uri.openStream();
        byte[] data = AOUtil.getDataFromInputStream(is);
        is.close();
        if (uri.getProtocol().equals(HTTPS)) {
            UrlHttpManagerImpl.enableSslChecks();
        }
        return data;
    }

    private static void enableSslChecks() {
        HttpsURLConnection.setDefaultSSLSocketFactory(DEFAULT_SSL_SOCKET_FACTORY);
        HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
    }

    private static void disableSslChecks() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, DUMMY_TRUST_MANAGER, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
}

