/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;

public final class SHA2AltNamesProvider
extends Provider {
    private static final String PROVIDER_NAME = "AOSHA2AltNamesProvider";
    private static String sha256Class = "sun.security.provider.SHA2";
    private static String sha384Class = "sun.security.provider.SHA5$SHA384";
    private static String sha512Class = "sun.security.provider.SHA5$SHA512";
    private static final long serialVersionUID = 2361025283448164750L;

    public static void install() {
        if (Security.getProvider(PROVIDER_NAME) != null) {
            return;
        }
        try {
            MessageDigest.getInstance("SHA256");
            sha256Class = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MessageDigest.getInstance("SHA384");
            sha384Class = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MessageDigest.getInstance("SHA512");
            sha512Class = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName(sha256Class);
        }
        catch (Exception e) {
            sha256Class = null;
        }
        try {
            Class.forName(sha384Class);
        }
        catch (Exception e) {
            sha384Class = null;
        }
        try {
            Class.forName(sha512Class);
        }
        catch (Exception e) {
            sha512Class = null;
        }
        if (sha256Class != null || sha384Class != null || sha512Class != null) {
            Security.addProvider(new SHA2AltNamesProvider());
        }
    }

    public SHA2AltNamesProvider() {
        super(PROVIDER_NAME, 1.0, "Proveedor para huellas digitales SHA-2 con nombres alternativos");
        if (sha256Class != null) {
            this.put("MessageDigest.SHA256", sha256Class);
        }
        if (sha384Class != null) {
            this.put("MessageDigest.SHA384", sha384Class);
        }
        if (sha512Class != null) {
            this.put("MessageDigest.SHA512", sha512Class);
        }
    }
}

