/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.logging.Logger;

public final class Platform {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static OS os = null;
    private static String javaArch = null;
    private static String javaHome = null;
    private static String javaLibraryPath = null;
    private static String userHome = null;

    private Platform() {
    }

    private static OS recoverOsName() {
        String osName = System.getProperty("os.name");
        if (osName.contains("indows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("inux")) {
            if ("Dalvik".equals(System.getProperty("java.vm.name"))) {
                return OS.ANDROID;
            }
            return OS.LINUX;
        }
        if (osName.contains("SunOS") || osName.contains("olaris")) {
            return OS.SOLARIS;
        }
        if (osName.startsWith("Mac OS X")) {
            return OS.MACOSX;
        }
        LOGGER.warning("No se ha podido determinar el sistema operativo");
        return OS.OTHER;
    }

    public static BROWSER getBrowser(String userAgent) {
        if (userAgent == null) {
            return BROWSER.OTHER;
        }
        if (userAgent.toLowerCase(Locale.US).contains("msie")) {
            return BROWSER.INTERNET_EXPLORER;
        }
        if (userAgent.toLowerCase(Locale.US).contains("firefox")) {
            return BROWSER.FIREFOX;
        }
        if (userAgent.toLowerCase(Locale.US).contains("chrome")) {
            return BROWSER.CHROME;
        }
        if (userAgent.toLowerCase(Locale.US).contains("safari")) {
            return BROWSER.SAFARI;
        }
        if (userAgent.toLowerCase(Locale.US).contains("opera")) {
            return BROWSER.OPERA;
        }
        return BROWSER.OTHER;
    }

    public static OS getOS() {
        if (os == null) {
            os = Platform.recoverOsName();
        }
        return os;
    }

    public static String getJavaArch() {
        if (javaArch == null && (javaArch = System.getProperty("sun.arch.data.model")) == null) {
            javaArch = System.getProperty("com.ibm.vm.bitmode");
        }
        return javaArch;
    }

    public static String getJavaHome() {
        if (javaHome == null) {
            javaHome = Platform.recoverJavaHome();
        }
        return javaHome;
    }

    public static String getJavaLibraryPath() {
        if (javaLibraryPath == null) {
            javaLibraryPath = System.getProperty("java.library.path");
        }
        return javaLibraryPath;
    }

    public static String getUserHome() {
        if (userHome == null) {
            userHome = System.getProperty("user.home");
        }
        return userHome;
    }

    private static String recoverJavaHome() {
        String ret = null;
        try {
            ret = System.getProperty("jnlpx.home");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret != null) {
            return ret.substring(0, ret.lastIndexOf(File.separator));
        }
        try {
            return System.getProperty("java.home");
        }
        catch (Exception e) {
            LOGGER.warning("No se ha podido identificar el directorio de java");
            return null;
        }
    }

    public static String getITextVersion() {
        try {
            Class<?> documentClass = Class.forName("com.lowagie.text.Document");
            Method getReleaseMethod = documentClass.getDeclaredMethod("getRelease", new Class[0]);
            return (String)getReleaseMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getSystemRoot() {
        if (!Platform.getOS().equals((Object)OS.WINDOWS)) {
            return File.separator;
        }
        String systemRoot = System.getProperty("SystemRoot");
        if (systemRoot == null) {
            String defaultSystemRoot = "C:\\WINDOWS";
            File winSys32 = new File("C:\\WINDOWS\\SYSTEM32");
            if (winSys32.exists() && winSys32.isDirectory()) {
                return "C:\\WINDOWS";
            }
        }
        if (systemRoot == null) {
            LOGGER.warning("No se ha encontrado el directorio ra&iacute;z del sistema, se devolver&aacute;: " + File.separator);
            systemRoot = File.separator;
        }
        return systemRoot;
    }

    public static String getSystemLibDir() {
        if (Platform.getOS().equals((Object)OS.WINDOWS)) {
            String systemRoot = Platform.getSystemRoot();
            if (systemRoot == null) {
                LOGGER.warning("No se ha podido determinar el directorio de Windows accediendo al registro, se usara 'C:\\WINDOWS\\'");
                systemRoot = "c:\\windows\\";
            }
            if (!systemRoot.endsWith("\\")) {
                systemRoot = String.valueOf(systemRoot) + "\\";
            }
            return String.valueOf(systemRoot) + "System32";
        }
        return "/usr/lib";
    }

    public static enum BROWSER {
        INTERNET_EXPLORER,
        FIREFOX,
        CHROME,
        SAFARI,
        OPERA,
        OTHER;

    }

    public static enum JREVER {
        J4,
        J5,
        J6,
        J7;

    }

    public static enum OS {
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX,
        ANDROID,
        OTHER;

    }
}

