/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.OfficeAnalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class MimeHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    public static final String DEFAULT_CONTENT_DESCRIPTION = "binary";
    public static final String DEFAULT_CONTENT_OID_DATA = "1.2.840.113549.1.7.1";
    private static Properties oidMimetypeProp = null;
    private static Properties mimetypeOidProp = null;
    private MimeInfo mimeInfo = null;
    private final byte[] data;
    private String mimeType = null;

    public MimeHelper(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("No se han indicado los datos que se desean analizar");
        }
        this.data = (byte[])data.clone();
        this.mimeInfo = new MimeInfo();
        try {
            Method getMagicMatchMethod = Class.forName("net.sf.jmimemagic.Magic").getMethod("getMagicMatch", byte[].class);
            Object magicMatchObject = getMagicMatchMethod.invoke(null, new Object[]{this.data});
            Class<?> magicMatchClass = Class.forName("net.sf.jmimemagic.MagicMatch");
            this.mimeInfo.setMimeType((String)magicMatchClass.getMethod("getMimeType", null).invoke(magicMatchObject, null));
            this.mimeInfo.setExtension((String)magicMatchClass.getMethod("getExtension", null).invoke(magicMatchObject, null));
            this.mimeInfo.setDescription((String)magicMatchClass.getMethod("getDescription", null).invoke(magicMatchObject, null));
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("No se encontro la biblioteca JMimeMagic para la deteccion del tipo de dato");
        }
        catch (Exception e) {
            try {
                Class<?> magicMatchNotFoundException = Class.forName("net.sf.jmimemagic.MagicMatchNotFoundException");
                if (e.getCause() != null && magicMatchNotFoundException.isInstance(e.getCause())) {
                    LOGGER.warning("No se pudo detectar el formato de los datos");
                } else {
                    LOGGER.warning("Error durante el analisis de la cabecera de los datos: " + e);
                }
            }
            catch (Exception e2) {
                LOGGER.warning("Error al cargar las bibliotecas de deteccion del tipo de dato: " + e2);
            }
        }
    }

    public static String transformMimeTypeToOid(String mimetype) throws IOException {
        if (mimetypeOidProp == null) {
            MimeHelper.loadMimetypeOidProperties();
        }
        return mimetype == null ? DEFAULT_CONTENT_OID_DATA : mimetypeOidProp.getProperty(mimetype, DEFAULT_CONTENT_OID_DATA);
    }

    public static String transformOidToMimeType(String oid) throws IOException {
        if (oidMimetypeProp == null) {
            MimeHelper.loadOidMimetypeProperties();
        }
        return oid == null ? DEFAULT_MIMETYPE : oidMimetypeProp.getProperty(oid, DEFAULT_MIMETYPE);
    }

    private static void loadOidMimetypeProperties() throws IOException {
        oidMimetypeProp = new Properties();
        InputStream isProp = MimeHelper.class.getClassLoader().getResourceAsStream("resources/mimetypes_oids.properties");
        if (isProp == null) {
            throw new IOException("No se ha encontrado el fichero de recursos para la relacion entre OIDs y MimeTypes");
        }
        oidMimetypeProp.load(isProp);
        isProp.close();
    }

    private static void loadMimetypeOidProperties() throws IOException {
        if (oidMimetypeProp == null) {
            MimeHelper.loadOidMimetypeProperties();
        }
        mimetypeOidProp = new Properties();
        String[] stringArray = oidMimetypeProp.keySet().toArray(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            mimetypeOidProp.put(oidMimetypeProp.get(key), key);
            ++n2;
        }
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            if (this.mimeInfo != null) {
                this.mimeType = this.mimeInfo.getMimeType();
            }
            if (this.mimeInfo == null || "text/xml".equals(this.mimeType)) {
                try {
                    DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(this.data));
                    this.mimeType = "text/xml";
                }
                catch (ParserConfigurationException e) {
                    LOGGER.severe("No se ha podido crear un DocumentBuilder XML, no se comprobara si es XML: " + e);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if ("application/zip".equals(this.mimeType) || "application/msword".equals(this.mimeType)) {
                this.mimeType = OfficeAnalizer.getMimeType(this.data);
            }
            if (this.mimeType == null) {
                this.mimeType = DEFAULT_MIMETYPE;
            }
        }
        return this.mimeType;
    }

    public String getExtension() {
        String extension = null;
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(this.data));
            extension = "xml";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (extension == null && this.mimeInfo != null) {
            extension = this.mimeInfo.getExtension();
        }
        if (extension != null && extension.equals("zip")) {
            try {
                extension = OfficeAnalizer.getExtension(this.data);
            }
            catch (IOException e) {
                LOGGER.severe("No se ha podido comprobar si el ZIP corresponde a un ODF o a un OOXML, se tomara como ZIP: " + e);
            }
        }
        return extension;
    }

    public String getDescription() {
        String desc = null;
        if (this.mimeInfo != null) {
            desc = this.mimeInfo.getDescription();
        }
        return desc == null || desc.length() == 0 ? DEFAULT_CONTENT_DESCRIPTION : desc;
    }

    static class MimeInfo {
        private String mType = null;
        private String extension = null;
        private String description = null;

        MimeInfo() {
        }

        void setMimeType(String mimeType) {
            this.mType = mimeType;
        }

        String getMimeType() {
            return this.mType;
        }

        String getExtension() {
            return this.extension;
        }

        void setExtension(String ext) {
            this.extension = ext;
        }

        String getDescription() {
            return this.description;
        }

        void setDescription(String desc) {
            this.description = desc;
        }
    }
}

