/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Logger;

public final class AOUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String[] SUPPORTED_URI_SCHEMES = new String[]{"http", "https", "file", "urn"};
    private static final String BASE_64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz=_-\n+/0123456789\r~";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private AOUtil() {
    }

    public static URI createURI(String file) throws URISyntaxException {
        if (file == null || "".equals(file)) {
            throw new IllegalArgumentException("No se puede crear una URI a partir de un nulo");
        }
        String filename = file.trim();
        if ("".equals(filename)) {
            throw new IllegalArgumentException("La URI no puede ser una cadena vacia");
        }
        filename = filename.replace('\\', '/');
        filename = filename.replace(" ", "%20").replace("<", "%3C").replace(">", "%3E").replace("\"", "%22").replace("{", "%7B").replace("}", "%7D").replace("|", "%7C").replace("^", "%5E").replace("[", "%5B").replace("]", "%5D").replace("`", "%60");
        URI uri = new URI(filename);
        String scheme = uri.getScheme();
        String[] stringArray = SUPPORTED_URI_SCHEMES;
        int n = SUPPORTED_URI_SCHEMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equals(scheme)) {
                return uri;
            }
            ++n2;
        }
        if (scheme == null) {
            filename = filename.replace("#", "%23");
            return AOUtil.createURI("file://" + filename);
        }
        if (scheme.length() == 1 && Character.isLetter((char)scheme.getBytes()[0])) {
            filename = filename.replace("#", "%23");
            return AOUtil.createURI("file://" + filename);
        }
        throw new URISyntaxException(filename, "Tipo de URI no soportado");
    }

    public static InputStream loadFile(URI uri) throws AOException, IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Se ha pedido el contenido de una URI nula");
        }
        if (uri.getScheme().equals("file")) {
            String path = uri.getSchemeSpecificPart();
            if (path.startsWith("//")) {
                path = path.substring(2);
            }
            return new FileInputStream(new File(path));
        }
        BufferedInputStream tmpStream = new BufferedInputStream(uri.toURL().openStream());
        byte[] tmpBuffer = AOUtil.getDataFromInputStream(tmpStream);
        return new ByteArrayInputStream(tmpBuffer);
    }

    public static byte[] getDataFromInputStream(InputStream input) throws IOException {
        if (input == null) {
            return new byte[0];
        }
        int nBytes = 0;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((nBytes = input.read(buffer)) != -1) {
            baos.write(buffer, 0, nBytes);
        }
        return baos.toByteArray();
    }

    public static String getCN(X509Certificate c) {
        if (c == null) {
            return null;
        }
        return AOUtil.getCN(c.getSubjectX500Principal().toString());
    }

    public static String getCN(String principal) {
        if (principal == null) {
            return null;
        }
        String rdn = AOUtil.getRDNvalue("cn", principal);
        if (rdn == null) {
            rdn = AOUtil.getRDNvalue("ou", principal);
        }
        if (rdn != null) {
            return rdn;
        }
        int i = principal.indexOf(61);
        if (i != -1) {
            LOGGER.warning("No se ha podido obtener el Common Name ni la Organizational Unit, se devolvera el fragmento mas significativo");
            return AOUtil.getRDNvalue(principal.substring(0, i), principal);
        }
        LOGGER.warning("Principal no valido, se devolvera la entrada");
        return principal;
    }

    private static String getRDNvalue(String rdn, String principal) {
        int offset1 = 0;
        while ((offset1 = principal.toLowerCase().indexOf(rdn.toLowerCase(), offset1)) != -1) {
            if (offset1 > 0 && principal.charAt(offset1 - 1) != ',' && principal.charAt(offset1 - 1) != ' ') {
                ++offset1;
                continue;
            }
            offset1 += rdn.length();
            while (offset1 < principal.length() && principal.charAt(offset1) == ' ') {
                ++offset1;
            }
            if (offset1 >= principal.length()) {
                return null;
            }
            if (principal.charAt(offset1) != '=') continue;
            ++offset1;
            while (offset1 < principal.length() && principal.charAt(offset1) == ' ') {
                ++offset1;
            }
            if (offset1 >= principal.length()) {
                return "";
            }
            if (principal.charAt(offset1) == ',') {
                return "";
            }
            if (principal.charAt(offset1) == '\"') {
                if (++offset1 >= principal.length()) {
                    return "";
                }
                int offset2 = principal.indexOf(34, offset1);
                if (offset2 == offset1) {
                    return "";
                }
                if (offset2 != -1) {
                    return principal.substring(offset1, offset2);
                }
                return principal.substring(offset1);
            }
            int offset2 = principal.indexOf(44, offset1);
            if (offset2 != -1) {
                return principal.substring(offset1, offset2).trim();
            }
            return principal.substring(offset1).trim();
        }
        return null;
    }

    public static boolean isBase64(byte[] data) {
        int count = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (BASE_64_ALPHABET.indexOf((char)b) == -1) {
                return false;
            }
            if (b != 10 && b != 13) {
                ++count;
            }
            ++n2;
        }
        return count % 4 == 0;
    }

    public static String hexify(byte[] abyte0, boolean separator) {
        if (abyte0 == null) {
            return "null";
        }
        StringBuffer stringbuffer = new StringBuffer(256);
        int i = 0;
        int j = 0;
        while (j < abyte0.length) {
            if (separator && i > 0) {
                stringbuffer.append('-');
            }
            stringbuffer.append(HEX_CHARS[abyte0[j] >> 4 & 0xF]);
            stringbuffer.append(HEX_CHARS[abyte0[j] & 0xF]);
            if (++i == 16) {
                if (separator && j < abyte0.length - 1) {
                    stringbuffer.append('\n');
                }
                i = 0;
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public static String hexify(byte[] abyte0, String separator) {
        if (abyte0 == null) {
            return "null";
        }
        StringBuffer stringbuffer = new StringBuffer(256);
        int j = 0;
        while (j < abyte0.length) {
            if (separator != null && j > 0) {
                stringbuffer.append(separator);
            }
            stringbuffer.append(HEX_CHARS[abyte0[j] >> 4 & 0xF]);
            stringbuffer.append(HEX_CHARS[abyte0[j] & 0xF]);
            ++j;
        }
        return stringbuffer.toString();
    }

    public static String showTreeAsString(AOTreeModel tree, String linePrefx, String identationString) {
        if (tree == null || tree.getRoot() == null) {
            LOGGER.severe("Se ha proporcionado un arbol de firmas vacio");
            return null;
        }
        if (!(tree.getRoot() instanceof AOTreeNode)) {
            LOGGER.severe("La raiz del arbol de firmas no es de tipo DafaultMutableTreeNode");
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        AOTreeNode root = (AOTreeNode)tree.getRoot();
        int i = 0;
        while (i < root.getChildCount()) {
            AOUtil.archiveTreeNode(root.getChildAt(i), 0, linePrefx != null ? linePrefx : "", identationString != null ? identationString : "\t", buffer);
            ++i;
        }
        return buffer.toString();
    }

    private static void archiveTreeNode(AOTreeNode node, int depth, String linePrefx, String identationString, StringBuilder buffer) {
        buffer.append('\n').append(linePrefx);
        int i = 0;
        while (i < depth) {
            buffer.append(identationString);
            ++i;
        }
        buffer.append(node.getUserObject());
        i = 0;
        while (i < node.getChildCount()) {
            AOUtil.archiveTreeNode(node.getChildAt(i), depth + 1, linePrefx, identationString, buffer);
            ++i;
        }
    }

    public static void loadNativeLibrary(String path) throws IOException {
        if (path == null) {
            LOGGER.warning("No se puede cargar una biblioteca nula");
            return;
        }
        int pos = path.lastIndexOf(46);
        File file = new File(path);
        File tempLibrary = File.createTempFile(pos < 1 ? file.getName() : file.getName().substring(0, file.getName().indexOf(46)), pos < 1 || pos == path.length() - 1 ? null : path.substring(pos));
        AOUtil.copyFile(file, tempLibrary);
        if (tempLibrary != null) {
            tempLibrary.deleteOnExit();
        }
        LOGGER.info("Cargamos " + (tempLibrary == null ? path : tempLibrary.getAbsolutePath()));
        System.load(tempLibrary != null ? tempLibrary.getAbsolutePath() : path);
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (source == null || dest == null) {
            throw new IllegalArgumentException("Ni origen ni destino de la copia pueden ser nulos");
        }
        FileInputStream is = new FileInputStream(source);
        FileOutputStream os = new FileOutputStream(dest);
        FileChannel in = is.getChannel();
        FileChannel out = os.getChannel();
        MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size());
        out.write(buf);
        in.close();
        out.close();
        is.close();
        os.close();
    }

    public static String[] split(String text, String sp) {
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        int j = 0;
        while (i != text.length() && (j = text.indexOf(sp, i)) != -1) {
            if (i == j) {
                parts.add("");
            } else {
                parts.add(text.substring(i, j));
            }
            i = j + sp.length();
        }
        if (i == text.length()) {
            parts.add("");
        } else {
            parts.add(text.substring(i));
        }
        return parts.toArray(new String[0]);
    }
}

