/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.ciphers;

import es.gob.afirma.core.ciphers.CipherConstants;
import java.security.NoSuchAlgorithmException;

public final class AOCipherConfig {
    private CipherConstants.AOCipherAlgorithm algo;
    private CipherConstants.AOCipherBlockMode mode;
    private CipherConstants.AOCipherPadding padding;

    public AOCipherConfig(CipherConstants.AOCipherAlgorithm algo, CipherConstants.AOCipherBlockMode mode, CipherConstants.AOCipherPadding padd) {
        CipherConstants.AOCipherPadding ciphPadding;
        CipherConstants.AOCipherAlgorithm ciphAlgo = algo != null ? algo : CipherConstants.AOCipherAlgorithm.getDefault();
        CipherConstants.AOCipherBlockMode ciphMode = mode;
        if (ciphMode == null) {
            ciphMode = ciphAlgo.equals((Object)CipherConstants.AOCipherAlgorithm.PBEWITHMD5ANDDES) || ciphAlgo.equals((Object)CipherConstants.AOCipherAlgorithm.PBEWITHSHA1ANDDESEDE) || ciphAlgo.equals((Object)CipherConstants.AOCipherAlgorithm.PBEWITHSHA1ANDRC2_40) ? CipherConstants.AOCipherBlockMode.CBC : CipherConstants.AOCipherBlockMode.ECB;
        }
        if ((ciphPadding = padd) == null) {
            ciphPadding = ciphAlgo.equals((Object)CipherConstants.AOCipherAlgorithm.ARCFOUR) ? CipherConstants.AOCipherPadding.NOPADDING : CipherConstants.AOCipherPadding.PKCS5PADDING;
        }
        this.algo = ciphAlgo;
        this.mode = ciphMode;
        this.padding = ciphPadding;
    }

    public static AOCipherConfig parse(String cipherConfig) throws NoSuchAlgorithmException {
        CipherConstants.AOCipherAlgorithm cipAlgo = null;
        CipherConstants.AOCipherBlockMode cipBlockMode = null;
        CipherConstants.AOCipherPadding cipPadding = null;
        String[] algoConfig = cipherConfig.split("/");
        cipAlgo = CipherConstants.AOCipherAlgorithm.getValueOf(algoConfig[0]);
        if (cipAlgo == null) {
            throw new NoSuchAlgorithmException();
        }
        if (algoConfig.length == 3) {
            cipBlockMode = CipherConstants.AOCipherBlockMode.getValueOf(algoConfig[1]);
            cipPadding = CipherConstants.AOCipherPadding.getValueOf(algoConfig[2]);
        }
        return new AOCipherConfig(cipAlgo, cipBlockMode, cipPadding);
    }

    public String toString() {
        StringBuilder config = new StringBuilder(this.algo.getName());
        if (this.mode != null && this.padding != null) {
            config.append("/").append(this.mode.getName()).append("/").append(this.padding.getName());
        }
        return config.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AOCipherConfig)) {
            return false;
        }
        return ((AOCipherConfig)obj).algo.equals((Object)this.algo) && ((AOCipherConfig)obj).mode.equals((Object)this.mode) && ((AOCipherConfig)obj).padding.equals((Object)this.padding);
    }

    public int hashCode() {
        return this.algo.hashCode() + this.mode.hashCode() + this.padding.hashCode();
    }

    public CipherConstants.AOCipherAlgorithm getAlgorithm() {
        return this.algo;
    }

    public CipherConstants.AOCipherBlockMode getBlockMode() {
        return this.mode;
    }

    public CipherConstants.AOCipherPadding getPadding() {
        return this.padding;
    }

    public void setAlgorithm(CipherConstants.AOCipherAlgorithm algo) {
        this.algo = algo;
    }

    public void setBlockMode(CipherConstants.AOCipherBlockMode mode) {
        this.mode = mode;
    }

    public void setPadding(CipherConstants.AOCipherPadding padding) {
        this.padding = padding;
    }
}

