/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.util;

import es.gob.aeat.dit.ov.renta.Enviroment;
import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Util {
    private static final String ATENEO_CMD = "cscript";
    private static final String ATENEO_SCRIPT = "C:\\AEAT\\ATENEO\\OPERADOR\\SCRIPTS\\regDcl.wsf";
    public static final int UNINIT = -3;
    public static final int UNAVAILABLE = -2;
    public static final int UNKNOWN = -1;
    public static final int MSIE = 0;
    public static final int FIREFOX = 1;
    public static final int CHROME = 2;
    public static final int APPLE = 3;

    public static String toHexString(byte[] data) {
        String hex = "";
        int i = 0;
        while (i < data.length) {
            String d = Integer.toHexString(data[i]);
            if (d.length() == 1) {
                d = "0" + d;
            } else if (d.length() > 2) {
                d = d.substring(d.length() - 2);
            }
            hex = String.valueOf(hex) + d.toUpperCase();
            ++i;
        }
        return hex;
    }

    public static byte[] readFile(File f1, int length) throws IOException {
        int leidos;
        FileInputStream fin = new FileInputStream(f1);
        byte[] buffer = new byte[length];
        int leidosTotal = 0;
        while ((leidos = fin.read(buffer, leidosTotal, length - leidosTotal)) >= 0 && leidosTotal < length) {
            leidosTotal += leidos;
        }
        fin.close();
        return buffer;
    }

    public static byte[] readFile(File f1) throws IOException {
        int leidos;
        FileInputStream fin = new FileInputStream(f1);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        while ((leidos = fin.read(buffer)) >= 0) {
            bout.write(buffer, 0, leidos);
        }
        fin.close();
        bout.close();
        return bout.toByteArray();
    }

    public static void showLinkInBrowser(Component parent, String urlStr) {
        block6: {
            try {
                URL url = new URL(urlStr);
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null));
                    break block6;
                }
                if (Util.isWindows()) {
                    Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url.toString()});
                    break block6;
                }
                if (Util.isLinux()) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open ", url.toString()});
                    break block6;
                }
                if (Util.isMacintosh()) {
                    Runtime.getRuntime().exec(new String[]{"open ", url.toString()});
                    break block6;
                }
                throw new Exception("Plataforma desconocida");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(parent, Enviroment.getInstance().getString("ContriPanel.ShowNav"), Enviroment.getInstance().getString("ContriPanel.ErrTitle"), 0);
            }
        }
    }

    public static void showPDF(Component parent, String file, boolean showWarnOnError) {
        block9: {
            try {
                if (Util.isWindows()) {
                    Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", file});
                    break block9;
                }
                if (Util.isLinux()) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", file});
                    break block9;
                }
                if (Util.isMacintosh()) {
                    boolean launched = false;
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(new File(file));
                            launched = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!launched) {
                        Runtime.getRuntime().exec(new String[]{"open", file});
                    }
                    break block9;
                }
                throw new Exception("Plataforma desconocida");
            }
            catch (Exception ex) {
                if (!showWarnOnError) break block9;
                JOptionPane.showMessageDialog(parent, Enviroment.getInstance().getString("ContriPanel.ShowNav"), Enviroment.getInstance().getString("ContriPanel.ErrTitle"), 0);
            }
        }
    }

    public static void showPDF(Component parent, String file) {
        Util.showPDF(parent, file, true);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("indows") > 0;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
    }

    public static boolean isMacintosh() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static String formatNumericData(String texto, int numDecimales) {
        String format = "0";
        if (numDecimales > 0) {
            format = String.valueOf(format) + ".";
        }
        int i = 0;
        while (i < numDecimales) {
            format = String.valueOf(format) + "0";
            ++i;
        }
        DecimalFormat df = new DecimalFormat(format);
        try {
            double value = Double.parseDouble(texto);
            return df.format(value);
        }
        catch (NumberFormatException numberFormatException) {
            return texto;
        }
    }

    public static String fillTextData(String dato, int length) {
        String aux = null;
        if (dato != null) {
            aux = dato.trim();
            while (aux.length() < length) {
                aux = String.valueOf(aux) + " ";
            }
            if (aux.length() > length) {
                aux = aux.substring(0, length);
            }
        }
        return aux;
    }

    public static String fillNumericData(String dato, int length) {
        String aux = null;
        if (dato != null) {
            aux = dato.trim();
            while (aux.length() < length) {
                aux = "0" + aux;
            }
            if (aux.length() > length) {
                aux = aux.substring(aux.length() - length);
            }
        }
        return aux;
    }

    public static int getDefaultBrowser() {
        int browser = -1;
        if (Util.isWindows()) {
            browser = Util.getDefaultBrowserAssociations();
            if (browser == -1 || browser == -2) {
                browser = Util.getDefaultBrowserCommand();
            }
        } else if (Util.isLinux()) {
            browser = 1;
        } else if (Util.isMacintosh()) {
            browser = Util.getDefaultBrowserMac();
        }
        return browser;
    }

    public static int getDefaultBrowserMac() {
        int browser = -1;
        try {
            File tempF = new File("services.xml");
            String cmd = "plutil -convert xml1 " + System.getProperty("user.home") + "/Library/Preferences/com.apple.LaunchServices.plist -o " + tempF.getName();
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                p.waitFor();
                p.exitValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String fileContent = Util.readLaunchServices(tempF);
            if (fileContent.length() <= 0) {
                Enviroment.getInstance().getLog().logp(Level.SEVERE, "Util", "getDefaultBrowserMac", "LaunchServices vacio");
                browser = -2;
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                dbf.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(fileContent)));
                NodeList listKeys = doc.getElementsByTagName("key");
                Node handlers = null;
                int i = 0;
                while (i < listKeys.getLength() && handlers == null) {
                    if (listKeys.item(i).getFirstChild().getNodeValue().equals("LSHandlers")) {
                        handlers = listKeys.item(i).getNextSibling();
                    }
                    ++i;
                }
                if (handlers != null) {
                    NodeList listDict = handlers.getChildNodes();
                    String browserStr = null;
                    int i2 = 0;
                    while (i2 < listDict.getLength() && browserStr == null) {
                        Element dict = (Element)listDict.item(i2);
                        String LSHandlerRoleAll = null;
                        String LSHandlerURLScheme = null;
                        NodeList keys = dict.getElementsByTagName("key");
                        int j = 0;
                        while (j < keys.getLength()) {
                            if (keys.item(j).getFirstChild().getNodeValue().equals("LSHandlerRoleAll")) {
                                LSHandlerRoleAll = keys.item(j).getNextSibling().getFirstChild().getNodeValue();
                            } else if (keys.item(j).getFirstChild().getNodeValue().equals("LSHandlerURLScheme")) {
                                LSHandlerURLScheme = keys.item(j).getNextSibling().getFirstChild().getNodeValue();
                            }
                            ++j;
                        }
                        if (LSHandlerRoleAll != null && LSHandlerURLScheme != null && LSHandlerURLScheme.equals("http")) {
                            browserStr = LSHandlerRoleAll;
                        }
                        ++i2;
                    }
                    browser = browserStr != null && browserStr.indexOf("firefox") >= 0 ? 1 : 3;
                }
            }
        }
        catch (Throwable e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, "Util", "getDefaultBrowserMac", "Error obteniendo LaunchServices", e);
            browser = -2;
        }
        return browser;
    }

    private static String readLaunchServices(File tempF) {
        String content = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(tempF));
            while ((line = br.readLine()) != null) {
                if (line.indexOf("<!DOCTYPE") != -1) continue;
                content = String.valueOf(content) + line.trim();
            }
            br.close();
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, "Util", "readLaunchServices", "Error leyendo fichero services.xml", e);
        }
        return content;
    }

    private static int getDefaultBrowserCommand() {
        int browser = -1;
        try {
            Process process = Runtime.getRuntime().exec("REG QUERY HKEY_CLASSES_ROOT\\http\\shell\\open\\command");
            Scanner kb = new Scanner(process.getInputStream());
            while (kb.hasNextLine() && browser == -1) {
                String registry = kb.nextLine().replaceAll("\\\\", "/").trim();
                if (registry.indexOf("/iexplore.exe") >= 0) {
                    browser = 0;
                    continue;
                }
                if (registry.indexOf("/chrome.exe") >= 0) {
                    browser = 2;
                    continue;
                }
                if (registry.indexOf("/firefox.exe") < 0) continue;
                browser = 1;
            }
            kb.close();
        }
        catch (Throwable e) {
            browser = -2;
        }
        return browser;
    }

    private static int getDefaultBrowserAssociations() {
        int browser = -1;
        try {
            Process process = Runtime.getRuntime().exec("REG QUERY HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice");
            Scanner kb = new Scanner(process.getInputStream());
            while (kb.hasNextLine() && browser == -1) {
                String registry = kb.nextLine().replaceAll("\\\\", "/").trim();
                if (registry.toLowerCase().indexOf("progid") < 0) continue;
                browser = registry.toLowerCase().indexOf("firefox") >= 0 ? 1 : 0;
            }
            kb.close();
        }
        catch (Throwable e) {
            browser = -2;
        }
        return browser;
    }

    public static String getDefaultBrowserString() {
        switch (Util.getDefaultBrowser()) {
            case -2: {
                return "UNAVAILABLE";
            }
            case 2: {
                return "CHROME";
            }
            case 0: {
                return "MSIE";
            }
            case 1: {
                return "FIREFOX";
            }
            case 3: {
                return "APPLE";
            }
        }
        return "UNKNOWN";
    }

    public static void callAteneo(String id) {
        try {
            File f = new File(ATENEO_SCRIPT);
            if (f.exists()) {
                Runtime.getRuntime().exec("cscript C:\\AEAT\\ATENEO\\OPERADOR\\SCRIPTS\\regDcl.wsf /tipo:Inm /id:" + id);
            } else {
                Enviroment.getInstance().getLog().logp(Level.SEVERE, "Util", "callAteneo", "No existe el script");
            }
        }
        catch (Throwable ex) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, "Util", "callAteneo", "Error llamando a ATENEO", ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String rellenarBlancos(String dato, int longitud) {
        block1: {
            aux = dato;
            if (aux.length() <= longitud) ** GOTO lbl6
            aux = aux.substring(0, longitud);
            break block1;
lbl-1000:
            // 1 sources

            {
                aux = String.valueOf(aux) + " ";
lbl6:
                // 2 sources

                ** while (aux.length() < longitud)
            }
        }
        return aux;
    }

    /*
     * Unable to fully structure code
     */
    public static String rellenarNumeros(String dato, int longitud) {
        block1: {
            aux = dato;
            if (aux.length() <= longitud) ** GOTO lbl6
            aux = aux.substring(0, longitud);
            break block1;
lbl-1000:
            // 1 sources

            {
                aux = "0" + aux;
lbl6:
                // 2 sources

                ** while (aux.length() < longitud)
            }
        }
        return aux;
    }
}

