/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.signature;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.signature.MySSLSocketFactory;
import es.gob.aeat.dit.ov.renta.signature.OVSignature;
import es.gob.aeat.dit.ov.renta.util.Util;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSignerFactory;
import es.gob.afirma.keystores.main.common.AOCertificatesNotFoundException;
import es.gob.afirma.keystores.main.common.AOKeyStore;
import es.gob.afirma.keystores.main.common.AOKeyStoreManager;
import es.gob.afirma.keystores.main.common.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.main.common.AOKeystoreAlternativeException;
import es.gob.afirma.keystores.main.common.KeyStoreUtilities;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;

public class RentaKeyManager2
implements X509KeyManager {
    public static boolean INIT_CAPI = false;
    public static String SECURITY_PROTOCOL = "SSLv3";
    public static final String SIGNATURE_FORMAT = "CAdES";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String DNIE_AUTH_1 = "(AUTENTICACION)";
    private static final String DNIE_AUTH_2 = "(AUTENTICACI\u00d3N)";
    private static final String DNIE_SIGN = "(FIRMA)";
    private static final String DNIE_ORG_1 = "DIRECCION GENERAL DE LA POLICIA";
    private static final String DNIE_ORG_2 = "DIRECCI\u00d3N GENERAL DE LA POLIC\u00cdA";
    private static final int CERT_NAME_LENGTH = 100;
    private static AOKeyStore KEY_STORE_TYPE = AOKeyStore.WINDOWS;
    private AOKeyStoreManager ksManager = null;
    private Object parent;
    private String aliasSSL;
    private static RentaKeyManager2 instance;

    public static RentaKeyManager2 getInstance() {
        if (instance == null) {
            instance = new RentaKeyManager2();
        }
        return instance;
    }

    private RentaKeyManager2() {
    }

    private AOKeyStoreManager getKeyManager() {
        if (Util.getDefaultBrowser() == 1) {
            KEY_STORE_TYPE = AOKeyStore.MOZ_UNI;
        }
        try {
            this.ksManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(KEY_STORE_TYPE, null, null, KeyStoreUtilities.getPreferredPCB(KEY_STORE_TYPE, this.parent), this.parent);
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "RentaKeyManager", "Error inicializando almacen de claves (KEY_STORE_TYPE = " + (Object)((Object)KEY_STORE_TYPE) + ")", e);
        }
        return this.ksManager;
    }

    private X509TrustManager getTrustManager() {
        X509TrustManager trustMgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return trustMgr;
    }

    public void setParentComponent(Object parent) {
        this.parent = parent;
    }

    public SSLSocketFactory getSocketFactory() {
        MySSLSocketFactory sslsf = null;
        try {
            SSLContext context = SSLContext.getInstance(SECURITY_PROTOCOL);
            context.init(new KeyManager[]{this}, new TrustManager[]{this.getTrustManager()}, null);
            sslsf = new MySSLSocketFactory(context);
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getSocketFactory", "Error obteniendo socket factory ssl", e);
        }
        return sslsf;
    }

    private String getNifFromCert(X509Certificate cert) {
        int indSN;
        String nif = null;
        String dn = cert.getSubjectDN().getName();
        String cn = null;
        if (dn.indexOf("CN=") >= 0) {
            int indCN = dn.indexOf("CN=");
            cn = dn.indexOf(",", indCN) >= 0 ? dn.substring(indCN + 3, dn.indexOf(",", indCN)) : dn.substring(indCN + 3);
        }
        if (cn != null) {
            int indCIF = cn.indexOf(" - CIF ");
            int indNIF = cn.indexOf(" - NIF ");
            if (indCIF >= 0) {
                nif = cn.substring(indCIF + 7, indCIF + 7 + 9);
            } else if (indNIF >= 0) {
                nif = cn.substring(indNIF + 7, indNIF + 7 + 9);
            }
        }
        String SNStr = "SERIALNUMBER=";
        if (nif == null && dn.indexOf(SNStr) >= 0 && (indSN = dn.toUpperCase().indexOf(SNStr)) >= 0) {
            nif = dn.indexOf(",", indSN) >= 0 ? dn.substring(indSN + SNStr.length(), dn.indexOf(",", indSN)) : dn.substring(indSN + SNStr.length());
        }
        return nif;
    }

    public OVSignature sign(Object parent, byte[] data, String alias) throws AOKeystoreAlternativeException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException, CertificateException, AOException {
        KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, parent));
        String nif = this.getNifFromCert((X509Certificate)pke.getCertificate());
        if (nif == null) {
            throw new CertificateException(Enviroment.getInstance().getString("RentaKeyManager.ErrCert"));
        }
        AOSigner signer = AOSignerFactory.getSigner(SIGNATURE_FORMAT);
        Properties extraParams = new Properties();
        extraParams.put("mode", "explicit");
        extraParams.put("policyIdentifier", "urn:oid:2.16.724.1.3.1.1.2.1.8");
        extraParams.put("policyIdentifierHashAlgorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        extraParams.put("policyQualifier", "http://administracionelectronica.gob.es/es/ctt/politicafirma/politica_firma_AGE_v1_8.pdf");
        extraParams.put("policyIdentifierHash", "7SxX3erFuH31TvAw9LZ70N7p1vA=");
        String signature = Base64.encode(signer.sign(data, SIGNATURE_ALGORITHM, pke.getPrivateKey(), pke.getCertificateChain(), extraParams));
        return new OVSignature(Base64.encode(data), signature, nif);
    }

    public boolean isValidCertAEAT(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
        String nif = this.getNifFromCert((X509Certificate)pke.getCertificate());
        return nif != null;
    }

    public String selectAlias() {
        INIT_CAPI = true;
        String selectedAlias = null;
        try {
            AOKeyStoreManager ksm = this.getKeyManager();
            selectedAlias = KeyStoreUtilities.showCertSelectionDialog(ksm.getAliases(), ksm, this.parent, true, true, true, null, false);
        }
        catch (AOCertificatesNotFoundException e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "selectAlias", "No se encontraron certificados", e);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            // empty catch block
        }
        INIT_CAPI = false;
        return selectedAlias;
    }

    public void setAliasSSL(String alias) {
        this.aliasSSL = alias;
    }

    public String getCertCN(String alias) {
        try {
            KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
            if (pke.getCertificate() instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)pke.getCertificate();
                String dn = cert.getSubjectDN().getName();
                if ((dn = this.getAttrFromPrincipal(dn, "CN")).length() > 100) {
                    dn = String.valueOf(dn.substring(0, 100)) + "...";
                }
                return dn;
            }
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getCertCN", "No se pudo devolver la clave privada", e);
        }
        return null;
    }

    private String getAttrFromPrincipal(String principal, String attr) {
        String value = "";
        String[] parts = principal.split(",");
        int i = 1;
        while (i < parts.length) {
            if (parts[i].indexOf("=") < 0) {
                int n = i - 1;
                parts[n] = String.valueOf(parts[n]) + "," + parts[i];
                parts[i] = "";
            }
            ++i;
        }
        i = 0;
        while (i < parts.length) {
            String[] parts2;
            if (parts[i].length() > 0 && (parts2 = parts[i].split("=")).length >= 2 && parts2[0].trim().equals(attr)) {
                String cn = "";
                int j = 1;
                while (j < parts2.length) {
                    cn = String.valueOf(cn) + parts2[j].trim() + "=";
                    ++j;
                }
                value = cn.substring(0, cn.length() - 1);
            }
            ++i;
        }
        return value;
    }

    public String getCertInfo(String alias) {
        String info = null;
        try {
            KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
            if (pke.getCertificate() instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)pke.getCertificate();
                info = "Subject: " + cert.getSubjectDN().getName() + System.getProperty("line.separator");
                info = String.valueOf(info) + "Issuer: " + cert.getIssuerDN().getName() + System.getProperty("line.separator");
                info = String.valueOf(info) + "Signature Algorithm: " + cert.getSigAlgName() + System.getProperty("line.separator");
                info = String.valueOf(info) + "SerialNumber: " + cert.getSerialNumber() + System.getProperty("line.separator");
                info = String.valueOf(info) + "Version: " + cert.getVersion() + System.getProperty("line.separator");
                info = String.valueOf(info) + "Validity: From " + cert.getNotBefore() + ", To: " + cert.getNotAfter() + System.getProperty("line.separator");
                return info;
            }
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getCertInfo", "No se pudo devolver la clave privada", e);
        }
        return info;
    }

    public boolean isCertDNIEFirma(String alias) {
        boolean result = false;
        try {
            KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
            if (pke.getCertificate() instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)pke.getCertificate();
                String subjectCN = this.getAttrFromPrincipal(cert.getSubjectDN().getName(), "CN").trim();
                String issuerO = this.getAttrFromPrincipal(cert.getIssuerDN().getName(), "O").trim();
                result = subjectCN.indexOf(DNIE_SIGN) > 0 && (issuerO.equals(DNIE_ORG_1) || issuerO.equals(DNIE_ORG_2));
            }
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "isCertDNIEFirma", "No se pudo devolver la clave privada", e);
        }
        return result;
    }

    public boolean isCertDNIEAuthentication(String alias) {
        boolean result = false;
        try {
            KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
            if (pke.getCertificate() instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)pke.getCertificate();
                String subjectCN = this.getAttrFromPrincipal(cert.getSubjectDN().getName(), "CN").trim();
                String issuerO = this.getAttrFromPrincipal(cert.getIssuerDN().getName(), "O").trim();
                result = !(subjectCN.indexOf(DNIE_AUTH_1) <= 0 && subjectCN.indexOf(DNIE_AUTH_2) <= 0 || !issuerO.equals(DNIE_ORG_1) && !issuerO.equals(DNIE_ORG_2));
            }
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "isCertDNIEAuthentication", "No se pudo devolver la clave privada", e);
        }
        return result;
    }

    @Override
    public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
        return this.aliasSSL;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
            if (pke.getCertificate() instanceof X509Certificate) {
                return (X509Certificate[])pke.getCertificateChain();
            }
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getCertificateChain", "No se pudo devolver la clave privada", e);
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            KeyStore.PrivateKeyEntry pke = this.getKeyManager().getKeyEntry(alias, KeyStoreUtilities.getCertificatePC(KEY_STORE_TYPE, this.parent));
            return pke.getPrivateKey();
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getPrivateKey", "No se pudo devolver la clave privada", e);
            return null;
        }
    }

    @Override
    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        System.out.println("chooseServerAlias");
        return null;
    }

    @Override
    public String[] getServerAliases(String arg0, Principal[] arg1) {
        System.out.println("getServerAliases");
        return null;
    }

    @Override
    public String[] getClientAliases(String arg0, Principal[] arg1) {
        System.out.println("getClientAliases");
        return null;
    }
}

