/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.signature;

import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.signature.OVSignature;
import es.gob.aeat.dit.ov.renta.util.Util;
import es.gob.afirma.core.misc.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PIN24HSigner {
    public OVSignature sign(String data, PIN24HId pinId) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("sha-512");
        byte[] digest = md.digest(pinId.getClave().getBytes("iso-8859-15"));
        String claveSHA = Util.toHexString(digest);
        md.reset();
        digest = md.digest(pinId.getPin().getBytes("iso-8859-15"));
        String pinSHA = Util.toHexString(digest);
        md.reset();
        digest = md.digest((String.valueOf(claveSHA) + pinSHA).getBytes());
        String token = Util.toHexString(digest);
        md.reset();
        byte[] dataBytes = data.getBytes("iso-8859-15");
        digest = md.digest(dataBytes);
        String origenFirma = Util.toHexString(digest);
        md.reset();
        digest = md.digest((String.valueOf(origenFirma) + token).getBytes());
        String firma = Util.toHexString(digest);
        md.reset();
        String txtB64 = Base64.encode(dataBytes);
        OVSignature signature = new OVSignature(txtB64, firma, pinId.getNif());
        return signature;
    }
}

