/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.RentaException;
import es.gob.aeat.dit.ov.renta.http.HttpHandler;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import es.gob.aeat.dit.ov.renta.http.IntranetAuthenticator;
import es.gob.aeat.dit.ov.renta.http.PIN24HAuthenticator;
import es.gob.aeat.dit.ov.renta.http.PTHttpResponse;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.swing.JDialog;

public class RentaSender {
    private static final String LINK_INI = "<script>window.location.replace('";
    private static final String LINK_FIN = "')</script>";
    private Enviroment env = Enviroment.getInstance();
    private String csv = null;
    private String[] errores = null;
    private PTHttpResponse response;
    private String linkToken = null;

    public void sendRentaByPIN24H(Object owner, Declaracion renta, PIN24HId pinId, boolean firmaBasica, String firNif, String firNombre) throws RentaException {
        String url;
        PIN24HAuthenticator pa = new PIN24HAuthenticator();
        if (!pa.authenticate(pinId.getNif(), pinId.getClave(), pinId.getPin())) {
            throw new RentaException("PIN24H: " + pa.getError());
        }
        try {
            url = this.env.getURL(1, 1, renta.getModelo());
        }
        catch (FileNotFoundException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt1"));
        }
        catch (IOException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt2"), e.getMessage());
        }
        catch (Exception e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt3"), "PT_PIN");
        }
        this.sendRentaWithSignature(owner, renta, url, null, firmaBasica, firNif, firNombre);
    }

    public void sendRentaByCert(Object owner, Declaracion renta, String aliasCertIntranet, boolean firmaBasica, String firNif, String firNombre) throws RentaException {
        String url;
        try {
            url = this.env.getURL(1, this.env.isIntranet() ? 3 : 0, renta.getModelo());
        }
        catch (FileNotFoundException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt1"));
        }
        catch (IOException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt2"), e.getMessage());
        }
        catch (Exception e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt3"), "PT_CER");
        }
        if (firmaBasica) {
            url = url.replaceAll("www2", "www1");
        }
        this.sendRentaWithSignature(owner, renta, url, aliasCertIntranet, firmaBasica, firNif, firNombre);
    }

    private void sendRentaWithSignature(Object owner, Declaracion renta, String url, String aliasCertIntranet, boolean firmaBasica, String firNif, String firNom) throws RentaException {
        IntranetAuthenticator ia;
        if (!this.isSet(renta.getDeclaracion())) {
            throw new RentaException(this.env.getString("RentaSender.ErrFicVacio"));
        }
        if (!this.env.isIntranet() && renta.getSignatureD() == null) {
            throw new RentaException(this.env.getString("RentaSender.ErrNumFir"));
        }
        if (renta.getTIA() == '-') {
            throw new RentaException(this.env.getString("RentaSender.ErrTIA"));
        }
        if (this.env.isIntranet() && !(ia = new IntranetAuthenticator()).authenticate(aliasCertIntranet, owner instanceof JDialog ? (JDialog)owner : null)) {
            throw new RentaException("Intranet: " + ia.getError());
        }
        try {
            HttpHandler hh = new HttpHandler(url);
            String hid = renta.getHID(this.env.isIntranet());
            hh.addPOSTParam("HID", hid);
            if (firmaBasica) {
                hh.addPOSTParam("FIRNIF", firNif);
                hh.addPOSTParam("FIRNOMBRE", firNom);
            }
            hh.addPOSTParam("CMN", "");
            hh.addPOSTParam("LOT", "0");
            hh.addPOSTParam("IDI", this.env.getIdioma().toUpperCase());
            hh.addPOSTParam("LEV", renta.isErroresLeves() ? "100000000000" : "000000000000");
            hh.addPOSTParam("F01", renta.getDeclaracion());
            hh.addPOSTParam("PUN", "00000000");
            hh.addPOSTParam("RFD", "");
            if (renta.getModelo() == 100) {
                hh.addPOSTParam("RFC", "");
            }
            if (this.env.isIntranet()) {
                hh.addPOSTParam("TXT", "");
                hh.addPOSTParam("FD1", "");
                hh.addPOSTParam("FD2", "");
            } else {
                hh.addPOSTParam("TXT", firmaBasica ? "" : renta.getSignatureD().getTxtB64());
                hh.addPOSTParam("FD1", firmaBasica ? "FirmaBasica" : renta.getSignatureD().getSignature());
                if (renta.getModelo() == 100) {
                    if (renta.getSignatureC() != null) {
                        String nifCertD = renta.getSignatureD().getNif();
                        String nifCertC = renta.getSignatureC().getNif();
                        if (nifCertC == null || !nifCertC.equals(nifCertD)) {
                            hh.addPOSTParam("FD2", firmaBasica ? "" : renta.getSignatureC().getSignature());
                        } else {
                            hh.addPOSTParam("FD2", "");
                        }
                    } else {
                        hh.addPOSTParam("FD2", "");
                    }
                }
            }
            hh.addPOSTParam("NRC", renta.getNRC());
            hh.addPOSTParam("TIA", "" + renta.getTIA());
            hh.addPOSTParam("ING", renta.getING());
            hh.addPOSTParam("ICO", renta.getICO());
            hh.addPOSTParam("ENT", "GRABA");
            hh.addPOSTParam("FIN", "");
            this.env.getLog().logp(Level.INFO, this.getClass().getName(), "sendRentaWithSignature", hh.toString());
            HttpResponse resp = hh.doPost();
            this.processResponse(new PTHttpResponse(resp));
        }
        catch (MalformedURLException e) {
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-1)");
        }
        catch (UnknownHostException uhe) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "sendRentaWithSignature", "Error en comunicaci\u00f3n", uhe);
            throw new RentaException(this.env.getString("DFRetriever.ErrProxy"), uhe.getMessage());
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "sendRentaWithSignature", "Error en comunicaci\u00f3n", e);
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-2)", e.getMessage());
        }
    }

    public void sendRentaByRef(Object owner, Declaracion renta) throws RentaException {
        String url;
        if (!this.isSet(renta.getDeclaracion())) {
            throw new RentaException(this.env.getString("RentaSender.ErrFicVacio"));
        }
        if (renta.getNumRefD() == null) {
            throw new RentaException(this.env.getString("RentaSender.ErrNumRefs"));
        }
        if (renta.getTIA() == '-') {
            throw new RentaException(this.env.getString("RentaSender.ErrTIA"));
        }
        try {
            url = this.env.getURL(1, 2, renta.getModelo());
        }
        catch (FileNotFoundException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt1"));
        }
        catch (IOException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt2"), e.getMessage());
        }
        catch (Exception e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt3"), "PT_CER");
        }
        try {
            HttpHandler hh = new HttpHandler(url);
            hh.addPOSTParam("HID", "IE4" + renta.getModelo() + "0A");
            hh.addPOSTParam("CMN", "");
            hh.addPOSTParam("LOT", "0");
            hh.addPOSTParam("IDI", this.env.getIdioma().toUpperCase());
            hh.addPOSTParam("LEV", renta.isErroresLeves() ? "100000000000" : "000000000000");
            hh.addPOSTParam("F01", renta.getDeclaracion());
            hh.addPOSTParam("PUN", "00000000");
            hh.addPOSTParam("RFD", renta.getNumRefD() == null ? "" : renta.getNumRefD());
            if (renta.getModelo() == 100) {
                hh.addPOSTParam("RFC", renta.getNumRefC() == null ? "" : renta.getNumRefC());
            }
            hh.addPOSTParam("TXT", "");
            hh.addPOSTParam("FD1", "");
            if (renta.getModelo() == 100) {
                hh.addPOSTParam("FD2", "");
            }
            hh.addPOSTParam("NRC", renta.getNRC());
            hh.addPOSTParam("TIA", "" + renta.getTIA());
            hh.addPOSTParam("ING", renta.getING());
            hh.addPOSTParam("ICO", renta.getICO());
            hh.addPOSTParam("ENT", "GRABA");
            hh.addPOSTParam("FIN", "");
            HttpResponse resp = hh.doPost();
            this.env.getLog().logp(Level.INFO, this.getClass().getName(), "sendRentaByRef", hh.toString());
            this.processResponse(new PTHttpResponse(resp));
        }
        catch (MalformedURLException e) {
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-1)");
        }
        catch (UnknownHostException uhe) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "sendRentaByRef", "Error en comunicaci\u00f3n", uhe);
            throw new RentaException(this.env.getString("DFRetriever.ErrProxy"), uhe.getMessage());
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "sendRentaByRef", "Error en comunicaci\u00f3n", e);
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-2)", e.getMessage());
        }
    }

    private boolean isSet(String param) {
        return param != null && param.trim().length() > 0;
    }

    private void processResponse(PTHttpResponse resp) throws RentaException {
        this.csv = null;
        this.linkToken = null;
        this.response = resp;
        if (resp.getResponseCode() != 200) {
            throw new RentaException(this.env.getString("DFRetriever.ErrConexion"), "HTTP " + resp.getResponseCode());
        }
        if (resp.isCICSError()) {
            throw new RentaException(this.env.getString("DFRetriever.ErrResp"), "Error CICS: " + resp.getCICSError());
        }
        if (resp.isErrorLeve()) {
            this.errores = resp.getErrores();
            throw new RentaException(resp.getError(), this.env.getString("RentaSender.ErrLeve"));
        }
        if (resp.isError()) {
            this.errores = resp.getErrores();
            throw new RentaException(resp.getError());
        }
        if (!resp.isOK()) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "processResponse", resp.getContentAsText());
            throw new RentaException(this.env.getString("DFRetriever.ErrResp"), this.env.getString("DFRetriever.ErrResp2"));
        }
        this.csv = resp.getCSV();
        this.linkToken = resp.getLinkToken();
    }

    public void downloadPdfWithToken(File dest) throws RentaException {
        if (this.linkToken != null) {
            try {
                HttpHandler hh = new HttpHandler(this.linkToken);
                HttpResponse response = hh.doGet();
                if (!response.getContentTypeStr().startsWith("application/pdf")) {
                    this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "downloadPdfWithToken", response.getContentAsText());
                    throw new RentaException("No se pudo descargar el pdf", "Respuesta no es pdf");
                }
                FileOutputStream out = new FileOutputStream(dest);
                out.write(response.getContent());
                out.close();
            }
            catch (MalformedURLException e) {
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "downloadPdfWithToken", "Url mal formada", e);
                throw new RentaException("No se pudo descargar el pdf", e.getMessage());
            }
            catch (IOException e) {
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "downloadPdfWithToken", "IO exception", e);
                throw new RentaException("No se pudo descargar el pdf", e.getMessage());
            }
        }
    }

    public String getCsv() {
        return this.csv;
    }

    public String[] getErrores() {
        return this.errores;
    }

    public PTHttpResponse getResponse() {
        return this.response;
    }
}

