/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import java.text.DecimalFormat;

public class Declaracion7142014
extends Declaracion {
    private static final int[][] PARTIDAS = new int[][]{{23, 9, 257, 13, 2}, {24, 9, 270, 13, 2}, {25, 9, 283, 13, 2}, {40, 10, 153, 13, 2}};
    private DecimalFormat nf;

    protected Declaracion7142014(String declaracion) {
        super(declaracion, 2014, 714);
        this.partidas = PARTIDAS;
        this.nf = new DecimalFormat("0.00");
        this.resultado = this.getDoubleValue("11", 62, 13, 2);
        if (this.getLitComple().length() > 0) {
            this.resultado = this.getDoubleValue("11", 88, 13, 2);
        }
        this.importeNRC = 0.0;
        if (this.getLitDomi().length() == 0) {
            this.importeNRC = this.getDoubleValue("11", 88, 13, 2);
        }
        this.setTIA(null);
    }

    @Override
    public void setTIA(String tia) {
        this.TIA = (char)45;
        if (tia != null && tia.trim().length() > 0) {
            this.TIA = tia.trim().charAt(0);
        } else {
            double resultado = this.getDoubleValue("11", 62, 13, 2);
            if (resultado > 0.0) {
                this.TIA = (char)73;
            } else if (resultado == 0.0) {
                this.TIA = (char)78;
            }
            if ("3".equals(this.getStringValue("11", 101, 1))) {
                this.TIA = (char)85;
            }
        }
    }

    @Override
    public String getLitTipoPre() {
        return "";
    }

    @Override
    public String getLitTipoDe() {
        Enviroment env = Enviroment.getInstance();
        if (this.resultado > 0.0) {
            return env.getString("Declaracion.AIngresar");
        }
        if (this.resultado == 0.0) {
            return env.getString("Declaracion.Negativa");
        }
        return "";
    }

    @Override
    public String getLitDomi() {
        Enviroment env = Enviroment.getInstance();
        if ("3".equals(this.getStringValue("11", 101, 1))) {
            return " " + env.getString("Declaracion.Domicilia");
        }
        return "";
    }

    @Override
    public String getLitComple() {
        Enviroment env = Enviroment.getInstance();
        if ("1".equals(this.getStringValue("01", 687, 1))) {
            return " " + env.getString("Declaracion.Complemen");
        }
        return "";
    }

    @Override
    public String getLitResultado() {
        Enviroment env = Enviroment.getInstance();
        double resultado = this.getDoubleValue("11", 62, 13, 2);
        if (resultado > 0.0) {
            String cuenta = String.valueOf(this.getStringValue("11", 102, 4)) + " " + this.getStringValue("11", 106, 4) + " " + this.getStringValue("11", 110, 4) + " " + this.getStringValue("11", 114, 4) + " " + this.getStringValue("11", 118, 4) + " " + this.getStringValue("11", 122, 4);
            StringBuffer lit = new StringBuffer();
            String tipoPago = this.getStringValue("11", 101, 1);
            lit.append(String.valueOf(env.getString("Declaracion.Importe")) + ": <strong>" + this.nf.format(this.getDoubleValue("11", 88, 13, 2)) + "</strong>");
            if ("1".equals(tipoPago)) {
                lit.append("<br/>" + env.getString("Declaracion.NoDomici"));
            }
            if ("2".equals(tipoPago)) {
                lit.append("<br/>" + env.getString("Declaracion.Adeudo") + ": <strong>" + cuenta + "</strong>");
            }
            if ("3".equals(tipoPago)) {
                lit.append("<br/>" + env.getString("Declaracion.DomiBan") + ": <strong>" + cuenta + "</strong>");
            }
            return lit.toString().trim();
        }
        return "";
    }

    @Override
    public int getFormaPago() {
        String value = this.getStringValue("11", 101, 1);
        if ("1".equals(value)) {
            return 1;
        }
        if ("2".equals(value)) {
            return 2;
        }
        if ("3".equals(value)) {
            return 3;
        }
        return 0;
    }

    @Override
    public String getNifDeclarante() {
        return this.getStringValue("01", 10, 9).trim();
    }

    @Override
    public String getNifConyuge() {
        return "";
    }

    @Override
    public String getApellidos() {
        return this.getStringValue("01", 19, 30).trim();
    }

    @Override
    public String getApeNomDeclarante() {
        String ape1 = this.getStringValue("01", 19, 15);
        String ape2 = this.getStringValue("01", 34, 15);
        String nom = this.getStringValue("01", 49, 15);
        String apeNom = "";
        if (ape1 != null) {
            apeNom = String.valueOf(apeNom) + ape1.trim();
        }
        if (ape2 != null) {
            apeNom = String.valueOf(apeNom) + " " + ape2.trim();
        }
        if (nom != null) {
            apeNom = String.valueOf(apeNom) + ", " + nom.trim();
        }
        return apeNom;
    }

    @Override
    public String getApeNomConyuge() {
        return "";
    }

    @Override
    public boolean isConjunta() {
        return false;
    }

    @Override
    public boolean isFracciona() {
        return false;
    }

    @Override
    public boolean isNoFracciona() {
        return true;
    }

    @Override
    public String getCCC() {
        return this.getStringValue("11", 102, 34);
    }

    @Override
    public boolean validate() {
        boolean valid = this.getDeclaracion().indexOf("<T71401>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T71401>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("<T71411>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T71411>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("<T714020140A0000>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T714020140A0000>") >= 0;
        return valid;
    }

    @Override
    public boolean isDomiciliaPago2() {
        return false;
    }
}

