/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import java.text.DecimalFormat;

public class Declaracion1002013
extends Declaracion {
    private static final int[][] PARTIDAS = new int[][]{{415, 12, 661, 13, 2}, {419, 13, 62, 13, 2}, {449, 14, 49, 13, 2}, {453, 14, 101, 13, 2}, {492, 14, 551, 13, 2}, {493, 14, 564, 13, 2}, {502, 14, 681, 13, 2}, {503, 14, 694, 13, 2}, {504, 14, 707, 13, 2}, {511, 15, 36, 13, 2}, {524, 15, 192, 13, 2}, {525, 15, 205, 13, 2}, {530, 15, 244, 13, 2}, {535, 15, 335, 13, 2}, {540, 23, 10, 13, 2}};
    private DecimalFormat nf;

    public Declaracion1002013(String declaracion) {
        super(declaracion, 2013, 100);
        this.partidas = PARTIDAS;
        this.nf = new DecimalFormat("0.00");
        this.resultado = this.getDoubleValue("23", 24, 13, 2);
        if (this.resultado == 0.0) {
            this.resultado = this.getDoubleValue("23", 10, 13, 2);
        }
        this.importeNRC = 0.0;
        if (this.getLitDomi().length() == 0) {
            this.importeNRC = this.getDoubleValue("23", 39, 13, 2);
        }
        this.setTIA(null);
    }

    @Override
    public String getLitTipoPre() {
        Enviroment env = Enviroment.getInstance();
        String value = this.getStringValue("02", 1067, 1);
        if (value != null) {
            return value.equals("1") ? env.getString("Declaracion.Indiv") : env.getString("Declaracion.Conjun");
        }
        return "";
    }

    @Override
    public String getLitTipoDe() {
        Enviroment env = Enviroment.getInstance();
        if (this.resultado > 0.0) {
            return env.getString("Declaracion.AIngresar");
        }
        if (this.resultado == 0.0) {
            return env.getString("Declaracion.Negativa");
        }
        return env.getString("Declaracion.ADevolver");
    }

    @Override
    public String getLitDomi() {
        Enviroment env = Enviroment.getInstance();
        String value = this.getStringValue("23", 52, 1);
        if (value != null) {
            return value.equals("3") ? " " + env.getString("Declaracion.Domicilia") : "";
        }
        return "";
    }

    @Override
    public String getLitComple() {
        Enviroment env = Enviroment.getInstance();
        String value1 = this.getStringValue("02", 1074, 1);
        String value2 = this.getStringValue("02", 1075, 1);
        String value3 = this.getStringValue("02", 1076, 1);
        String value4 = this.getStringValue("02", 1077, 1);
        String value5 = this.getStringValue("02", 1078, 1);
        if ("1".equals(value1) || "1".equals(value2) || "1".equals(value3) || "1".equals(value4) || "1".equals(value5)) {
            return " " + env.getString("Declaracion.Complemen");
        }
        return "";
    }

    @Override
    public String getLitResultado() {
        Enviroment env = Enviroment.getInstance();
        StringBuffer lit = new StringBuffer();
        String cuenta = String.valueOf(this.getStringValue("23", 82, 4)) + " " + this.getStringValue("23", 86, 4) + " " + this.getStringValue("23", 90, 4) + " " + this.getStringValue("23", 94, 4) + " " + this.getStringValue("23", 98, 4) + " " + this.getStringValue("23", 102, 4);
        if (this.resultado > 0.0) {
            String tipoPago = this.getStringValue("23", 52, 1);
            double ingreso1 = this.getDoubleValue("23", 39, 13, 2);
            double ingreso2 = this.getDoubleValue("23", 24, 13, 2);
            if (ingreso2 == 0.0) {
                ingreso2 = this.getDoubleValue("23", 10, 13, 2);
            }
            ingreso2 -= this.getDoubleValue("23", 39, 13, 2);
            if ("1".equals(this.getStringValue("23", 38, 1))) {
                lit.append(String.valueOf(env.getString("Declaracion.Importe")) + ": <strong>" + this.nf.format(this.getDoubleValue("23", 10, 13, 2)) + "</strong>");
                lit.append("<br/>" + env.getString("Declaracion.Fracciona"));
                lit.append("<br/>" + env.getString("Declaracion.Plazo1") + ": <strong>" + this.nf.format(ingreso1) + "</strong>");
                if ("1".equals(tipoPago)) {
                    lit.append(" - " + env.getString("Declaracion.NoDomici"));
                }
                if ("2".equals(tipoPago)) {
                    lit.append(" - " + env.getString("Declaracion.Adeudo") + ": <strong>" + cuenta + "</strong>");
                }
                if ("3".equals(tipoPago)) {
                    lit.append(" - " + env.getString("Declaracion.DomiBan") + ": <strong>" + cuenta + "</strong>");
                }
                lit.append("<br/>" + env.getString("Declaracion.Plazo2") + ": <strong>" + this.nf.format(ingreso2) + "</strong>");
                if ("1".equals(this.getStringValue("23", 54, 1))) {
                    lit.append(" - " + env.getString("Declaracion.DomiBan") + ": <strong>" + cuenta + "</strong>");
                }
                if ("1".equals(this.getStringValue("23", 53, 1))) {
                    lit.append(" - " + env.getString("Declaracion.NoDomici"));
                }
            } else {
                lit.append(String.valueOf(env.getString("Declaracion.Importe")) + ": <strong>" + this.nf.format(ingreso1) + "</strong>");
                if ("1".equals(tipoPago)) {
                    lit.append("<br/>" + env.getString("Declaracion.NoDomici"));
                }
                if ("2".equals(tipoPago)) {
                    lit.append("<br/>" + env.getString("Declaracion.Adeudo") + ": <strong>" + cuenta + "</strong>");
                }
                if ("3".equals(tipoPago)) {
                    lit.append("<br/>" + env.getString("Declaracion.DomiBan") + ": <strong>" + cuenta + "</strong>");
                }
            }
        } else if (this.resultado != 0.0) {
            String tipoDevo = this.getStringValue("23", 68, 1);
            lit.append(String.valueOf(env.getString("Declaracion.Importe")) + ": <strong>" + this.nf.format(this.getDoubleValue("23", 69, 13, 2)) + "</strong><br/>");
            if ("0".equals(tipoDevo)) {
                lit.append(env.getString("Declaracion.NoConsta"));
            }
            if ("1".equals(tipoDevo)) {
                lit.append(String.valueOf(env.getString("Declaracion.CuentaDev")) + ": <strong>" + cuenta + "</strong>");
            }
            if ("2".equals(tipoDevo)) {
                lit.append(env.getString("Declaracion.RenunDevo"));
            }
        }
        return lit.toString();
    }

    @Override
    public int getFormaPago() {
        String value = this.getStringValue("23", 52, 1);
        if ("1".equals(value)) {
            return 1;
        }
        if ("2".equals(value)) {
            return 2;
        }
        if ("3".equals(value)) {
            return 3;
        }
        return 0;
    }

    @Override
    public String getNifDeclarante() {
        return this.getStringValue("01", 10, 9).trim();
    }

    @Override
    public String getApellidos() {
        return this.getStringValue("01", 19, 30).trim();
    }

    @Override
    public boolean isFracciona() {
        return "1".equals(this.getStringValue("23", 38, 1));
    }

    @Override
    public boolean isNoFracciona() {
        return "1".equals(this.getStringValue("23", 37, 1));
    }

    @Override
    public String getCCC() {
        return this.getStringValue("23", 82, 34);
    }

    @Override
    public boolean isDomiciliaPago2() {
        return "1".equals(this.getStringValue("23", 54, 1));
    }

    @Override
    public void setTIA(String tia) {
        this.TIA = (char)45;
        if (tia != null && tia.trim().length() > 0) {
            this.TIA = tia.trim().charAt(0);
        } else {
            this.TIA = this.resultado > 0.0 ? (char)73 : (this.resultado == 0.0 ? (char)78 : ("2".equals(this.getStringValue("23", 68, 1)) ? (char)82 : (char)68));
            if ("3".equals(this.getStringValue("23", 52, 1))) {
                this.TIA = (char)85;
            }
        }
    }

    @Override
    public String getNifConyuge() {
        String nifC = this.getStringValue("01", 943, 9);
        if (nifC != null) {
            nifC = nifC.trim();
        }
        return nifC;
    }

    @Override
    public boolean isConjunta() {
        String nifC = this.getNifConyuge();
        if (nifC == null) {
            nifC = "";
        }
        return "2".equals(this.getStringValue("02", 1067, 1)) && nifC.length() > 0;
    }

    @Override
    public String getApeNomDeclarante() {
        String ape1 = this.getStringValue("01", 19, 15);
        String ape2 = this.getStringValue("01", 34, 15);
        String nom = this.getStringValue("01", 49, 15);
        String apeNom = "";
        if (ape1 != null) {
            apeNom = String.valueOf(apeNom) + ape1.trim();
        }
        if (ape2 != null) {
            apeNom = String.valueOf(apeNom) + " " + ape2.trim();
        }
        if (nom != null) {
            apeNom = String.valueOf(apeNom) + ", " + nom.trim();
        }
        return apeNom;
    }

    @Override
    public String getApeNomConyuge() {
        String ape1 = this.getStringValue("01", 952, 15);
        String ape2 = this.getStringValue("01", 967, 15);
        String nom = this.getStringValue("01", 982, 15);
        String apeNom = "";
        if (ape1 != null) {
            apeNom = String.valueOf(apeNom) + ape1.trim();
        }
        if (ape2 != null) {
            apeNom = String.valueOf(apeNom) + " " + ape2.trim();
        }
        if (nom != null) {
            apeNom = String.valueOf(apeNom) + ", " + nom.trim();
        }
        return apeNom;
    }

    @Override
    public boolean validate() {
        boolean valid = this.getDeclaracion().indexOf("<T10001>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T10001>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("<T10023>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T10023>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("<T10002>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T10002>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("<T100020130A0000>") >= 0;
        valid = valid && this.getDeclaracion().indexOf("</T100020130A0000>") >= 0;
        return valid;
    }
}

