/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.pt.Declaracion1002013;
import es.gob.aeat.dit.ov.renta.pt.Declaracion1002014;
import es.gob.aeat.dit.ov.renta.pt.Declaracion7142013;
import es.gob.aeat.dit.ov.renta.pt.Declaracion7142014;
import es.gob.aeat.dit.ov.renta.signature.OVSignature;
import java.util.logging.Level;

public abstract class Declaracion {
    public static final int RENTA = 100;
    public static final int PATRIMONIO = 714;
    public static final int FORMA_PAGO_NO_CONSTA = 0;
    public static final int FORMA_PAGO_EFECTIVO = 1;
    public static final int FORMA_PAGO_ADEUDO = 2;
    public static final int FORMA_PAGO_DOMICILIACION = 3;
    private static final String VECTOR_END = "</VECTOR>";
    private static final String AUX_END = "</AUX>";
    private static final String CABEZON_END_START = "</T";
    private static final String CABEZON_END_END = "0A0000>";
    protected int[][] partidas = null;
    protected int ejercicio;
    private int signatureType;
    private String declaracion;
    private String fichero;
    private OVSignature[] signatures;
    private String[] numRefs;
    private boolean erroresLeves;
    private int modelo;
    protected char TIA;
    protected double resultado;
    protected double importeNRC;
    private String ICO;
    private String ING;
    private String NRC;

    public int getModelo() {
        return this.modelo;
    }

    public boolean isErroresLeves() {
        return this.erroresLeves;
    }

    public void setErroresLeves(boolean erroresLeves) {
        this.erroresLeves = erroresLeves;
    }

    public static Declaracion getDeclaraci\u00f3n(String declaracion, int ejercicio, int modelo) {
        if (ejercicio == 2013) {
            switch (modelo) {
                case 100: {
                    return new Declaracion1002013(declaracion);
                }
                case 714: {
                    return new Declaracion7142013(declaracion);
                }
            }
        } else if (ejercicio == 2014) {
            switch (modelo) {
                case 100: {
                    return new Declaracion1002014(declaracion);
                }
                case 714: {
                    return new Declaracion7142014(declaracion);
                }
            }
        }
        return null;
    }

    protected Declaracion(String declaracion, int ejercicio, int modelo) {
        this.modelo = modelo;
        this.ejercicio = ejercicio;
        this.NRC = "";
        this.declaracion = declaracion;
        this.TIA = (char)45;
        this.fichero = this.removeVector();
        this.signatures = new OVSignature[2];
        this.numRefs = new String[2];
        this.erroresLeves = false;
    }

    public abstract void setTIA(String var1);

    private String removeVector() {
        String inicio = VECTOR_END;
        int ficStart = this.declaracion.indexOf(inicio);
        if (ficStart < 0) {
            inicio = AUX_END;
            ficStart = this.declaracion.indexOf(inicio);
        }
        int ficEnd = this.declaracion.indexOf(CABEZON_END_START + this.modelo + "0" + this.ejercicio + CABEZON_END_END);
        if (ficStart > 0 && ficEnd > ficStart) {
            return this.declaracion.substring(ficStart + inicio.length(), ficEnd).trim();
        }
        return this.declaracion;
    }

    public boolean needNRC() {
        return this.TIA == 'I';
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(int signatureType) {
        this.signatureType = signatureType;
    }

    public String getNRC() {
        return this.NRC;
    }

    public void setNRC(String NRC) {
        this.NRC = NRC != null ? NRC : "";
    }

    public OVSignature getSignatureD() {
        return this.signatures[0];
    }

    public OVSignature getSignatureC() {
        return this.signatures[1];
    }

    public void setSignatureD(OVSignature sig) {
        this.signatures[0] = sig;
    }

    public void setSignatureC(OVSignature sig) {
        this.signatures[1] = sig;
    }

    public String getNumRefD() {
        return this.numRefs[0];
    }

    public String getNumRefC() {
        return this.numRefs[1];
    }

    public void setNumRefD(String numRef) {
        this.numRefs[0] = numRef.trim().length() <= 0 ? null : numRef.trim();
    }

    public void setNumRefC(String numRef) {
        this.numRefs[1] = numRef.trim().length() <= 0 ? null : numRef.trim();
    }

    public char getTIA() {
        return this.TIA;
    }

    public String getDeclaracion() {
        return this.declaracion;
    }

    public String getFichero() {
        return this.fichero;
    }

    public String getAnagrama() {
        String nif = this.getNifDeclarante();
        String letras = this.filtraLetras(this.getApellidos()).toUpperCase();
        String PesoCaracter = " ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ";
        String[] controlNif = new String[]{"T", "R", "W", "A", "G", "M", "Y", "F", "P", "D", "X", "B", "N", "J", "Z", "S", "Q", "V", "H", "L", "C", "K", "E"};
        char[] LetrasExp = new char[]{'Y', 'Z', 'X', 'K', 'L', 'M'};
        int N = 0;
        String DigCtl = "";
        char PriPos = nif.charAt(0);
        int peso = 1;
        int idc = 0;
        while (idc < 4) {
            if (PriPos == LetrasExp[idc]) {
                DigCtl = "" + PriPos;
            }
            ++idc;
        }
        if (DigCtl.length() == 0) {
            DigCtl = " ";
        }
        DigCtl = String.valueOf(DigCtl) + letras;
        idc = 3;
        while (idc >= 0) {
            N += PesoCaracter.indexOf("" + DigCtl.charAt(idc)) * (int)Math.pow(10.0, 2 * (peso - 1));
            ++peso;
            --idc;
        }
        N = DigCtl.charAt(0) != ' ' ? (N += Integer.parseInt(nif.substring(1, 8))) : (N += Integer.parseInt(nif.substring(0, 8)));
        return String.valueOf(letras) + controlNif[N %= 23];
    }

    private String filtraLetras(String cade) {
        String letras = "";
        String[] tab = cade.split(" ");
        int i = 0;
        while (i < tab.length) {
            if (!(tab[i].toLowerCase().equals("de") || tab[i].toLowerCase().equals("la") || tab[i].toLowerCase().equals("del") || tab[i].toLowerCase().equals("las") || tab[i].toLowerCase().equals("los") || tab[i].toLowerCase().equals("ltda") || tab[i].toLowerCase().equals("cia") || tab[i].toLowerCase().equals("sdad") || tab[i].toLowerCase().equals("hnos") || tab[i].toLowerCase().equals("limitada") || tab[i].toLowerCase().equals("anonima") || tab[i].toLowerCase().equals("compa\u00f1ia") || tab[i].toLowerCase().equals("asoc") || tab[i].toLowerCase().equals("cb") || tab[i].toLowerCase().equals("src") || tab[i].toLowerCase().equals("al") || tab[i].toLowerCase().equals("cdad") || tab[i].toLowerCase().equals("asociacion") || tab[i].toLowerCase().equals("cooperativa") || tab[i].toLowerCase().equals("bienes") || tab[i].toLowerCase().equals("comunidad") || tab[i].toLowerCase().equals("propietarios") || tab[i].toLowerCase().equals("scl") || tab[i].toLowerCase().equals("sc") || tab[i].toLowerCase().equals("sae") || tab[i].toLowerCase().equals("coop") || tab[i].toLowerCase().equals("sat") || tab[i].toLowerCase().equals("soc") || tab[i].toLowerCase().equals("sl") || tab[i].toLowerCase().equals("sa") || tab[i].toLowerCase().equals("i"))) {
                while (tab[i].length() < 3) {
                    int n = i;
                    tab[n] = String.valueOf(tab[n]) + ' ';
                }
                letras = tab[i].substring(0, 3).toUpperCase();
                return letras;
            }
            ++i;
        }
        return letras;
    }

    public String getStringValue(String page, int position, int length) {
        String startPage = "<T" + this.modelo + page + ">";
        int ini = this.declaracion.indexOf(startPage);
        if (ini > 0 && (ini += position - 1) + length < this.declaracion.length()) {
            return this.declaracion.substring(ini, ini + length);
        }
        Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getStringValue", "No se encontro el valor: " + page + ", " + position + ", " + length);
        return null;
    }

    public double getDoubleValue(String page, int position, int length, int numDecimals) {
        double val = 0.0;
        String startPage = "<T" + this.modelo + page + ">";
        int ini = this.declaracion.indexOf(startPage);
        if (ini > 0 && (ini += position - 1) + length < this.declaracion.length()) {
            String value = this.declaracion.substring(ini, ini + length);
            if ((value = String.valueOf(value.substring(0, value.length() - numDecimals)) + "." + value.substring(value.length() - numDecimals)).startsWith("N")) {
                value = "-" + value.substring(1);
            }
            try {
                val = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getDoubleValue", "No es decimal (" + value + "): " + page + ", " + position + ", " + length + ", " + numDecimals);
            }
            return val;
        }
        Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "getDoubleValue", "No se encontro el valor decimal: " + page + ", " + position + ", " + length + ", " + numDecimals);
        return 0.0;
    }

    public String getResultadoTxt() {
        StringBuffer resultado = new StringBuffer();
        resultado.append(this.getLitTipoPre());
        resultado.append(" ");
        resultado.append(this.getLitTipoDe());
        resultado.append(this.getLitDomi());
        resultado.append(this.getLitComple());
        resultado.append(". ");
        resultado.append(this.getLitResultado());
        return resultado.toString().trim();
    }

    public String getHID(boolean intranet) {
        return String.valueOf(intranet ? "L" : "I") + "E" + this.ejercicio % 10 + this.modelo + "0A";
    }

    public abstract String getLitTipoPre();

    public abstract String getLitTipoDe();

    public abstract String getLitDomi();

    public abstract String getLitComple();

    public abstract String getLitResultado();

    public double getValuePartida(int numPartida) {
        if (this.partidas != null) {
            int index = -1;
            int i = 0;
            while (i < this.partidas.length && index == -1) {
                if (this.partidas[i][0] == numPartida) {
                    index = i;
                }
                ++i;
            }
            if (index >= 0) {
                String pagina = "" + this.partidas[index][1];
                if (pagina.length() == 1) {
                    pagina = "0" + pagina;
                }
                return this.getDoubleValue(pagina, this.partidas[index][2], this.partidas[index][3], this.partidas[index][4]);
            }
        }
        return 0.0;
    }

    public abstract int getFormaPago();

    public abstract String getNifDeclarante();

    public abstract String getNifConyuge();

    public abstract String getApellidos();

    public abstract String getApeNomDeclarante();

    public abstract String getApeNomConyuge();

    public abstract boolean isConjunta();

    public abstract boolean isFracciona();

    public abstract boolean isNoFracciona();

    public abstract String getCCC();

    public abstract boolean validate();

    public abstract boolean isDomiciliaPago2();

    public double getImporteNRC() {
        return this.importeNRC;
    }

    public double getImporteResultado() {
        return this.resultado;
    }

    public String getICO() {
        return this.ICO;
    }

    public void setICO(String ICO) {
        this.ICO = ICO != null ? ICO : "";
    }

    public String getING() {
        return this.ING;
    }

    public void setING(String ING) {
        this.ING = ING != null ? ING : "";
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + "        NIF: " + this.getNifDeclarante();
        str = String.valueOf(str) + "\n  Apellidos: " + this.getApellidos();
        str = String.valueOf(str) + "\n   Anagrama: " + this.getAnagrama();
        str = String.valueOf(str) + "\n   Conjunta: " + this.isConjunta();
        str = String.valueOf(str) + "\n      Leves: " + this.isErroresLeves();
        str = String.valueOf(str) + "\n  Resultado: " + this.resultado;
        str = String.valueOf(str) + "\nImporte NRC: " + this.importeNRC;
        str = String.valueOf(str) + "\n        TIA: " + this.TIA;
        str = String.valueOf(str) + "\n        NRC: " + this.NRC;
        str = String.valueOf(str) + "\n        ICO: " + this.ICO;
        str = String.valueOf(str) + "\n        ING: " + this.ING;
        return str;
    }
}

