/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.http;

import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import java.util.ArrayList;

public class PTHttpResponse
extends HttpResponse {
    private static final String LINK_TOKEN_INI = "var urlPdf = \"";
    private static final String LINK_TOKEN_MID = "\"+\"";
    private static final String LINK_TOKEN_END = "\";";
    private static final String RESP_LEVES = "<PEL>1</PEL>";
    private static final String ERROR_STR_START = "<E00>";
    private static final String ERROR_STR_END = "</E00>";
    private static final String CSV_STR_START = "<CEL>";
    private static final String CSV_STR_END = "</CEL>";
    private static final String NDC_STR_START = "<NDC>";
    private static final String NDC_STR_END = "</NDC>";
    public static final String DUPLICADA = "DUPLI";
    private static final int NUM_ERRORES = 100;

    public PTHttpResponse(HttpResponse resp) {
        super(resp);
    }

    public boolean isError() {
        String str = this.getContentAsText();
        int indIni = str.indexOf(ERROR_STR_START);
        int indFin = str.indexOf(ERROR_STR_END);
        int indLeves = str.indexOf(RESP_LEVES);
        return indIni > 0 && indFin > indIni && indLeves < 0;
    }

    public String getError() {
        String str = this.getContentAsText();
        int errStart = str.indexOf(ERROR_STR_START);
        if (errStart > 0) {
            int errEnd = str.indexOf(ERROR_STR_END);
            if (errEnd > errStart) {
                return str.substring(errStart + ERROR_STR_START.length(), errEnd).trim();
            }
            return str.substring(errStart + ERROR_STR_START.length()).trim();
        }
        return "NOERRORPAGE";
    }

    public String[] getErrores() {
        String str = this.getContentAsText();
        ArrayList<String> errores = new ArrayList<String>();
        int i = 0;
        while (i < 100) {
            String error;
            String tagIni = "<E" + (i < 10 ? "0" : "") + i + ">";
            String tagFin = "</E" + (i < 10 ? "0" : "") + i + ">";
            int posIni = str.indexOf(tagIni);
            int posFin = str.indexOf(tagFin);
            if (posIni >= 0 && posFin + tagIni.length() > posIni && (error = str.substring(posIni + tagIni.length(), posFin).trim()).length() > 0) {
                errores.add(error);
            }
            ++i;
        }
        if (errores.size() == 0) {
            return null;
        }
        String[] errs = new String[errores.size()];
        int i2 = 0;
        while (i2 < errs.length) {
            errs[i2] = (String)errores.get(i2);
            ++i2;
        }
        return errs;
    }

    public boolean isErrorLeve() {
        String str = this.getContentAsText();
        return str.indexOf(RESP_LEVES) > 0;
    }

    public boolean isOK() {
        String str = this.getContentAsText();
        return str.indexOf(CSV_STR_START) >= 0;
    }

    public String getCSV() {
        String str = this.getContentAsText();
        int csvStart = str.indexOf(CSV_STR_START);
        int csvEnd = str.indexOf(CSV_STR_END);
        if (csvStart > 0 && csvEnd > csvStart) {
            return str.substring(csvStart + CSV_STR_START.length(), csvEnd).trim();
        }
        return null;
    }

    public String getNDC() {
        String str = this.getContentAsText();
        int ndcStart = str.indexOf(NDC_STR_START);
        int ndcEnd = str.indexOf(NDC_STR_END);
        if (ndcStart > 0 && ndcEnd > ndcStart) {
            return str.substring(ndcStart + NDC_STR_START.length(), ndcEnd).trim();
        }
        return null;
    }

    public String getVariable(String var) {
        String tagIni = "<" + var + ">";
        String tagFin = "</" + var + ">";
        String str = this.getContentAsText();
        int ini = str.indexOf(tagIni);
        int fin = str.indexOf(tagFin);
        if (ini > 0 && fin > ini + tagIni.length()) {
            return str.substring(ini + tagIni.length(), fin).trim();
        }
        return "";
    }

    public boolean isYaPresentada() {
        String yap = this.getVariable("YAP");
        return DUPLICADA.equals(yap);
    }

    public String getLinkToken() {
        int tokEnd;
        int tokMid;
        String str;
        int tokIni;
        String link = null;
        if ("1".equals(this.getVariable("PDF")) && (tokIni = (str = this.getContentAsText()).indexOf(LINK_TOKEN_INI)) > 0 && (tokMid = str.indexOf(LINK_TOKEN_MID, tokIni += LINK_TOKEN_INI.length())) > tokIni && (tokEnd = str.indexOf(LINK_TOKEN_END, tokMid + LINK_TOKEN_MID.length())) > tokMid) {
            link = str.substring(tokIni, tokMid);
            link = String.valueOf(link) + str.substring(tokMid + LINK_TOKEN_MID.length(), tokEnd);
        }
        return link;
    }
}

