/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.http;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.http.AuthPIN24HResponse;
import es.gob.aeat.dit.ov.renta.http.HttpHandler;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.logging.Level;

public class PIN24HAuthenticator {
    private String error;

    public boolean authenticate(String nif, String clave, String pin) {
        Enviroment env = Enviroment.getInstance();
        boolean authenticated = false;
        try {
            MessageDigest md = MessageDigest.getInstance("sha-512");
            byte[] digest = md.digest(clave.getBytes());
            String digestStr = Util.toHexString(digest);
            HttpHandler hh = new HttpHandler(env.getURL(2));
            hh.addPOSTParam("NIF", nif.toUpperCase());
            hh.addPOSTParam("APE", "");
            hh.addPOSTParam("CLV", digestStr);
            hh.addPOSTParam("PIN", pin.toUpperCase());
            hh.addPOSTParam("TMV", "");
            hh.addPOSTParam("REF", env.getURL(0, 1, 714));
            hh.addPOSTParam("FROM", "");
            hh.addPOSTParam("BFPRINT", "141014");
            hh.addPOSTParam("STORKSP", "");
            hh.addPOSTParam("QAA", "2");
            HttpResponse resp = hh.doPost();
            AuthPIN24HResponse apr = new AuthPIN24HResponse(resp);
            if (apr.isCICSError()) {
                this.error = apr.getCICSError();
            } else if (apr.isError()) {
                this.error = apr.getError();
            } else if (apr.isOK()) {
                this.error = null;
                authenticated = true;
            } else {
                Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "authenticate", "Respuesta no esperada", apr.getContentAsText());
                this.error = String.valueOf(env.getString("DFRetriever.ErrResp")) + " (" + env.getString("DFRetriever.ErrResp2") + ")";
            }
        }
        catch (UnknownHostException uhe) {
            this.error = env.getString("DFRetriever.ErrProxy");
            env.getLog().logp(Level.SEVERE, this.getClass().getName(), "authenticate", "Error en comunicaci\u00f3n", uhe);
        }
        catch (Exception e) {
            this.error = e.getMessage();
            env.getLog().logp(Level.SEVERE, this.getClass().getName(), "authenticate", "Error en comunicaci\u00f3n", e);
        }
        return authenticated;
    }

    public String getError() {
        return this.error;
    }
}

