/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.http;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.http.AuthIntranetResponse;
import es.gob.aeat.dit.ov.renta.http.HttpHandler;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import es.gob.aeat.dit.ov.renta.http.MotivoDialog;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import java.util.logging.Level;
import javax.swing.JDialog;

public class IntranetAuthenticator {
    public static final int MAX_LENGTH_MOTIVO = 20;
    public static final String COOKIE_MOTIVO = "MOTIVO";
    public static final String COOKIE_ID = "idSesionDomino";
    private String error;

    public boolean authenticate(String alias, JDialog owner) {
        Enviroment env = Enviroment.getInstance();
        boolean authenticated = false;
        try {
            String motivoStr;
            if (alias != null) {
                RentaKeyManager.getInstance().setAliasSSL(alias);
            }
            if (env.getMotivo() == null) {
                MotivoDialog md = new MotivoDialog(owner);
                md.showDialog();
                env.setMotivo(md.getMotivo());
            }
            if ((motivoStr = env.getMotivo()).length() > 20) {
                motivoStr = motivoStr.substring(0, 20).trim();
            }
            HttpHandler hh = new HttpHandler(env.getURL(11));
            String motivoEncoded = hh.addPOSTParam("motiv", motivoStr);
            hh.addPOSTParam("ShortName", "&CAMPO3;");
            Enviroment.getInstance().getLog().logp(Level.INFO, this.getClass().getName(), "authenticate", hh.toString());
            HttpResponse resp = hh.doPost();
            AuthIntranetResponse air = new AuthIntranetResponse(resp);
            String cookie = air.getCookieIntranet();
            if (cookie == null) {
                hh.setCookieIntranet(null);
                Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "authenticate", "Respuesta no esperada:\n" + resp.getContentAsText());
                this.error = String.valueOf(env.getString("DFRetriever.ErrResp")) + " (" + env.getString("DFRetriever.ErrResp3") + ")";
                authenticated = false;
            } else {
                cookie = "MOTIVO=" + motivoEncoded + "; " + COOKIE_ID + "=" + cookie;
                Enviroment.getInstance().getLog().logp(Level.INFO, this.getClass().getName(), "authenticate", "Cookie de intranet obtenida: " + cookie);
                hh.setCookieIntranet(cookie);
                authenticated = true;
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "authenticate", "Error en comunicaci\u00f3n", e);
        }
        return authenticated;
    }

    public String getError() {
        return this.error;
    }
}

