/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.http;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class HttpResponse {
    private static final String ERROR_10_CICS_START = "CODIGO_ERROR_10:</TD><TD><B>";
    private static final String ERROR_10_CICS_END = "</B>";
    private static final String ERROR_10_CICS_START_INTRANET = "CODIGO_ERROR_10:</td><td width=\"121\"><b>";
    private static final String ERROR_10_CICS_END_INTRANET = "</b>";
    private static final String ERROR_CWS = "<title>AEAT-Error en CWS</title>";
    private static final String ERROR_CWS_START = "<li>";
    private static final String ERROR_CWS_END = "</li>";
    public static final int TEXT = 0;
    public static final int BINARY = 1;
    private int responseCode;
    private int contentType;
    private String charset;
    private String contentTypeStr;
    private byte[] content;

    public HttpResponse(HttpResponse resp) {
        this.responseCode = resp.responseCode;
        this.content = resp.content;
        this.charset = resp.charset;
        this.contentType = resp.contentType;
        this.contentTypeStr = resp.contentTypeStr;
    }

    public HttpResponse(int responseCode, String contentType, byte[] content) {
        this.responseCode = responseCode;
        this.content = content;
        this.charset = "UTF-8";
        this.contentType = 0;
        this.contentTypeStr = null;
        if (contentType != null) {
            String ct;
            String cs = null;
            this.contentTypeStr = ct = contentType.toLowerCase();
            String[] parts = ct.split(";");
            int i = 0;
            while (i < parts.length) {
                Properties props = new Properties();
                try {
                    props.load(new StringReader(parts[i]));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (props.containsKey("charset")) {
                    cs = (String)props.get("charset");
                }
                ++i;
            }
            if (cs != null) {
                this.charset = cs;
            }
            this.contentType = ct.trim().startsWith("text/") ? 0 : 1;
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public int getContentType() {
        return this.contentType;
    }

    public String getContentTypeStr() {
        return this.contentTypeStr;
    }

    public String getCharset() {
        return this.charset;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsText() {
        String text = null;
        try {
            text = new String(this.content, this.charset);
        }
        catch (Exception e) {
            text = new String(this.content);
        }
        return text;
    }

    public boolean isCICSError() {
        String str = this.getContentAsText();
        return str.indexOf(ERROR_10_CICS_START) >= 0 || str.indexOf(ERROR_CWS) >= 0 || str.indexOf(ERROR_10_CICS_START_INTRANET) >= 0;
    }

    public String getCICSError() {
        String str = this.getContentAsText();
        int errCicsStart = str.indexOf(ERROR_10_CICS_START);
        int errCicsStartIntranet = str.indexOf(ERROR_10_CICS_START_INTRANET);
        int errCWS = str.indexOf(ERROR_CWS);
        if (errCicsStart > 0 || errCicsStartIntranet > 0) {
            int errCicsEnd = str.indexOf(ERROR_10_CICS_END, errCicsStart);
            int errCicsEndIntranet = str.indexOf(ERROR_10_CICS_END_INTRANET, errCicsStartIntranet);
            if (errCicsEnd > errCicsStart && errCicsStart > 0) {
                return str.substring(errCicsStart + ERROR_10_CICS_START.length(), errCicsEnd).trim();
            }
            if (errCicsEndIntranet > errCicsStartIntranet && errCicsStartIntranet > 0) {
                return str.substring(errCicsStartIntranet + ERROR_10_CICS_START_INTRANET.length(), errCicsEndIntranet).trim();
            }
            return "Cics error not found";
        }
        if (errCWS > 0) {
            int errCWSStart = str.indexOf(ERROR_CWS_START);
            int errCWSEnd = str.indexOf(ERROR_CWS_END);
            if (errCWSStart >= 0 && errCWSEnd > errCWSStart) {
                return str.substring(errCWSStart + ERROR_CWS_START.length(), errCWSEnd).trim();
            }
            return "CWS error not found";
        }
        return "NOCICSERROR";
    }

    public String toString() {
        String out = "Response Code: " + this.responseCode + "\n";
        out = String.valueOf(out) + "Content Type: " + (this.contentType == 0 ? "Text" : "Binary") + "\n";
        out = String.valueOf(out) + "Charset: " + this.charset + "\n";
        if (this.contentType == 0) {
            out = String.valueOf(out) + "\n" + this.getContentAsText();
        }
        return out;
    }
}

