/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.http;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpHandler {
    private static final int BUFFER_SIZE = 32768;
    private static final String COOKIE_PIN24H_START_H = "pin24H=";
    private static final String COOKIE_PIN24H_START_V = "pin24V=";
    private static final String COOKIE_DOMAIN_START = "domain=";
    private static Hashtable<String, String> COOKIES_PIN24H = new Hashtable();
    private static Hashtable<String, String> COOKIES_INTRANET = new Hashtable();
    private URL url;
    private Hashtable<String, String> postParams;
    private ArrayList<String> postParamsOrder;
    private Hashtable<String, String> requestProperties;
    private SSLSocketFactory sslsf;

    public HttpHandler(String urlStr) throws MalformedURLException {
        this.url = new URL(urlStr);
        if (!this.url.getProtocol().startsWith("http")) {
            throw new MalformedURLException("La url no es http");
        }
        this.postParams = new Hashtable();
        this.postParamsOrder = new ArrayList();
        this.requestProperties = new Hashtable();
    }

    public void setSSLSocketFactory(SSLSocketFactory sslsf) {
        this.sslsf = sslsf;
    }

    public String addPOSTParam(String key, String value) {
        String _key = key.trim();
        String _value = null;
        if (_key.length() > 0) {
            _value = Enviroment.urlEncode(value);
            this.postParams.put(_key, _value);
            if (!this.postParamsOrder.contains(_key)) {
                this.postParamsOrder.add(_key);
            }
        }
        return _value;
    }

    private String getPostParamsString() {
        String params = "";
        for (String key : this.postParamsOrder) {
            if (!params.isEmpty()) {
                params = String.valueOf(params) + "&";
            }
            params = String.valueOf(params) + key + "=" + this.postParams.get(key);
        }
        return params;
    }

    public void addRequestProperty(String key, String value) {
        if (key != null && value != null) {
            String _key = key.trim();
            String _value = value.trim();
            if (_key.length() > 0 && _value.length() > 0) {
                this.requestProperties.put(_key, _value);
            }
        }
    }

    public HttpResponse doPost() throws IOException {
        return this.send("POST", null);
    }

    public HttpResponse doPost(byte[] datos) throws IOException {
        return this.send("POST", datos);
    }

    public HttpResponse doGet() throws IOException {
        return this.send("GET", null);
    }

    private HttpResponse send(String method, byte[] datos) throws IOException {
        HttpURLConnection httpConnection = null;
        URLConnection connection = this.url.openConnection();
        if (method.equals("POST")) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        Enumeration<String> properties = this.requestProperties.keys();
        while (properties.hasMoreElements()) {
            String prop = properties.nextElement();
            connection.setRequestProperty(prop, this.requestProperties.get(prop));
        }
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(true);
        connection.setRequestProperty("connection", "close");
        this.putCookiePIN24H(connection);
        this.putCookieIntranet(connection);
        if (!(connection instanceof HttpURLConnection)) {
            throw new MalformedURLException("La url no es http");
        }
        httpConnection = (HttpURLConnection)connection;
        httpConnection.setRequestMethod(method);
        if (connection instanceof HttpsURLConnection) {
            SSLSocketFactory mySslsf = null;
            mySslsf = this.sslsf == null ? RentaKeyManager.getInstance().getSocketFactory() : this.sslsf;
            if (mySslsf != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(mySslsf);
            }
        }
        if (method.equals("POST")) {
            OutputStream out = connection.getOutputStream();
            if (datos == null) {
                out.write(this.getPostParamsString().getBytes());
            } else {
                out.write(datos);
            }
            out.flush();
            out.close();
        } else {
            connection.connect();
        }
        int responseCode = httpConnection.getResponseCode();
        String contentType = httpConnection.getContentType();
        this.processCookiePIN24H(httpConnection);
        byte[] content = null;
        InputStream in = null;
        try {
            in = connection.getInputStream();
        }
        catch (Exception e) {
            in = httpConnection.getErrorStream();
        }
        if (in == null) {
            throw new IOException("Contenido de " + this.url + " nulo (????)");
        }
        content = this.fullRead(in);
        in.close();
        if (httpConnection != null) {
            httpConnection.disconnect();
        }
        return new HttpResponse(responseCode, contentType, content);
    }

    private byte[] fullRead(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] data = new byte[32768];
        int leidos = 1;
        while (leidos >= 0) {
            leidos = in.read(data);
            if (leidos <= 0) continue;
            bout.write(data, 0, leidos);
        }
        bout.close();
        return bout.toByteArray();
    }

    private void processCookiePIN24H(URLConnection con) {
        Map<String, List<String>> headers = con.getHeaderFields();
        List<String> cookies = headers.get("Set-Cookie");
        if (cookies != null) {
            String cookiePin24V = null;
            String cookiePin24H = null;
            String domain = null;
            int i = 0;
            while (i < cookies.size()) {
                if ((cookies.get(i).startsWith(COOKIE_PIN24H_START_V) || cookies.get(i).startsWith(COOKIE_PIN24H_START_H)) && cookies.get(i).toLowerCase().indexOf(COOKIE_DOMAIN_START) >= 0) {
                    int start = 0;
                    int end = cookies.get(i).indexOf(";", start);
                    if (end > start) {
                        String cookie = cookies.get(i).substring(start, end);
                        start = cookies.get(i).toLowerCase().indexOf(COOKIE_DOMAIN_START) + COOKIE_DOMAIN_START.length();
                        end = cookies.get(i).indexOf(";", start);
                        if (cookies.get(i).startsWith(COOKIE_PIN24H_START_V)) {
                            cookiePin24V = cookie;
                        } else {
                            cookiePin24H = cookie;
                        }
                        if (end > start) {
                            domain = cookies.get(i).substring(start, end);
                        }
                    }
                }
                ++i;
            }
            if (cookiePin24H != null && domain != null) {
                String cookie = cookiePin24H;
                if (cookiePin24V != null) {
                    cookie = String.valueOf(cookie) + "; " + cookiePin24V;
                }
                COOKIES_PIN24H.put(domain, cookie);
            }
        }
    }

    public void setCookieIntranet(String cookie) {
        if (cookie != null) {
            COOKIES_INTRANET.put(this.url.getHost(), cookie);
        } else {
            COOKIES_INTRANET.remove(this.url.getHost());
        }
    }

    private void putCookieIntranet(URLConnection connection) {
        String cookie = this.getCookieIntranet(connection.getURL().getHost());
        if (cookie != null) {
            connection.setRequestProperty("Cookie", cookie);
        }
    }

    private String getCookieIntranet(String host) {
        if (COOKIES_INTRANET.containsKey(host)) {
            return COOKIES_INTRANET.get(host);
        }
        return null;
    }

    private void putCookiePIN24H(URLConnection connection) {
        Enumeration<String> domains = COOKIES_PIN24H.keys();
        while (domains.hasMoreElements()) {
            String domain = domains.nextElement();
            if (this.url.getHost().indexOf(domain) < 0) continue;
            connection.setRequestProperty("Cookie", COOKIES_PIN24H.get(domain));
        }
    }

    private String getCookiePIN24H(String host) {
        Enumeration<String> domains = COOKIES_PIN24H.keys();
        String cookie = null;
        while (domains.hasMoreElements()) {
            String domain = domains.nextElement();
            if (host.indexOf(domain) < 0) continue;
            cookie = COOKIES_PIN24H.get(domain);
        }
        return cookie;
    }

    public String toString() {
        String cookiePIN24H;
        String str = String.valueOf(this.url.toString()) + "\n";
        for (String key : this.postParamsOrder) {
            str = String.valueOf(str) + key + "=" + this.postParams.get(key) + "\n";
        }
        String cookieIntranet = this.getCookieIntranet(this.url.getHost());
        if (cookieIntranet != null) {
            str = String.valueOf(str) + "Cookie Intranet: " + cookieIntranet + "\n";
        }
        if ((cookiePIN24H = this.getCookiePIN24H(this.url.getHost())) != null) {
            str = String.valueOf(str) + "Cookie PIN24H: " + cookiePIN24H + "\n";
        }
        str = String.valueOf(str) + "\n";
        return str;
    }
}

