/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.http;

import es.gob.aeat.dit.ov.renta.http.HttpResponse;

public class AuthPIN24HResponse
extends HttpResponse {
    private static final String ERROR_STR_START = "<error>";
    private static final String ERROR_STR_END = "</error>";
    private static final String ERROR_CODE_START = "<codigo>";
    private static final String ERROR_CODE_END = "</codigo>";
    private static final String ERROR_DESC_START = "<descripcion>";
    private static final String ERROR_DESC_END = "</descripcion>";
    private static final String OK_STR_START = "<status>";
    private static final String OK_STR_END = "</status>";

    public AuthPIN24HResponse(HttpResponse resp) {
        super(resp);
    }

    public boolean isError() {
        String str = this.getContentAsText();
        return str.indexOf(ERROR_STR_START) >= 0 && str.indexOf(ERROR_STR_END) >= 0;
    }

    public String getError() {
        String str = this.getContentAsText();
        int errStart = str.indexOf(ERROR_CODE_START);
        String errorCode = null;
        if (errStart > 0) {
            int errEnd = str.indexOf(ERROR_CODE_END);
            errorCode = errEnd > errStart ? str.substring(errStart + ERROR_CODE_START.length(), errEnd).trim() : str.substring(errStart + ERROR_CODE_END.length()).trim();
        }
        errStart = str.indexOf(ERROR_DESC_START);
        String errorDesc = null;
        if (errStart > 0) {
            int errEnd = str.indexOf(ERROR_DESC_END);
            errorDesc = errEnd > errStart ? str.substring(errStart + ERROR_DESC_START.length(), errEnd).trim() : str.substring(errStart + ERROR_DESC_END.length()).trim();
        }
        String out = null;
        if (errorDesc != null) {
            out = errorDesc;
        }
        if (errorCode != null) {
            if (out == null) {
                out = "";
            }
            out = String.valueOf(out) + " (" + errorCode + ")";
        }
        if (out == null) {
            out = "NOERRORPAGE";
        }
        return out;
    }

    public boolean isOK() {
        String str = this.getContentAsText();
        int begin = str.indexOf(OK_STR_START);
        int end = str.indexOf(OK_STR_END);
        if (end > begin) {
            String status = str.substring(begin + OK_STR_START.length(), end);
            boolean isZero = true;
            int i = 0;
            while (i < status.length()) {
                isZero = isZero && status.substring(i, i + 1).equals("0");
                ++i;
            }
            return isZero;
        }
        return false;
    }
}

