/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.gui.CertificateSelectionListener;
import es.gob.aeat.dit.ov.renta.gui.WarningDialog;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import es.gob.aeat.dit.ov.renta.util.FixedLengthTextField;
import es.gob.aeat.dit.ov.renta.util.PinTextField;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.security.cert.CertificateException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

public class UserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField textNIF;
    private JTextField textApeNom;
    private FixedLengthTextField textRef;
    private PinTextField textClave;
    private PinTextField textPIN;
    private JButton btnCert;
    private JPanel panelCert;
    private JPanel panelRef;
    private JPanel panelPin;
    private String aliasCert;
    private JLabel lblCertificadoNoSeleccionado;
    private Enviroment env;
    private ArrayList<CertificateSelectionListener> csl = new ArrayList();

    public UserPanel() {
        this(true);
    }

    public UserPanel(boolean showAuthMethods) {
        this.env = Enviroment.getInstance();
        this.setBackground(Enviroment.COLOR_LIGHT);
        this.setBorder(new TitledBorder(null, "Declarante", 4, 2, null, null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        if (showAuthMethods) {
            int[] nArray = new int[4];
            nArray[0] = 90;
            nArray[1] = 300;
            nArray[2] = 410;
            gridBagLayout.columnWidths = nArray;
        } else {
            int[] nArray = new int[4];
            nArray[0] = 90;
            nArray[1] = 300;
            gridBagLayout.columnWidths = nArray;
        }
        int[] nArray = new int[3];
        nArray[1] = 23;
        gridBagLayout.rowHeights = nArray;
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JTextPane lblNif = new JTextPane();
        lblNif.setRequestFocusEnabled(false);
        lblNif.setFocusable(false);
        lblNif.setFocusCycleRoot(false);
        lblNif.setText("NIF");
        lblNif.setOpaque(false);
        lblNif.setEditable(false);
        GridBagConstraints gbc_lblNif = new GridBagConstraints();
        gbc_lblNif.fill = 2;
        gbc_lblNif.insets = new Insets(0, 5, 5, 5);
        gbc_lblNif.gridx = 0;
        gbc_lblNif.gridy = 0;
        this.add((Component)lblNif, gbc_lblNif);
        JTextPane lblApellidosYNombre = new JTextPane();
        lblApellidosYNombre.setRequestFocusEnabled(false);
        lblApellidosYNombre.setFocusable(false);
        lblApellidosYNombre.setFocusCycleRoot(false);
        lblApellidosYNombre.setOpaque(false);
        lblApellidosYNombre.setEditable(false);
        lblApellidosYNombre.setText(this.env.getString("UserPanel.ApeNom"));
        GridBagConstraints gbc_lblApellidosYNombre = new GridBagConstraints();
        gbc_lblApellidosYNombre.fill = 2;
        gbc_lblApellidosYNombre.insets = new Insets(0, 0, 5, 5);
        gbc_lblApellidosYNombre.gridx = 1;
        gbc_lblApellidosYNombre.gridy = 0;
        this.add((Component)lblApellidosYNombre, gbc_lblApellidosYNombre);
        this.textNIF = new JTextField();
        this.textNIF.setRequestFocusEnabled(false);
        this.textNIF.setFocusable(false);
        this.textNIF.setEditable(false);
        GridBagConstraints gbc_textNIF = new GridBagConstraints();
        gbc_textNIF.insets = new Insets(0, 5, 5, 5);
        gbc_textNIF.fill = 2;
        gbc_textNIF.gridx = 0;
        gbc_textNIF.gridy = 1;
        this.add((Component)this.textNIF, gbc_textNIF);
        this.textNIF.setColumns(10);
        this.textApeNom = new JTextField();
        this.textApeNom.setRequestFocusEnabled(false);
        this.textApeNom.setFocusable(false);
        this.textApeNom.setEditable(false);
        GridBagConstraints gbc_textApeNom = new GridBagConstraints();
        gbc_textApeNom.anchor = 11;
        gbc_textApeNom.insets = new Insets(0, 0, 0, 10);
        gbc_textApeNom.fill = 2;
        gbc_textApeNom.gridx = 1;
        gbc_textApeNom.gridy = 1;
        this.add((Component)this.textApeNom, gbc_textApeNom);
        this.textApeNom.setColumns(10);
        this.panelCert = new JPanel();
        this.panelCert.setOpaque(false);
        GridBagConstraints gbc_panelCert = new GridBagConstraints();
        gbc_panelCert.fill = 1;
        gbc_panelCert.gridx = 2;
        gbc_panelCert.gridy = 1;
        this.add((Component)this.panelCert, gbc_panelCert);
        GridBagLayout gbl_panelCert = new GridBagLayout();
        gbl_panelCert.columnWidths = new int[3];
        int[] nArray2 = new int[2];
        nArray2[0] = 23;
        gbl_panelCert.rowHeights = nArray2;
        gbl_panelCert.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panelCert.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelCert.setLayout(gbl_panelCert);
        this.btnCert = new JButton(this.env.getString("ContriPanel.JButCert"));
        this.btnCert.setBackground(Enviroment.COLOR_LIGHT);
        this.btnCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.selectCert();
            }
        });
        GridBagConstraints gbc_btnCert = new GridBagConstraints();
        gbc_btnCert.anchor = 11;
        gbc_btnCert.insets = new Insets(0, 0, 0, 5);
        gbc_btnCert.gridx = 0;
        gbc_btnCert.gridy = 0;
        this.panelCert.add((Component)this.btnCert, gbc_btnCert);
        this.lblCertificadoNoSeleccionado = new JLabel(this.env.getString("ContriPanel.cert"));
        this.lblCertificadoNoSeleccionado.setOpaque(false);
        this.lblCertificadoNoSeleccionado.setIcon(new ImageIcon(UserPanel.class.getResource("/es/gob/aeat/dit/ov/renta/resources/cert.png")));
        GridBagConstraints gbc_lblCertificadoNoSeleccionado = new GridBagConstraints();
        gbc_lblCertificadoNoSeleccionado.fill = 2;
        gbc_lblCertificadoNoSeleccionado.gridx = 1;
        gbc_lblCertificadoNoSeleccionado.gridy = 0;
        this.panelCert.add((Component)this.lblCertificadoNoSeleccionado, gbc_lblCertificadoNoSeleccionado);
        this.panelRef = new JPanel();
        this.panelRef.setOpaque(false);
        GridBagConstraints gbc_panelRef = new GridBagConstraints();
        gbc_panelRef.fill = 1;
        gbc_panelRef.gridx = 2;
        gbc_panelRef.gridy = 1;
        this.add((Component)this.panelRef, gbc_panelRef);
        GridBagLayout gbl_panelRef = new GridBagLayout();
        int[] nArray3 = new int[3];
        nArray3[1] = 120;
        gbl_panelRef.columnWidths = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 23;
        gbl_panelRef.rowHeights = nArray4;
        gbl_panelRef.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelRef.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelRef.setLayout(gbl_panelRef);
        JTextPane lblNmReferencia = new JTextPane();
        lblNmReferencia.setRequestFocusEnabled(false);
        lblNmReferencia.setFocusCycleRoot(false);
        lblNmReferencia.setFocusable(false);
        lblNmReferencia.setOpaque(false);
        lblNmReferencia.setEditable(false);
        lblNmReferencia.setText(this.env.getString("ContriPanel.jTPREFERENCIA"));
        GridBagConstraints gbc_lblNmReferencia = new GridBagConstraints();
        gbc_lblNmReferencia.insets = new Insets(0, 0, 0, 5);
        gbc_lblNmReferencia.anchor = 13;
        gbc_lblNmReferencia.gridx = 0;
        gbc_lblNmReferencia.gridy = 0;
        this.panelRef.add((Component)lblNmReferencia, gbc_lblNmReferencia);
        this.textRef = new FixedLengthTextField(12);
        GridBagConstraints gbc_textRef = new GridBagConstraints();
        gbc_textRef.fill = 2;
        gbc_textRef.gridx = 1;
        gbc_textRef.gridy = 0;
        this.panelRef.add((Component)this.textRef, gbc_textRef);
        this.textRef.setColumns(12);
        this.panelPin = new JPanel();
        this.panelPin.setOpaque(false);
        GridBagConstraints gbc_panelPin = new GridBagConstraints();
        gbc_panelPin.fill = 1;
        gbc_panelPin.gridx = 2;
        gbc_panelPin.gridy = 1;
        this.add((Component)this.panelPin, gbc_panelPin);
        GridBagLayout gbl_panelPin = new GridBagLayout();
        gbl_panelPin.columnWidths = new int[6];
        int[] nArray5 = new int[2];
        nArray5[0] = 23;
        gbl_panelPin.rowHeights = nArray5;
        gbl_panelPin.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelPin.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelPin.setLayout(gbl_panelPin);
        JButton btnNoTengoPinh = new JButton(this.env.getString("ContriPanel.linkPin"));
        btnNoTengoPinh.setBackground(Enviroment.COLOR_LIGHT);
        btnNoTengoPinh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.showPINPage();
            }
        });
        GridBagConstraints gbc_btnNoTengoPinh = new GridBagConstraints();
        gbc_btnNoTengoPinh.gridx = 0;
        gbc_btnNoTengoPinh.gridy = 0;
        gbc_btnNoTengoPinh.insets.right = 10;
        this.panelPin.add((Component)btnNoTengoPinh, gbc_btnNoTengoPinh);
        JTextPane lblClave = new JTextPane();
        lblClave.setFocusable(false);
        lblClave.setFocusCycleRoot(false);
        lblClave.setRequestFocusEnabled(false);
        lblClave.setOpaque(false);
        lblClave.setEditable(false);
        lblClave.setText(this.env.getString("ContriPanel.jTPCLAVE"));
        GridBagConstraints gbc_lblClave = new GridBagConstraints();
        gbc_lblClave.anchor = 13;
        gbc_lblClave.gridx = 1;
        gbc_lblClave.gridy = 0;
        this.panelPin.add((Component)lblClave, gbc_lblClave);
        this.textClave = new PinTextField(4);
        GridBagConstraints gbc_textClave = new GridBagConstraints();
        gbc_textClave.insets = new Insets(0, 0, 0, 5);
        gbc_textClave.fill = 2;
        gbc_textClave.gridx = 2;
        gbc_textClave.gridy = 0;
        this.panelPin.add((Component)this.textClave, gbc_textClave);
        this.textClave.setColumns(4);
        JTextPane lblPin = new JTextPane();
        lblPin.setFocusable(false);
        lblPin.setFocusCycleRoot(false);
        lblPin.setRequestFocusEnabled(false);
        lblPin.setOpaque(false);
        lblPin.setEditable(false);
        lblPin.setText(this.env.getString("ContriPanel.jTPPIN"));
        GridBagConstraints gbc_lblPin = new GridBagConstraints();
        gbc_lblPin.anchor = 13;
        gbc_lblPin.gridx = 3;
        gbc_lblPin.gridy = 0;
        this.panelPin.add((Component)lblPin, gbc_lblPin);
        this.textPIN = new PinTextField(3);
        GridBagConstraints gbc_textPIN = new GridBagConstraints();
        gbc_textPIN.fill = 2;
        gbc_textPIN.gridx = 4;
        gbc_textPIN.gridy = 0;
        this.panelPin.add((Component)this.textPIN, gbc_textPIN);
        this.textPIN.setColumns(3);
    }

    public void addCertificateSelectionListener(CertificateSelectionListener listener) {
        this.csl.add(listener);
    }

    public void resetCert() {
        this.lblCertificadoNoSeleccionado.setText(this.env.getString("ContriPanel.cert"));
        this.lblCertificadoNoSeleccionado.setToolTipText(null);
        this.aliasCert = null;
    }

    public void disableCertButon() {
        this.btnCert.setEnabled(false);
    }

    public void setAliasCert(String alias, String certStr) {
        this.panelCert.setMaximumSize(this.panelCert.getSize());
        this.panelCert.setMinimumSize(this.panelCert.getSize());
        this.panelCert.setPreferredSize(this.panelCert.getSize());
        this.panelPin.setMaximumSize(this.panelCert.getSize());
        this.panelPin.setMinimumSize(this.panelCert.getSize());
        this.panelPin.setPreferredSize(this.panelCert.getSize());
        this.panelRef.setMaximumSize(this.panelCert.getSize());
        this.panelRef.setMinimumSize(this.panelCert.getSize());
        this.panelRef.setPreferredSize(this.panelCert.getSize());
        this.lblCertificadoNoSeleccionado.setText(certStr);
        this.lblCertificadoNoSeleccionado.setToolTipText(certStr);
        this.aliasCert = alias;
    }

    private void selectCert() {
        RentaKeyManager rkm = RentaKeyManager.getInstance();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String alias = null;
        try {
            alias = rkm.selectAlias();
        }
        catch (CertificateException e1) {
            String msg = this.env.getString("RentaKeyManager.EmptyKS");
            msg = String.valueOf(msg) + Util.getDefaultBrowserString();
            WarningDialog.showMessageDialog(this, msg, this.env.getString("ContriPanel.ErrTitle"));
        }
        if (alias != null) {
            try {
                if (rkm.isCertDNIEAuthentication(alias)) {
                    WarningDialog.showMessageDialog(this, this.env.getString("RentaKeyManager.ErrDniA"), this.env.getString("ContriPanel.ErrTitle"));
                    this.resetCert();
                } else {
                    String certStr = rkm.getCertCN(alias);
                    this.setAliasCert(alias, certStr);
                    int i = 0;
                    while (i < this.csl.size()) {
                        this.csl.get(i).certificateSelected(this.aliasCert, this.getNIF(), certStr);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("UserPanel.ErrCert")) + "\n" + e.getMessage(), this.env.getString("ContriPanel.ErrTitle"));
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "selectCert", "Error seleccionando certificado", e);
                this.resetCert();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void showPINPage() {
        try {
            String url = "#";
            url = Enviroment.getInstance().getURL(3);
            url = String.valueOf(url) + "nif=" + this.textNIF.getText().trim();
            Util.showLinkInBrowser(this, url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFormaPresentacion(int formaPres) {
        this.showNone();
        switch (formaPres) {
            case 2: {
                this.showRef();
                break;
            }
            case 1: {
                this.showPIN();
                break;
            }
            default: {
                this.showCert();
            }
        }
    }

    public void showCert() {
        this.showNone();
        this.panelCert.setVisible(true);
    }

    public void showRef() {
        this.showNone();
        this.panelRef.setVisible(true);
    }

    public void showPIN() {
        this.showNone();
        this.panelPin.setVisible(true);
    }

    public void showNone() {
        this.panelCert.setVisible(false);
        this.panelRef.setVisible(false);
        this.panelPin.setVisible(false);
    }

    public void setNIF(String nif) {
        this.textNIF.setText(nif.trim().toUpperCase());
    }

    public String getNIF() {
        return this.textNIF.getText();
    }

    public String getApeNom() {
        return this.textApeNom.getText();
    }

    public void setApeNom(String ape) {
        this.textApeNom.setText(ape.trim().toUpperCase());
    }

    public void setDesc(String desc) {
        TitledBorder tb = (TitledBorder)this.getBorder();
        tb.setTitle(desc);
    }

    public String getAliasCert() {
        return this.aliasCert;
    }

    public String getInfoCert() {
        return this.lblCertificadoNoSeleccionado.getText().trim();
    }

    public String getClave() {
        return this.textClave.getText();
    }

    public String getPIN() {
        return this.textPIN.getText();
    }

    public String getNumRef() {
        return this.textRef.getText();
    }

    public PIN24HId getPinID() {
        return new PIN24HId(this.getNIF(), this.getClave(), this.getPIN());
    }

    public int getWidthIdPart() {
        return this.textNIF.getWidth() + this.textApeNom.getWidth() + 20;
    }
}

